/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.forge.platform;

import customskinloader.forge.ForgeTweaker;
import java.io.File;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import org.objectweb.asm.commons.Remapper;

public interface IFMLPlatform {
    public Result init(Set<IFMLPlatform> var1);

    public String getSide();

    public List<String> getIgnoredMods();

    public String getName();

    public int getSortingIndex();

    public ITweaker createFMLPluginWrapper(String var1, File var2, int var3) throws Exception;

    public void addLoadPlugins(ITweaker var1) throws Exception;

    public Remapper getRemapper();

    public static class FMLPlatformInitializer {
        private static IFMLPlatform platform;

        public static void initFMLPlatform() throws Exception {
            HashSet<IFMLPlatform> platforms = new HashSet<IFMLPlatform>();
            ArrayList<Throwable> throwables = new ArrayList<Throwable>();
            Iterator<IFMLPlatform> iterator = ServiceLoader.load(IFMLPlatform.class).iterator();
            while (iterator.hasNext()) {
                try {
                    platforms.add(iterator.next());
                }
                catch (Throwable t) {
                    throwables.add(t);
                }
            }
            for (IFMLPlatform platform0 : platforms) {
                HashSet<IFMLPlatform> otherPlatforms = new HashSet<IFMLPlatform>(platforms);
                otherPlatforms.remove(platform0);
                if (!platform0.init(otherPlatforms).equals((Object)Result.ACCEPT)) continue;
                if (platform == null) {
                    platform = platform0;
                    continue;
                }
                throw new RuntimeException("Duplicated platforms! (" + platform.getClass().getName() + ", " + platform0 + ")");
            }
            if (platform == null) {
                int len = throwables.size();
                for (int i = 0; i < len; ++i) {
                    Throwable throwable = (Throwable)throwables.get(i);
                    ForgeTweaker.logger.warning("Platform - %s :", i);
                    ForgeTweaker.logger.warning(throwable);
                }
                throw new RuntimeException("No available platform!");
            }
            if (!platform.getSide().equals("CLIENT")) {
                return;
            }
            CodeSource codeSource = FMLPlatformInitializer.class.getProtectionDomain().getCodeSource();
            if (codeSource != null) {
                URL location = codeSource.getLocation();
                File file = new File(location.toURI());
                if (file.isFile()) {
                    platform.getIgnoredMods().remove(file.getName());
                }
                ITweaker tweaker = platform.createFMLPluginWrapper(platform.getName(), file, platform.getSortingIndex());
                platform.addLoadPlugins(tweaker);
                ((List)Launch.blackboard.get("Tweaks")).add(tweaker);
            } else {
                ForgeTweaker.logger.warning("No CodeSource, if this is not a development environment we might run into problems!");
                ForgeTweaker.logger.warning(FMLPlatformInitializer.class.getProtectionDomain().toString());
            }
        }

        public static IFMLPlatform getPlatform() {
            return platform;
        }
    }

    public static enum Result {
        ACCEPT,
        REJECT;

    }
}

