/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.dimensions.iceika;

import divinerpg.registry.BlockRegistry;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class IceTreeGen
extends WorldGenAbstractTree {
    private final boolean fromSapling;

    public IceTreeGen(boolean notify, boolean fromSapling) {
        super(notify);
        this.fromSapling = fromSapling;
    }

    protected boolean func_150523_a(Block blockType) {
        return blockType == BlockRegistry.frozenDirt || blockType == BlockRegistry.frozenGrass;
    }

    protected void func_175921_a(World worldIn, BlockPos pos) {
        if (!this.func_150523_a(worldIn.func_180495_p(pos).func_177230_c())) {
            this.func_175903_a(worldIn, pos, BlockRegistry.frozenGrass.func_176223_P());
        }
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int height = 20 + rand.nextInt(10);
        if (!this.func_150523_a(worldIn.func_180495_p(position.func_177977_b()).func_177230_c())) {
            return false;
        }
        if (!this.hasFreeSpace(worldIn, rand, position, height)) {
            return false;
        }
        if (this.fromSapling && (position = this.getSpawnPosition(worldIn, position)) == null) {
            return false;
        }
        BlockPos.func_177980_a((BlockPos)position.func_177977_b(), (BlockPos)position.func_177982_a(1, -1, 1)).forEach(x -> this.func_175921_a(worldIn, (BlockPos)x));
        IBlockState leaves = BlockRegistry.brittleLeaves.func_176223_P();
        this.genLeaves(worldIn, rand, leaves, height - (1 + rand.nextInt(12)), height, position.func_177982_a(1, 0, 1));
        BlockPos.func_177980_a((BlockPos)position.func_177982_a(0, 0, 0), (BlockPos)position.func_177982_a(1, height - rand.nextInt(3), 1)).forEach(x -> this.func_175903_a(worldIn, (BlockPos)x, BlockRegistry.frozenLog.func_176223_P()));
        return true;
    }

    private boolean hasFreeSpace(World worldIn, Random rand, BlockPos position, int height) {
        if (position.func_177956_o() + height > worldIn.func_72800_K()) {
            return false;
        }
        AtomicBoolean canGenerate = new AtomicBoolean(true);
        BlockPos.func_177975_b((BlockPos)position.func_177984_a(), (BlockPos)position.func_177982_a(1, height, 0)).forEach(x -> {
            boolean canReplace;
            IBlockState state = worldIn.func_180495_p((BlockPos)x);
            boolean bl = canReplace = state.func_177230_c().isAir(state, (IBlockAccess)worldIn, (BlockPos)x) || state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, (BlockPos)x);
            if (!canReplace) {
                canGenerate.set(false);
            }
        });
        return canGenerate.get();
    }

    @Nullable
    private BlockPos getSpawnPosition(World world, BlockPos position) {
        HashMap blockMap = new HashMap();
        BlockPos.func_177980_a((BlockPos)position.func_177982_a(-1, 0, -1), (BlockPos)position.func_177982_a(1, 0, 1)).forEach(x -> {
            if (!x.equals((Object)position)) {
                blockMap.put(x, world.func_180495_p(x).func_177230_c());
            }
            blockMap.put(x.func_177977_b(), world.func_180495_p(x.func_177977_b()).func_177230_c());
        });
        for (int x2 = -1; x2 < 1; ++x2) {
            for (int z = -1; z < 1; ++z) {
                AtomicBoolean isMatch = new AtomicBoolean(true);
                BlockPos.func_177980_a((BlockPos)position.func_177982_a(x2, 0, z), (BlockPos)position.func_177982_a(x2 + 1, 0, z + 1)).forEach(p -> {
                    Block block = (Block)blockMap.get(p);
                    if (block != null && block != BlockRegistry.frozenSapling || !this.func_150523_a((Block)blockMap.get(p.func_177977_b()))) {
                        isMatch.set(false);
                    }
                });
                if (!isMatch.get()) continue;
                return position.func_177982_a(x2, 0, z);
            }
        }
        return null;
    }

    private void genLeaves(World world, Random random, IBlockState leaves, int leafHeight, int height, BlockPos position) {
        boolean flag1 = false;
        int l1 = random.nextInt(2);
        int j2 = 1;
        int l = 2 + random.nextInt(9);
        for (int i3 = 0; i3 <= leafHeight; ++i3) {
            int k3 = position.func_177956_o() + height - i3;
            for (int i4 = position.func_177958_n() - l1; i4 <= position.func_177958_n() + l1; ++i4) {
                int k4 = i4 - position.func_177958_n();
                for (int l4 = position.func_177952_p() - l1; l4 <= position.func_177952_p() + l1; ++l4) {
                    int i5 = l4 - position.func_177952_p();
                    if (Math.abs(k4) == l1 && Math.abs(i5) == l1 && l1 > 0) continue;
                    BlockPos pos = new BlockPos(i4, k3, l4);
                    BlockPos.func_177980_a((BlockPos)pos, (BlockPos)pos.func_177982_a(-1, 0, -1)).forEach(x -> {
                        IBlockState state = world.func_180495_p(x);
                        if (state.func_177230_c().canBeReplacedByLeaves(state, (IBlockAccess)world, x)) {
                            this.func_175903_a(world, (BlockPos)x, leaves);
                        }
                    });
                }
            }
            if (l1 >= j2) {
                l1 = flag1 ? 1 : 0;
                flag1 = true;
                if (++j2 <= l) continue;
                j2 = l;
                continue;
            }
            ++l1;
        }
    }
}

