/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.entities.ai;

import divinerpg.objects.entities.ai.ILaunchFireBall;
import divinerpg.objects.entities.ai.ILaunchThrowable;
import java.util.Random;
import java.util.function.BiFunction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class AIDivineFireballAttack
extends EntityAIBase {
    private final EntityLiving parentEntity;
    private final BiFunction<EntityLivingBase, Entity, Entity> createFireballFunc;
    public int attackTimer;
    private final int attackDelay;
    private final int maxDistance;
    private final SoundEvent beforeShoot;
    private final SoundEvent onShoot;

    public AIDivineFireballAttack(EntityLiving parentEntity, BiFunction<EntityLivingBase, Entity, Entity> createFireballFunc, int attackDelay, int maxDistance, SoundEvent beforeShoot, SoundEvent onShoot) {
        this.parentEntity = parentEntity;
        this.createFireballFunc = createFireballFunc;
        this.attackDelay = attackDelay;
        this.maxDistance = maxDistance;
        this.beforeShoot = beforeShoot;
        this.onShoot = onShoot;
    }

    public AIDivineFireballAttack(EntityLiving ghast, ILaunchFireBall func) {
        this(ghast, func::createFireball, 20, 64, SoundEvents.field_187559_bL, SoundEvents.field_187557_bK);
    }

    public AIDivineFireballAttack(EntityLiving ghast, ILaunchFireBall createFireball, SoundEvent onShoot) {
        this(ghast, createFireball::createFireball, 20, 64, null, onShoot);
    }

    public AIDivineFireballAttack(EntityLiving ghast, ILaunchThrowable createThrowable, SoundEvent onShoot) {
        this(ghast, createThrowable::createFireball, 20, 64, null, onShoot);
    }

    public boolean func_75250_a() {
        return this.parentEntity.func_70638_az() != null;
    }

    public void func_75249_e() {
        this.attackTimer = 0;
    }

    public void func_75251_c() {
        this.parentEntity.func_70624_b(null);
    }

    public void func_75246_d() {
        EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
        if (Math.sqrt(entitylivingbase.func_70068_e((Entity)this.parentEntity)) < (double)this.maxDistance && this.parentEntity.func_70685_l((Entity)entitylivingbase)) {
            World world = this.parentEntity.field_70170_p;
            ++this.attackTimer;
            if (this.attackTimer == this.attackDelay - 10) {
                this.playSound(this.beforeShoot);
            }
            if (this.attackTimer == this.attackDelay) {
                this.playSound(this.onShoot);
                world.func_72838_d(this.createFireballFunc.apply((EntityLivingBase)this.parentEntity, (Entity)entitylivingbase));
                this.attackTimer = this.attackDelay * -2;
            }
        } else if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.attackTimer <= 10) {
            // empty if block
        }
    }

    private void playSound(SoundEvent event) {
        if (this.parentEntity == null || this.parentEntity.field_70170_p == null || event == null) {
            return;
        }
        Random rand = this.parentEntity.field_70170_p.field_73012_v;
        this.parentEntity.field_70170_p.func_184133_a(null, this.parentEntity.func_180425_c(), event, SoundCategory.HOSTILE, 10.0f, (rand.nextFloat() - rand.nextFloat()) * 0.2f + 1.0f);
    }
}

