/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.entities.entity.projectiles;

import divinerpg.enums.DiskType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityDisk
extends EntityThrowable {
    private static final DataParameter<Byte> DISK_ID = EntityDataManager.func_187226_a(EntityDisk.class, (DataSerializer)DataSerializers.field_187191_a);
    private DiskType diskType;
    public float damage;
    public int counter;
    public int icon;
    public Item item;
    private int bounces;

    public EntityDisk(World world) {
        super(world);
    }

    public EntityDisk(World world, EntityLivingBase entity, DiskType diskType, Item item) {
        super(world, entity);
        this.diskType = diskType;
        this.setDiskId((byte)diskType.ordinal());
        this.damage = diskType.getDamage();
        this.counter = 30;
        this.item = item;
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DISK_ID, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70159_w /= 0.99;
        this.field_70181_x /= 0.99;
        this.field_70179_y /= 0.99;
        if (this.counter == 0 && this.func_85052_h() != null) {
            this.field_70159_w *= -1.0;
            this.field_70181_x *= -1.0;
            this.field_70179_y *= -1.0;
            ++this.bounces;
            this.counter = 30;
        } else if (this.counter > 0) {
            --this.counter;
        }
        if (this.bounces >= 12 && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    public void func_70184_a(RayTraceResult result) {
        if (this.func_85052_h() != null) {
            if (result.field_72308_g != null && result.field_72308_g != this.func_85052_h()) {
                result.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), this.damage);
            } else if (result.field_72308_g == this.func_85052_h() && this.func_85052_h() instanceof EntityPlayer && this.bounces > 0) {
                if (!((EntityPlayer)this.func_85052_h()).field_71075_bZ.field_75098_d) {
                    ((EntityPlayer)this.func_85052_h()).field_71071_by.func_70441_a(new ItemStack(this.item));
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70106_y();
                }
            }
            if (this.bounces == 0) {
                this.counter = 0;
                ++this.bounces;
            }
        } else if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    public float func_70185_h() {
        return 0.0f;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a("projectileId", this.getDiskId());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setDiskId(compound.func_74771_c("projectileId"));
        this.diskType = DiskType.getDiskFromOrdinal(this.getDiskId());
    }

    private byte getDiskId() {
        return (Byte)this.field_70180_af.func_187225_a(DISK_ID);
    }

    private void setDiskId(byte projectileId) {
        this.field_70180_af.func_187227_b(DISK_ID, (Object)projectileId);
    }

    public DiskType getDiskType() {
        if (this.diskType == null) {
            this.diskType = DiskType.getDiskFromOrdinal(this.getDiskId());
        }
        return this.diskType;
    }

    public ResourceLocation getTexture() {
        return this.getDiskType().getTexture();
    }
}

