/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.structure.base;

import divinerpg.utils.WorldGenUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.template.TemplateManager;

public abstract class DivineLargeStructure
extends MapGenStructure {
    protected final String structureName;
    protected final TemplateManager manager;
    protected final ResourceLocation folder;
    protected final int generationChance;

    public DivineLargeStructure(World world, String structureName, ResourceLocation folder, int chance) {
        this.structureName = structureName;
        this.folder = folder;
        this.manager = world.func_72860_G().func_186340_h();
        this.generationChance = chance;
    }

    public String func_143025_a() {
        return this.structureName;
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        WorldGenUtils.seedRandomWithOffset(this.field_75038_b, this.getResourceLocationHashCode(), this.field_75039_c, chunkX, chunkZ);
        return this.field_75038_b.nextInt(this.generationChance) == 0;
    }

    protected int getResourceLocationHashCode() {
        return this.folder.hashCode();
    }

    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        boolean i = true;
        int j = pos.func_177958_n() >> 4;
        int k = pos.func_177952_p() >> 4;
        for (int l = 0; l <= 1000; ++l) {
            for (int i1 = -l; i1 <= l; ++i1) {
                boolean flag = i1 == -l || i1 == l;
                for (int j1 = -l; j1 <= l; ++j1) {
                    boolean flag1;
                    boolean bl = flag1 = j1 == -l || j1 == l;
                    if (!flag && !flag1) continue;
                    int k1 = j + i1;
                    int l1 = k + j1;
                    this.field_75038_b.setSeed((long)(k1 ^ l1) ^ worldIn.func_72905_C());
                    this.field_75038_b.nextInt();
                    if (!this.func_75047_a(k1, l1) || findUnexplored && worldIn.func_190526_b(k1, l1)) continue;
                    return new BlockPos((k1 << 4) + 8, 64, (l1 << 4) + 8);
                }
            }
        }
        return null;
    }
}

