/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.utils;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class PositionHelper {
    public static RayTraceResult rayTrace(EntityPlayer player, double blockReachDistance, int partialTicks) {
        Vec3d vec3d = player.func_174824_e((float)partialTicks);
        Vec3d vec3d1 = player.func_70676_i((float)partialTicks);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * blockReachDistance, vec3d1.field_72448_b * blockReachDistance, vec3d1.field_72449_c * blockReachDistance);
        return player.field_70170_p.func_147447_a(vec3d, vec3d2, false, false, true);
    }

    public static Tuple<Vec3d, Vec3d> getRayTraceVecs(Entity player, double blockReachDistance) {
        Vec3d startVec = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Vec3d endVec = startVec.func_178787_e(player.func_70676_i(0.0f).func_186678_a(blockReachDistance));
        return new Tuple((Object)startVec, (Object)endVec);
    }

    public static RayTraceResult rayTrace(EntityPlayer e, boolean stopOnLiquid) {
        Tuple<Vec3d, Vec3d> vecs = PositionHelper.getRayTraceVecs((Entity)e, PositionHelper.getBlockReachDistance(e));
        return e.field_70170_p.func_147447_a((Vec3d)vecs.func_76341_a(), (Vec3d)vecs.func_76340_b(), stopOnLiquid, false, true);
    }

    public static double getBlockReachDistance(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return Minecraft.func_71410_x().field_71442_b.func_78757_d();
        }
        return player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
    }

    public static void moveBullet(EntityPlayer player, EntityThrowable bullet) {
        if (player == null || bullet == null) {
            return;
        }
        Vec3d vector = player.func_70040_Z().func_186678_a(2.0).func_178787_e(bullet.func_174791_d());
        bullet.func_70107_b(vector.field_72450_a, vector.field_72448_b, vector.field_72449_c);
    }

    @Nullable
    public static Entity rayTrace(Entity player, float range) {
        double fix = 0.3;
        Tuple<Vec3d, Vec3d> vecs = PositionHelper.getRayTraceVecs(player, range);
        Vec3d start = (Vec3d)vecs.func_76341_a();
        Vec3d end = (Vec3d)vecs.func_76340_b();
        AxisAlignedBB cube = new AxisAlignedBB(start, end);
        for (Entity entity : player.func_130014_f_().func_72839_b(player, cube)) {
            RayTraceResult optional = entity.func_174813_aQ().func_186662_g(1.0).func_72327_a(start, end);
            if (optional == null || !(start.func_72438_d(optional.field_72307_f) <= (double)range)) continue;
            return entity;
        }
        return null;
    }

    public static BlockPos searchInRadius(World world, BlockPos center, int diameter, Predicate<BlockPos> action) {
        return PositionHelper.searchInRadius(world, center, new BlockPos(diameter, diameter, diameter), action);
    }

    public static BlockPos searchInRadius(World world, BlockPos center, BlockPos range, Predicate<BlockPos> action) {
        int xRadius = 0;
        while ((double)xRadius <= Math.floor((double)range.func_177958_n() / 2.0)) {
            int yRadius = 0;
            while ((double)yRadius <= Math.floor((double)range.func_177956_o() / 2.0)) {
                int zRadius = 0;
                while ((double)zRadius <= Math.floor((double)range.func_177952_p() / 2.0)) {
                    for (int x = -1; x <= 1; x += 2) {
                        for (int y = -1; y <= 1; y += 2) {
                            for (int z = -1; z <= 1; z += 2) {
                                BlockPos pos = center.func_177982_a(x * xRadius, y * yRadius, z * zRadius);
                                if (world.func_189509_E(pos) || !action.test(pos)) continue;
                                return pos;
                            }
                        }
                    }
                    ++zRadius;
                }
                ++yRadius;
            }
            ++xRadius;
        }
        return center;
    }
}

