/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.utils;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.util.UUIDTypeAdapter;
import divinerpg.registry.BlockRegistry;
import io.netty.util.internal.ConcurrentSet;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.io.IOUtils;

public class Utils {
    public static int mobID = 500;
    public static int projectileID = 0;
    public static int entityListID = 2500;
    public static DamageSource trapSource = new DamageSource("trap");
    public static DamageSource acidSource = new DamageSource("acid");
    public static DamageSource spikeSource = new DamageSource("spike");
    public static DamageSource arcanaSource = new DamageSource("arcana");
    private static Set<UUID> DEV_LIST = new ConcurrentSet();
    private static Set<UUID> TESTER_LIST = new ConcurrentSet();
    private static Set<UUID> PATRON_LIST = new ConcurrentSet();
    private static Set<UUID> ARTIST_LIST = new ConcurrentSet();
    private static Set<UUID> FRIEND_LIST = new ConcurrentSet();

    public static boolean isDeveloperName(UUID name) {
        return DEV_LIST.contains(name);
    }

    public static boolean isTesterName(UUID name) {
        return TESTER_LIST.contains(name);
    }

    public static boolean isPatreon(UUID name) {
        return PATRON_LIST.contains(name);
    }

    public static boolean isArtist(UUID name) {
        return ARTIST_LIST.contains(name);
    }

    public static boolean isFriend(UUID name) {
        return FRIEND_LIST.contains(name);
    }

    public static void loadHatInformation() {
        CompletableFuture.supplyAsync(() -> {
            String urlString = "https://raw.githubusercontent.com/DivineRPG/DivineRPG/1.12.2/hat_lists/hats.json";
            try {
                HttpURLConnection con = (HttpURLConnection)new URL(urlString).openConnection();
                con.setConnectTimeout(1000);
                InputStream in2 = con.getInputStream();
                List lines = IOUtils.readLines((InputStream)in2, (Charset)Charset.defaultCharset());
                return String.join((CharSequence)"\n", lines);
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }).thenApply(rawJson -> {
            DEV_LIST.clear();
            TESTER_LIST.clear();
            PATRON_LIST.clear();
            ARTIST_LIST.clear();
            FRIEND_LIST.clear();
            if (rawJson != null) {
                try {
                    HatsInfo info = (HatsInfo)new Gson().fromJson(rawJson, HatsInfo.class);
                    if (info != null) {
                        DEV_LIST.addAll(info.dev);
                        TESTER_LIST.addAll(info.tester);
                        PATRON_LIST.addAll(info.patreon);
                        ARTIST_LIST.addAll(info.artists);
                        FRIEND_LIST.addAll(info.friend);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return rawJson;
        });
    }

    public static CompletableFuture<UUID> getLicenceId(String nick) {
        return CompletableFuture.supplyAsync(() -> {
            String url = "https://api.mojang.com/users/profiles/minecraft/" + nick;
            UUID result = new UUID(0L, 0L);
            try {
                HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
                connection.setRequestMethod("GET");
                InputStream stream = connection.getInputStream();
                String json = IOUtils.toString((InputStream)stream, (Charset)Charset.defaultCharset());
                JsonObject object = (JsonObject)new Gson().fromJson(json, JsonObject.class);
                if (!object.has("error")) {
                    result = UUIDTypeAdapter.fromString((String)object.get("id").getAsString());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return result;
        });
    }

    public static DamageSource causeArcanaDamage(Entity projectile, Entity shooter) {
        return new EntityDamageSourceIndirect("arrow", projectile, shooter).func_82726_p();
    }

    public static boolean bordersTar(World world, int x, int y, int z) {
        for (int i = x - 4; i <= x + 4; ++i) {
            for (int j = y; j <= y + 1; ++j) {
                for (int k = z - 4; k <= z + 4; ++k) {
                    if (world.func_180495_p(new BlockPos(i, j, k)).func_177230_c() != BlockRegistry.smolderingTar) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean bordersTar(World w, BlockPos pos) {
        return Utils.bordersTar(w, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static int getSurfaceBlockY(World world, int x, int z) {
        return Utils.getSurfaceBlockY(world, x, z, null);
    }

    public static int getSurfaceBlockY(World world, int x, int z, @Nullable Block topBlock) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, 0, z);
        for (int i = world.func_175726_f(new BlockPos(x, 0, z)).func_76625_h() + 16; i > 0; --i) {
            pos.func_185336_p(i);
            IBlockState state = world.func_180495_p((BlockPos)pos);
            Block block = state.func_177230_c();
            if (!(topBlock != null ? topBlock == block : block.isAir(state, (IBlockAccess)world, (BlockPos)pos) || block.func_176200_f((IBlockAccess)world, (BlockPos)pos) || block.isWood((IBlockAccess)world, (BlockPos)pos) || block.isFoliage((IBlockAccess)world, (BlockPos)pos) || state.func_185904_a() == Material.field_151585_k || block.isLeaves(state, (IBlockAccess)world, (BlockPos)pos) || block.canBeReplacedByLeaves(state, (IBlockAccess)world, (BlockPos)pos))) continue;
            return i;
        }
        return 0;
    }

    public static int getIndex(int x, int y, int z, int max) {
        return x + (max + 1) * y + (max + 1) * (max + 1) * z;
    }

    public class HatsInfo {
        public List<UUID> dev;
        public List<UUID> tester;
        public List<UUID> patreon;
        public List<UUID> artists;
        public List<UUID> friend;
    }
}

