/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.lib;

import com.brandon3055.brandonscore.registry.ModConfigContainer;
import com.brandon3055.brandonscore.registry.ModConfigProperty;
import com.brandon3055.draconicevolution.api.fusioncrafting.FusionRecipeAPI;
import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionRecipe;
import com.brandon3055.draconicevolution.api.fusioncrafting.SimpleFusionRecipe;
import com.brandon3055.draconicevolution.utils.LogHelper;
import java.util.List;
import net.foxmcloud.draconicadditions.DraconicAdditions;
import org.apache.logging.log4j.Level;

@ModConfigContainer(modid="draconicadditions")
public class FusionCostMultiplier {
    @ModConfigProperty(category="Misc Tweaks", name="Fusion Crafting Cost Multiplier", comment="Allows you to adjust the multiplier on fusion crafting.  Mainly intended for modpack authors; this config is NOT automatically updated when you join another server, and you must restart Minecraft for this config to take effect.", requiresMCRestart=true, requiresSync=true)
    @ModConfigProperty.MinMax(min="0", max="10")
    public static double POWER_COST_MULTIPLIER = 1.0;

    public static void postInit() {
        if (POWER_COST_MULTIPLIER == 1.0) {
            DraconicAdditions.logger.log(Level.INFO, "Power costs are not modified. Skipping recipe rebalance.");
            return;
        }
        List recipes = FusionRecipeAPI.getRecipes();
        DraconicAdditions.logger.log(Level.INFO, "Starting takeover of Draconic Evolution. Don't worry, I won't be taking you over for very long!");
        LogHelper.info((Object)"wat, i didnt sign up for thi- !!!");
        LogHelper.info((Object)("Takeover complete. Beginning recipe rebalancing at power level " + POWER_COST_MULTIPLIER + "."));
        for (IFusionRecipe oldRecipe : recipes) {
            if (!oldRecipe.getRecipeCatalyst().func_190926_b()) {
                LogHelper.dev((Object)(oldRecipe.getRecipeOutput(oldRecipe.getRecipeCatalyst()).func_77973_b().func_77658_a() + " was " + oldRecipe.getIngredientEnergyCost()));
                FusionRecipeAPI.removeRecipe((IFusionRecipe)oldRecipe);
                SimpleFusionRecipe newRecipe = new SimpleFusionRecipe(oldRecipe.getRecipeOutput(oldRecipe.getRecipeCatalyst()), oldRecipe.getRecipeCatalyst(), (long)((double)oldRecipe.getIngredientEnergyCost() * POWER_COST_MULTIPLIER), oldRecipe.getRecipeTier(), oldRecipe.getRecipeIngredients().toArray());
                FusionRecipeAPI.addRecipe((IFusionRecipe)newRecipe);
                if (!FusionRecipeAPI.getRecipes().contains(newRecipe)) {
                    FusionRecipeAPI.addRecipe((IFusionRecipe)oldRecipe);
                    if (FusionRecipeAPI.getRecipes().contains(oldRecipe)) continue;
                    LogHelper.error((Object)"One of the recipes in the fusion crafting database cannot be changed. You must set the Fusion Cost Multiplier to 1 and re-run Minecraft.");
                    throw new Error("Fusion Crafting cannot be changed for some reason.  Set the Fusion Cost Multiplier to 1 for Draconic Additions and restart Minecraft.");
                }
                LogHelper.dev((Object)(newRecipe.getRecipeOutput(newRecipe.getRecipeCatalyst()).func_77973_b().func_77658_a() + " now " + newRecipe.getIngredientEnergyCost()));
                continue;
            }
            if (oldRecipe.getRecipeOutput(oldRecipe.getRecipeCatalyst()).func_77973_b().func_77658_a().contains("air")) {
                LogHelper.dev((Object)"Recipe is an upgrade and cannot be changed.  Skipping... ");
                continue;
            }
            LogHelper.dev((Object)("Recipe with catalyst " + oldRecipe.getRecipeOutput(oldRecipe.getRecipeCatalyst()).func_77973_b().func_77658_a() + " is not compatible.  Skipping... "));
        }
        LogHelper.info((Object)"Recipe rebalancing complete. Returning control of Draconic Evolution to it's owner.");
        LogHelper.info((Object)"OK, that was just rude");
        DraconicAdditions.logger.log(Level.INFO, "Hey, I've got a job to do, okay? It's not like either of us will remember this next time it happens.");
        LogHelper.info((Object)"Fair enough...");
    }
}

