/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.AbstractConditional;
import crazypants.enderio.base.config.recipes.xml.Item;
import crazypants.enderio.base.config.recipes.xml.Potion;
import crazypants.enderio.base.recipe.RecipeLevel;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.PotionHelper;
import net.minecraft.potion.PotionType;

public class Brewing
extends AbstractConditional {
    private Optional<Item> input = this.empty();
    private Optional<Potion> in = this.empty();
    private Optional<Potion> out = this.empty();

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        try {
            super.readResolve();
            if (!this.input.isPresent()) {
                throw new InvalidRecipeConfigException("Missing <reagent>");
            }
            if (!this.in.isPresent()) {
                throw new InvalidRecipeConfigException("Missing <input>");
            }
            if (!this.out.isPresent()) {
                throw new InvalidRecipeConfigException("Missing <output>");
            }
            this.valid = this.input.get().isValid() && this.in.get().isValid() && this.out.get().isValid();
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <brewing>");
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        this.input.get().enforceValidity();
        this.in.get().enforceValidity();
        this.out.get().enforceValidity();
        if (this.input.get().getThing().isEmpty()) {
            throw new InvalidRecipeConfigException("Valid child elements are invalid in <brewing>");
        }
    }

    @Override
    public void register(@Nonnull String recipeName, @Nonnull RecipeLevel recipeLevel) {
        if (this.isValid() && this.isActive()) {
            Things thing = this.input.get().getThing();
            PotionType inPotion = this.in.get().getPotion();
            PotionType outPotion = this.out.get().getPotion();
            if (!thing.isEmpty()) {
                PotionHelper.func_193356_a((PotionType)inPotion, (Ingredient)thing.asIngredient(), (PotionType)outPotion);
                if (recipeLevel != RecipeLevel.IGNORE) {
                    Log.warn("Ignoring recipe level " + (Object)((Object)recipeLevel) + " configured for vanilla brewing recipe '" + recipeName + "'---the vanilla brewing stand doesn't have (or support) levels");
                }
            }
        }
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("reagent".equals(name) && !this.input.isPresent()) {
            this.input = this.of(factory.read(new Item().setAllowDelaying(false), startElement));
            return true;
        }
        if ("input".equals(name) && !this.in.isPresent()) {
            this.in = this.of(factory.read(new Potion(), startElement));
            return true;
        }
        if ("output".equals(name) && !this.out.isPresent()) {
            this.out = this.of(factory.read(new Potion(), startElement));
            return true;
        }
        return super.setElement(factory, name, startElement);
    }
}

