/*
 * Decompiled with CFR 0.152.
 */
package gg.galaxygaming.gasconduits.common.conduit;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.conduit.ConduitDisplayMode;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitRenderer;
import crazypants.enderio.base.conduit.IServerConduit;
import crazypants.enderio.base.conduit.geom.Offset;
import crazypants.enderio.base.conduit.registry.ConduitBuilder;
import crazypants.enderio.base.conduit.registry.ConduitRegistry;
import crazypants.enderio.base.conduit.registry.ConduitTypeDefinition;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.conduits.conduit.AbstractItemConduit;
import crazypants.enderio.conduits.conduit.ItemConduitSubtype;
import crazypants.enderio.conduits.render.ConduitBundleRenderManager;
import gg.galaxygaming.gasconduits.common.conduit.IGasConduit;
import gg.galaxygaming.gasconduits.common.conduit.advanced.AdvancedGasConduit;
import gg.galaxygaming.gasconduits.common.conduit.advanced.AdvancedGasConduitRenderer;
import gg.galaxygaming.gasconduits.common.conduit.basic.GasConduit;
import gg.galaxygaming.gasconduits.common.conduit.basic.GasConduitRenderer;
import gg.galaxygaming.gasconduits.common.conduit.ender.EnderGasConduit;
import gg.galaxygaming.gasconduits.common.conduit.ender.EnderGasConduitRenderer;
import gg.galaxygaming.gasconduits.common.config.GasConduitConfig;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemGasConduit
extends AbstractItemConduit
implements IAdvancedTooltipProvider {
    public static ItemGasConduit create(@Nonnull IModObject modObject, @Nullable Block block) {
        return new ItemGasConduit(modObject);
    }

    protected ItemGasConduit(@Nonnull IModObject modObject) {
        super(modObject, new ItemConduitSubtype[]{new ItemConduitSubtype(modObject.getUnlocalisedName(), modObject.getRegistryName().toString()), new ItemConduitSubtype(modObject.getUnlocalisedName() + "_advanced", modObject.getRegistryName().toString() + "_advanced"), new ItemConduitSubtype(modObject.getUnlocalisedName() + "_ender", modObject.getRegistryName().toString() + "_ender")});
        ConduitRegistry.register((ConduitTypeDefinition)ConduitBuilder.start().setUUID(new ResourceLocation("gasconduits", "gas")).setClass(this.getBaseConduitType()).setOffsets(Offset.EAST_DOWN, Offset.SOUTH_DOWN, Offset.SOUTH_EAST, Offset.EAST_DOWN).build().setUUID(new ResourceLocation("gasconduits", "gas_conduit")).setClass(GasConduit.class).build().setUUID(new ResourceLocation("gasconduits", "advanced_gas_conduit")).setClass(AdvancedGasConduit.class).build().setUUID(new ResourceLocation("gasconduits", "ender_gas_conduit")).setClass(EnderGasConduit.class).build().finish());
        ConduitDisplayMode.registerDisplayMode((ConduitDisplayMode)new ConduitDisplayMode(this.getBaseConduitType(), (IWidgetIcon)IconEIO.WRENCH_OVERLAY_GAS, (IWidgetIcon)IconEIO.WRENCH_OVERLAY_GAS_OFF));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerRenderers(@Nonnull IModObject modObject) {
        super.registerRenderers(modObject);
        ConduitBundleRenderManager.instance.getConduitBundleRenderer().registerRenderer((IConduitRenderer)GasConduitRenderer.create());
        ConduitBundleRenderManager.instance.getConduitBundleRenderer().registerRenderer((IConduitRenderer)new AdvancedGasConduitRenderer());
        ConduitBundleRenderManager.instance.getConduitBundleRenderer().registerRenderer((IConduitRenderer)new EnderGasConduitRenderer());
    }

    @Nonnull
    public Class<? extends IConduit> getBaseConduitType() {
        return IGasConduit.class;
    }

    public IServerConduit createConduit(@Nonnull ItemStack stack, @Nonnull EntityPlayer player) {
        if (stack.func_77952_i() == 1) {
            return new AdvancedGasConduit();
        }
        if (stack.func_77952_i() == 2) {
            return new EnderGasConduit();
        }
        return new GasConduit();
    }

    @SideOnly(value=Side.CLIENT)
    public void addCommonEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
    }

    @SideOnly(value=Side.CLIENT)
    public void addBasicEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
    }

    @SideOnly(value=Side.CLIENT)
    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        int maxIo;
        int extractRate;
        if (itemstack.func_77952_i() == 0) {
            extractRate = (Integer)GasConduitConfig.tier1_extractRate.get();
            maxIo = (Integer)GasConduitConfig.tier1_maxIO.get();
        } else if (itemstack.func_77952_i() == 1) {
            extractRate = (Integer)GasConduitConfig.tier2_extractRate.get();
            maxIo = (Integer)GasConduitConfig.tier2_maxIO.get();
        } else {
            extractRate = (Integer)GasConduitConfig.tier3_extractRate.get();
            maxIo = (Integer)GasConduitConfig.tier3_maxIO.get();
        }
        String mbt = new TextComponentTranslation("gasconduits.gas.millibuckets_tick", new Object[0]).func_150261_e();
        list.add(new TextComponentTranslation("gasconduits.item_gas_conduit.tooltip.max_extract", new Object[0]).func_150261_e() + " " + extractRate + mbt);
        list.add(new TextComponentTranslation("gasconduits.item_gas_conduit.tooltip.max_io", new Object[0]).func_150261_e() + " " + maxIo + mbt);
        if (itemstack.func_77952_i() == 0) {
            SpecialTooltipHandler.addDetailedTooltipFromResources(list, (String)"gasconduits.item_gas_conduit");
        }
    }

    public boolean shouldHideFacades(@Nonnull ItemStack stack, @Nonnull EntityPlayer player) {
        return true;
    }
}

