/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.jei.combinationcrafting;

import com.blakebr0.cucumber.helper.ResourceHelper;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.extendedcrafting.compat.jei.combinationcrafting.CombinationCraftingWrapper;
import java.awt.Point;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.util.ResourceLocation;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CombinationCraftingCategory
implements IRecipeCategory<CombinationCraftingWrapper> {
    public static final String UID = "extendedcrafting:combination_crafting";
    private static final ResourceLocation TEXTURE = ResourceHelper.getResource((String)"extendedcrafting", (String)"textures/jei/combination_crafting.png");
    private final IDrawable background;

    public CombinationCraftingCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 140, 171);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return Utils.localize((String)"jei.ec.combination_crafting");
    }

    public String getModName() {
        return "Extended Crafting: Nomifactory Edition";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout layout, CombinationCraftingWrapper wrapper, IIngredients ingredients) {
        IGuiItemStackGroup stacks = layout.getItemStacks();
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0);
        stacks.init(0, false, 76, 149);
        stacks.init(1, true, 76, 46);
        stacks.set(0, outputs);
        stacks.set(1, (List)inputs.get(0));
        double angleBetweenEach = 360.0 / (double)(inputs.size() - 1);
        Point point = new Point(53, 8);
        Point center = new Point(74, 47);
        for (int i = 2; i < inputs.size() + 1; ++i) {
            stacks.init(i, true, point.x, point.y);
            stacks.set(i, (List)inputs.get(i - 1));
            point = this.rotatePoint(point, center, angleBetweenEach);
        }
    }

    private Point rotatePoint(Point in, Point about, double degrees) {
        double rad = degrees * Math.PI / 180.0;
        double newX = Math.cos(rad) * (double)(in.x - about.x) - Math.sin(rad) * (double)(in.y - about.y) + (double)about.x;
        double newY = Math.sin(rad) * (double)(in.x - about.x) + Math.cos(rad) * (double)(in.y - about.y) + (double)about.y;
        return new Point((int)newX, (int)newY);
    }
}

