/*
 * Decompiled with CFR 0.152.
 */
package extracells.item.storage;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.ICellRegistry;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import extracells.item.ItemECBase;
import extracells.item.storage.CellDefinition;
import extracells.item.storage.StorageType;
import extracells.models.ModelManager;
import extracells.registries.ItemEnum;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemStorageCell<T extends IAEStack<T>>
extends ItemECBase
implements IStorageCell<T> {
    protected final CellDefinition definition;
    protected final IStorageChannel<T> channel;

    public ItemStorageCell(CellDefinition definition, IStorageChannel<T> channel) {
        this.definition = definition;
        this.channel = channel;
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, World world, List<String> list, ITooltipFlag advanced) {
        ICellRegistry cellRegistry = AEApi.instance().registries().cell();
        ICellInventoryHandler cellHandler = cellRegistry.getCellInventory(itemStack, null, this.channel);
        if (cellHandler == null) {
            list.add("Failed to get cell handler!");
            return;
        }
        ICellInventory cellInventory = cellHandler.getCellInv();
        if (cellInventory == null) {
            list.add("Failed to get cell inventory!");
            return;
        }
        list.add(I18n.func_135052_a((String)("extracells.tooltip.storage." + (Object)((Object)this.definition) + ".bytes"), (Object[])new Object[]{cellInventory.getUsedBytes(), cellInventory.getTotalBytes()}));
        list.add(I18n.func_135052_a((String)("extracells.tooltip.storage." + (Object)((Object)this.definition) + ".types"), (Object[])new Object[]{cellInventory.getStoredItemTypes(), cellInventory.getTotalItemTypes()}));
        if (cellInventory.getStoredItemCount() != 0L) {
            list.add(I18n.func_135052_a((String)("extracells.tooltip.storage." + (Object)((Object)this.definition) + ".content"), (Object[])new Object[]{cellInventory.getStoredItemCount()}));
        }
        if (cellHandler.isPreformatted()) {
            list.add(I18n.func_135052_a((String)"gui.appliedenergistics2.Partitioned", (Object[])new Object[0]) + " - " + I18n.func_135052_a((String)"gui.appliedenergistics2.Precise", (Object[])new Object[0]));
        }
    }

    @Nonnull
    public EnumRarity func_77613_e(ItemStack itemStack) {
        return EnumRarity.RARE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull CreativeTabs creativeTab, @Nonnull NonNullList<ItemStack> listSubItems) {
        if (!this.func_194125_a(creativeTab)) {
            return;
        }
        for (StorageType type : this.definition.cells) {
            listSubItems.add((Object)new ItemStack((Item)this, 1, type.getMeta()));
        }
    }

    @Nonnull
    public String func_77667_c(ItemStack itemStack) {
        StorageType type = this.definition.cells.fromMeta(itemStack.func_77952_i());
        return "extracells.item.storage." + type.getIdentifier();
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!player.func_70093_af()) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
        }
        ICellRegistry cellRegistry = AEApi.instance().registries().cell();
        ICellInventoryHandler handler = cellRegistry.getCellInventory(itemStack, null, this.channel);
        if (handler == null) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
        }
        ICellInventory cellInventory = handler.getCellInv();
        if (cellInventory == null) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
        }
        if (cellInventory.getUsedBytes() == 0L && player.field_71071_by.func_70441_a(ItemEnum.STORAGECASING.getDamagedStack(this.definition.ordinal()))) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)ItemEnum.STORAGECOMPONET.getDamagedStack(itemStack.func_77952_i() + this.definition.componentMetaStart));
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, ModelManager manager) {
        for (StorageType type : this.definition.cells) {
            manager.registerItemModel(item, type.getMeta(), type.getModelName());
        }
    }

    public int getBytes(@Nonnull ItemStack cellItem) {
        StorageType type = this.definition.cells.fromMeta(cellItem.func_77952_i());
        return type.getBytes();
    }

    public int getBytesPerType(@Nonnull ItemStack cellItem) {
        return this.getBytes(cellItem) / 128;
    }

    public int getTotalTypes(@Nonnull ItemStack cellItem) {
        return 5;
    }

    public boolean isBlackListed(@Nonnull ItemStack cellItem, @Nonnull T requestedAddition) {
        return false;
    }

    public boolean storableInStorageCell() {
        return false;
    }

    public boolean isStorageCell(@Nonnull ItemStack i) {
        return true;
    }

    public double getIdleDrain() {
        return 0.0;
    }

    @Nonnull
    public IStorageChannel<T> getChannel() {
        return this.channel;
    }

    public boolean isEditable(ItemStack is) {
        if (is == null) {
            return false;
        }
        return is.func_77973_b() == this;
    }

    public FuzzyMode getFuzzyMode(ItemStack is) {
        if (is == null) {
            return null;
        }
        if (!is.func_77942_o()) {
            is.func_77982_d(new NBTTagCompound());
        }
        if (is.func_77978_p().func_74764_b("fuzzyMode")) {
            return FuzzyMode.valueOf((String)is.func_77978_p().func_74779_i("fuzzyMode"));
        }
        is.func_77978_p().func_74778_a("fuzzyMode", FuzzyMode.IGNORE_ALL.name());
        return FuzzyMode.IGNORE_ALL;
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        if (is == null) {
            return;
        }
        NBTTagCompound tag = is.func_77942_o() ? is.func_77978_p() : new NBTTagCompound();
        tag.func_74778_a("fuzzyMode", fzMode.name());
        is.func_77982_d(tag);
    }
}

