/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.render.shader;

import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.api.events.ResourceManagerReloadEvent;
import com.zeitheron.hammercore.client.render.shader.ShaderProgram;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.VanillaResourceType;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT})
public abstract class ShaderEntity {
    private static final List<ShaderEntity> ENTITIES = new ArrayList<ShaderEntity>();
    protected ShaderProgram currentProgram;

    public ShaderEntity() {
        ENTITIES.add(this);
    }

    protected abstract ShaderProgram createShader(IResourceManager var1);

    protected void onReloaded() {
    }

    public final void reloadShaderEntity(IResourceManager manager) {
        if (this.currentProgram != null) {
            this.currentProgram.cleanup();
        }
        this.currentProgram = null;
        this.currentProgram = this.createShader(manager);
        this.onReloaded();
    }

    @SubscribeEvent
    public static void reloadShaders(ResourceManagerReloadEvent e) {
        if (e.isType((IResourceType)VanillaResourceType.SHADERS)) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                HammerCore.LOG.info("Reloading " + ENTITIES.size() + " shader entities.");
                ENTITIES.forEach(se -> se.reloadShaderEntity(e.getManager()));
            });
        }
    }
}

