/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.utils.rendering;

import com.zeitheron.hammercore.api.events.ResourceManagerReloadEvent;
import com.zeitheron.hammercore.client.utils.rendering.ISimpleRenderable;
import com.zeitheron.hammercore.utils.base.Cast;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.VanillaResourceType;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT})
public class WavefrontLoader {
    public static IVertexConsumer VC_OPENGL = (pos, tex, normal) -> {
        GL11.glNormal3f((float)normal.getX(), (float)normal.getY(), (float)normal.getZ());
        GL11.glTexCoord2f((float)tex.getX(), (float)tex.getY());
        GL11.glVertex3f((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
    };
    public static IVertexConsumer VC_OPENGL_FLIP_UV = (pos, tex, normal) -> {
        GL11.glNormal3f((float)normal.getX(), (float)normal.getY(), (float)normal.getZ());
        GL11.glTexCoord2f((float)tex.getX(), (float)(1.0f - tex.getY()));
        GL11.glVertex3f((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
    };
    public static final Map<ResourceLocation, WavefrontMeshProvider> MESH_PROVIDERS = new HashMap<ResourceLocation, WavefrontMeshProvider>();
    public static final Map<ResourceLocation, WavefrontMesh> LOADED_MESHES = new HashMap<ResourceLocation, WavefrontMesh>();

    public static WavefrontMeshProvider getMeshProvider(ResourceLocation path) {
        return WavefrontLoader.getMeshProvider(path, 1.0f);
    }

    public static WavefrontMeshProvider getMeshProvider(ResourceLocation path, float scale) {
        return MESH_PROVIDERS.computeIfAbsent(new ResourceLocation(path.toString() + scale), rl0 -> new WavefrontMeshProvider(() -> LOADED_MESHES.computeIfAbsent(path, rl -> {
            try (IResource res = Minecraft.func_71410_x().func_110442_L().func_110536_a(path);){
                WavefrontMesh wavefrontMesh = WavefrontLoader.loadModel(res.func_110527_b(), scale);
                return wavefrontMesh;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return null;
            }
        })));
    }

    public static Function<Vector2f, Vector2f> transformUVToSprite(TextureAtlasSprite sprite) {
        return uv -> new Vector2f(sprite.func_94214_a((double)(uv.x * 16.0f)), sprite.func_94207_b((double)(uv.y * 16.0f)));
    }

    @SubscribeEvent
    public static void reloadResources(ResourceManagerReloadEvent e) {
        if (e.isType((IResourceType)VanillaResourceType.MODELS)) {
            LOADED_MESHES.clear();
        }
    }

    public static WavefrontMesh loadModel(InputStream stream, float scale) {
        return WavefrontLoader.loadModel(new Scanner(stream), scale);
    }

    public static WavefrontMesh loadModel(Scanner sc, float scale) {
        WavefrontMesh model = new WavefrontMesh();
        while (sc.hasNextLine()) {
            String ln = sc.nextLine();
            if (ln == null || ln.equals("") || ln.startsWith("#")) continue;
            String[] split = ln.split(" ");
            switch (split[0]) {
                case "v": {
                    model.getVertices().add(new Vector3f(Float.parseFloat(split[1]) * scale, Float.parseFloat(split[2]) * scale, Float.parseFloat(split[3]) * scale));
                    break;
                }
                case "vn": {
                    model.getNormals().add(new Vector3f(Float.parseFloat(split[1]), Float.parseFloat(split[2]), Float.parseFloat(split[3])));
                    break;
                }
                case "vt": {
                    model.getTextureCoordinates().add(new Vector2f(Float.parseFloat(split[1]), Float.parseFloat(split[2])));
                    break;
                }
                case "f": {
                    model.getFaces().add(new Face(new int[]{Integer.parseInt(split[1].split("/")[0]), Integer.parseInt(split[2].split("/")[0]), Integer.parseInt(split[3].split("/")[0])}, new int[]{Integer.parseInt(split[1].split("/")[1]), Integer.parseInt(split[2].split("/")[1]), Integer.parseInt(split[3].split("/")[1])}, new int[]{Integer.parseInt(split[1].split("/")[2]), Integer.parseInt(split[2].split("/")[2]), Integer.parseInt(split[3].split("/")[2])}));
                    break;
                }
                case "s": {
                    model.setSmoothShadingEnabled(!ln.contains("off"));
                    break;
                }
            }
        }
        sc.close();
        return model;
    }

    public static interface IVertexConsumer {
        public void consumeVertex(Vector3f var1, Vector2f var2, Vector3f var3);
    }

    public static class Face {
        private final int[] vertexIndices;
        private final int[] normalIndices;
        private final int[] textureCoordinateIndices;

        public Face(int[] vertexIndices, int[] textureCoordinateIndices, int[] normalIndices) {
            this.vertexIndices = vertexIndices;
            this.normalIndices = normalIndices;
            this.textureCoordinateIndices = textureCoordinateIndices;
        }

        public boolean hasNormals() {
            return this.normalIndices != null;
        }

        public boolean hasTextureCoords() {
            return this.textureCoordinateIndices != null;
        }

        public int[] getVertices() {
            return this.vertexIndices;
        }

        public int[] getTextureCoords() {
            return this.textureCoordinateIndices;
        }

        public int[] getNormals() {
            return this.normalIndices;
        }

        public String toString() {
            return String.format("Face[vertexIndices:%s,normalIndices:%s,textureCoordinateIndices:%s]", Arrays.toString(this.vertexIndices), Arrays.toString(this.normalIndices), Arrays.toString(this.textureCoordinateIndices));
        }
    }

    public static class WavefrontMesh
    implements ISimpleRenderable {
        private final UUID UNIQUE_ID = UUID.randomUUID();
        private final List<Vector3f> vertices;
        private final List<Vector2f> textureCoords;
        private final List<Vector3f> normals;
        private final List<Face> faces;
        private boolean enableSmoothShading;
        private Function<Vector2f, Vector2f> uvTransform;

        public WavefrontMesh() {
            this(new ArrayList<Vector3f>(), new ArrayList<Vector2f>(), new ArrayList<Vector3f>(), new ArrayList<Face>(), true);
        }

        public WavefrontMesh(List<Vector3f> vertices, List<Vector2f> textureCoords, List<Vector3f> normals, List<Face> faces, boolean enableSmoothShading) {
            this.vertices = vertices;
            this.textureCoords = textureCoords;
            this.normals = normals;
            this.faces = faces;
            this.enableSmoothShading = enableSmoothShading;
        }

        public UUID getUniqueId() {
            return this.UNIQUE_ID;
        }

        public void enableStates() {
            if (this.isSmoothShadingEnabled()) {
                GL11.glShadeModel((int)7425);
            } else {
                GL11.glShadeModel((int)7424);
            }
        }

        public boolean hasTextureCoordinates() {
            return this.getTextureCoordinates().size() > 0;
        }

        public boolean hasNormals() {
            return this.getNormals().size() > 0;
        }

        public List<Vector3f> getVertices() {
            return this.vertices;
        }

        public List<Vector2f> getTextureCoordinates() {
            return this.textureCoords;
        }

        public List<Vector3f> getNormals() {
            return this.normals;
        }

        public List<Face> getFaces() {
            return this.faces;
        }

        public void offsetVertices(Vector3f by) {
            for (Vector3f vertex : this.vertices) {
                vertex.x += by.x;
                vertex.y += by.y;
                vertex.z += by.z;
            }
        }

        public Vector3f getModelCenter() {
            float avgX = 0.0f;
            float avgY = 0.0f;
            float avgZ = 0.0f;
            int total = this.vertices.size();
            for (Vector3f vertex : this.vertices) {
                avgX += vertex.x;
                avgY += vertex.y;
                avgZ += vertex.z;
            }
            return total == 0 ? new Vector3f(0.0f, 0.0f, 0.0f) : new Vector3f(avgX / (float)total, avgY / (float)total, avgZ / (float)total);
        }

        public boolean isSmoothShadingEnabled() {
            return this.enableSmoothShading;
        }

        public void setSmoothShadingEnabled(boolean isSmoothShadingEnabled) {
            this.enableSmoothShading = isSmoothShadingEnabled;
        }

        public WavefrontMesh withUVTransformation(Function<Vector2f, Vector2f> uvTransform) {
            if (uvTransform == null) {
                return this;
            }
            this.uvTransform = this.uvTransform != null ? this.uvTransform.andThen(uvTransform) : uvTransform;
            return this;
        }

        public void renderVertices(boolean flipUV) {
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder builder = tess.func_178180_c();
            builder.func_181668_a(4, DefaultVertexFormats.field_181710_j);
            this.pipeVertices(builder, flipUV);
            tess.func_78381_a();
        }

        public void renderVerticesGL(boolean flipUV) {
            GL11.glMaterialf((int)1028, (int)5633, (float)120.0f);
            GL11.glBegin((int)4);
            this.pipeVertices(flipUV ? VC_OPENGL_FLIP_UV : VC_OPENGL);
            GL11.glEnd();
        }

        public void pipeVertices(BufferBuilder builder, boolean flipUV) {
            this.pipeVertices((pos, tex, normal) -> builder.func_181662_b((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()).func_187315_a((double)tex.getX(), flipUV ? (double)(1.0f - tex.getY()) : (double)tex.getY()).func_181663_c(normal.getX(), normal.getY(), normal.getZ()));
        }

        public void pipeVertices(IVertexConsumer consumer) {
            Function<Vector2f, Vector2f> uvt = this.uvTransform != null ? this.uvTransform : v -> v;
            this.uvTransform = null;
            for (Face face : this.getFaces()) {
                consumer.consumeVertex(this.getVertices().get(face.getVertices()[0] - 1), uvt.apply(this.getTextureCoordinates().get(face.getTextureCoords()[0] - 1)), this.getNormals().get(face.getNormals()[0] - 1));
                consumer.consumeVertex(this.getVertices().get(face.getVertices()[1] - 1), uvt.apply(this.getTextureCoordinates().get(face.getTextureCoords()[1] - 1)), this.getNormals().get(face.getNormals()[1] - 1));
                consumer.consumeVertex(this.getVertices().get(face.getVertices()[2] - 1), uvt.apply(this.getTextureCoordinates().get(face.getTextureCoords()[2] - 1)), this.getNormals().get(face.getNormals()[2] - 1));
            }
        }

        @Override
        public void render(@Nullable Map<String, Object> properties) {
            if (properties != null && properties.containsKey("uvTransformer")) {
                this.withUVTransformation(Cast.cast(properties.get("uvTransformer"), Function.class));
            }
            Boolean bool = properties == null ? Boolean.valueOf(true) : Cast.cast(properties.getOrDefault("flipUV", true), Boolean.class);
            this.renderVerticesGL(bool != null ? bool : true);
        }
    }

    public static class WavefrontMeshProvider
    implements ISimpleRenderable {
        final Supplier<WavefrontMesh> meshSupplier;
        Consumer<WavefrontMesh> customHandler;
        boolean normalizeCenter = false;
        Vec3d center;

        public WavefrontMeshProvider(Supplier<WavefrontMesh> meshSupplier) {
            this.meshSupplier = meshSupplier;
        }

        public WavefrontMeshProvider(WavefrontMeshProvider origin) {
            this.meshSupplier = origin.meshSupplier;
            this.normalizeCenter = origin.normalizeCenter;
            if (origin.center != null) {
                this.center = new Vec3d(origin.center.field_72450_a, origin.center.field_72448_b, origin.center.field_72449_c);
            }
            this.customHandler = origin.customHandler;
        }

        public WavefrontMeshProvider withCustomHandler(Consumer<WavefrontMesh> handler) {
            WavefrontMeshProvider prov = new WavefrontMeshProvider(this);
            prov.customHandler = this.customHandler != null ? this.customHandler.andThen(handler) : handler;
            return prov;
        }

        public WavefrontMeshProvider centered() {
            WavefrontMeshProvider prov = new WavefrontMeshProvider(this);
            prov.normalizeCenter = true;
            return prov;
        }

        public WavefrontMeshProvider center(Vec3d center) {
            WavefrontMeshProvider prov = new WavefrontMeshProvider(this);
            prov.center = center;
            prov.normalizeCenter = true;
            return prov;
        }

        public WavefrontMesh getMesh() {
            WavefrontMesh mesh = this.meshSupplier.get();
            if (this.normalizeCenter) {
                Vector3f modelCenter = mesh.getModelCenter();
                if (this.center != null) {
                    mesh.offsetVertices(new Vector3f((float)this.center.field_72450_a - modelCenter.x, (float)this.center.field_72448_b - modelCenter.y, (float)this.center.field_72449_c - modelCenter.z));
                } else {
                    mesh.offsetVertices(new Vector3f(-modelCenter.x, -modelCenter.y, -modelCenter.z));
                }
            }
            if (this.customHandler != null) {
                this.customHandler.accept(mesh);
            }
            return mesh;
        }

        @Override
        public void render(@Nullable Map<String, Object> properties) {
            WavefrontMesh m = this.getMesh();
            if (m != null) {
                m.render(properties);
            }
        }
    }
}

