/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import mekanism.api.IClientTicker;
import mekanism.api.gas.GasStack;
import mekanism.client.HolidayManager;
import mekanism.client.MekanismClient;
import mekanism.client.render.RenderTickHandler;
import mekanism.common.CommonPlayerTickHandler;
import mekanism.common.KeySync;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.frequency.Frequency;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.item.ItemFlamethrower;
import mekanism.common.item.ItemFreeRunners;
import mekanism.common.item.ItemJetpack;
import mekanism.common.item.ItemScubaTank;
import mekanism.common.network.PacketFreeRunnerData;
import mekanism.common.network.PacketItemStack;
import mekanism.common.network.PacketPortableTeleporter;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientTickHandler {
    public static Minecraft mc = FMLClientHandler.instance().getClient();
    public static Random rand = new Random();
    public static Set<IClientTicker> tickingSet = new HashSet<IClientTicker>();
    public static Map<EntityPlayer, TeleportData> portableTeleports = new HashMap<EntityPlayer, TeleportData>();
    public static int wheelStatus = 0;
    public boolean initHoliday = false;
    public boolean shouldReset = false;

    public static void killDeadNetworks() {
        tickingSet.removeIf(iClientTicker -> !iClientTicker.needsTicks());
    }

    public static boolean isJetpackActive(EntityPlayer player) {
        ItemJetpack jetpack;
        ItemStack chest;
        if (player != ClientTickHandler.mc.field_71439_g) {
            return Mekanism.playerState.isJetpackOn(player);
        }
        if (!player.func_184812_l_() && !player.func_175149_v() && !(chest = player.func_184582_a(EntityEquipmentSlot.CHEST)).func_190926_b() && chest.func_77973_b() instanceof ItemJetpack && (jetpack = (ItemJetpack)chest.func_77973_b()).getGas(chest) != null) {
            ItemJetpack.JetpackMode mode = jetpack.getMode(chest);
            if (mode == ItemJetpack.JetpackMode.NORMAL) {
                return ClientTickHandler.mc.field_71462_r == null && ClientTickHandler.mc.field_71474_y.field_74314_A.func_151470_d();
            }
            if (mode == ItemJetpack.JetpackMode.HOVER) {
                boolean ascending = ClientTickHandler.mc.field_71474_y.field_74314_A.func_151470_d();
                boolean descending = ClientTickHandler.mc.field_71474_y.field_74311_E.func_151470_d();
                if (!ascending || descending || ClientTickHandler.mc.field_71462_r != null) {
                    return !CommonPlayerTickHandler.isOnGround(player);
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isGasMaskOn(EntityPlayer player) {
        if (player != ClientTickHandler.mc.field_71439_g) {
            return Mekanism.playerState.isGasmaskOn(player);
        }
        return CommonPlayerTickHandler.isGasMaskOn(player);
    }

    public static boolean isFreeRunnerOn(EntityPlayer player) {
        if (player != ClientTickHandler.mc.field_71439_g) {
            return Mekanism.freeRunnerOn.contains(player.func_110124_au());
        }
        ItemStack stack = player.func_184582_a(EntityEquipmentSlot.FEET);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemFreeRunners) {
            ItemFreeRunners freeRunners = (ItemFreeRunners)stack.func_77973_b();
            return freeRunners.getMode(stack) == ItemFreeRunners.FreeRunnerMode.NORMAL;
        }
        return false;
    }

    public static boolean isFlamethrowerOn(EntityPlayer player) {
        if (player != ClientTickHandler.mc.field_71439_g) {
            return Mekanism.playerState.isFlamethrowerOn(player);
        }
        return ClientTickHandler.hasFlamethrower(player) && ClientTickHandler.mc.field_71474_y.field_74313_G.func_151470_d();
    }

    public static boolean hasFlamethrower(EntityPlayer player) {
        ItemStack currentItem = player.field_71071_by.func_70448_g();
        if (!currentItem.func_190926_b() && currentItem.func_77973_b() instanceof ItemFlamethrower) {
            return ((ItemFlamethrower)currentItem.func_77973_b()).getGas(currentItem) != null;
        }
        return false;
    }

    public static void portableTeleport(EntityPlayer player, EnumHand hand, Frequency freq) {
        int delay = MekanismConfig.current().general.portableTeleporterDelay.val();
        if (delay == 0) {
            Mekanism.packetHandler.sendToServer(new PacketPortableTeleporter.PortableTeleporterMessage(PacketPortableTeleporter.PortableTeleporterPacketType.TELEPORT, hand, freq));
        } else {
            portableTeleports.put(player, new TeleportData(hand, freq, ClientTickHandler.mc.field_71441_e.func_72820_D() + (long)delay));
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.tickStart();
        }
    }

    public void tickStart() {
        ++MekanismClient.ticksPassed;
        if (!Mekanism.proxy.isPaused()) {
            Iterator<IClientTicker> iter = tickingSet.iterator();
            while (iter.hasNext()) {
                IClientTicker ticker = iter.next();
                if (ticker.needsTicks()) {
                    ticker.clientTick();
                    continue;
                }
                iter.remove();
            }
        }
        if (ClientTickHandler.mc.field_71441_e != null) {
            this.shouldReset = true;
        } else if (this.shouldReset) {
            MekanismClient.reset();
            this.shouldReset = false;
        }
        if (ClientTickHandler.mc.field_71441_e != null && ClientTickHandler.mc.field_71439_g != null && !Mekanism.proxy.isPaused()) {
            ItemStack bootStack;
            if (!this.initHoliday || MekanismClient.ticksPassed % 1200L == 0L) {
                HolidayManager.check();
                this.initHoliday = true;
            }
            UUID playerUUID = ClientTickHandler.mc.field_71439_g.func_110124_au();
            boolean freeRunnerOn = ClientTickHandler.isFreeRunnerOn((EntityPlayer)ClientTickHandler.mc.field_71439_g);
            if (Mekanism.freeRunnerOn.contains(playerUUID) != freeRunnerOn) {
                if (freeRunnerOn && ClientTickHandler.mc.field_71462_r == null) {
                    Mekanism.freeRunnerOn.add(playerUUID);
                } else {
                    Mekanism.freeRunnerOn.remove(playerUUID);
                }
                Mekanism.packetHandler.sendToServer(new PacketFreeRunnerData.FreeRunnerDataMessage(PacketFreeRunnerData.FreeRunnerPacket.UPDATE, playerUUID, freeRunnerOn));
            }
            if (!(bootStack = ClientTickHandler.mc.field_71439_g.func_184582_a(EntityEquipmentSlot.FEET)).func_190926_b() && bootStack.func_77973_b() instanceof ItemFreeRunners && freeRunnerOn && !ClientTickHandler.mc.field_71439_g.func_70093_af()) {
                ClientTickHandler.mc.field_71439_g.field_70138_W = 1.002f;
            } else if (ClientTickHandler.mc.field_71439_g.field_70138_W == 1.002f) {
                ClientTickHandler.mc.field_71439_g.field_70138_W = 0.6f;
            }
            Mekanism.playerState.setJetpackState(playerUUID, ClientTickHandler.isJetpackActive((EntityPlayer)ClientTickHandler.mc.field_71439_g), true);
            Mekanism.playerState.setGasmaskState(playerUUID, ClientTickHandler.isGasMaskOn((EntityPlayer)ClientTickHandler.mc.field_71439_g), true);
            Mekanism.playerState.setFlamethrowerState(playerUUID, ClientTickHandler.hasFlamethrower((EntityPlayer)ClientTickHandler.mc.field_71439_g), ClientTickHandler.isFlamethrowerOn((EntityPlayer)ClientTickHandler.mc.field_71439_g), true);
            Iterator<Map.Entry<EntityPlayer, TeleportData>> iter = portableTeleports.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<EntityPlayer, TeleportData> entry = iter.next();
                EntityPlayer player = entry.getKey();
                for (int i = 0; i < 100; ++i) {
                    double x = player.field_70165_t + rand.nextDouble() - 0.5;
                    double y = player.field_70163_u + rand.nextDouble() * 2.0 - 2.0;
                    double z = player.field_70161_v + rand.nextDouble() - 0.5;
                    ClientTickHandler.mc.field_71441_e.func_175688_a(EnumParticleTypes.PORTAL, x, y, z, 0.0, 1.0, 0.0, new int[0]);
                }
                if (ClientTickHandler.mc.field_71441_e.func_72820_D() != entry.getValue().teleportTime) continue;
                Mekanism.packetHandler.sendToServer(new PacketPortableTeleporter.PortableTeleporterMessage(PacketPortableTeleporter.PortableTeleporterPacketType.TELEPORT, entry.getValue().hand, entry.getValue().freq));
                iter.remove();
            }
            ItemStack chestStack = ClientTickHandler.mc.field_71439_g.func_184582_a(EntityEquipmentSlot.CHEST);
            if (!chestStack.func_190926_b() && chestStack.func_77973_b() instanceof ItemJetpack) {
                MekanismClient.updateKey(ClientTickHandler.mc.field_71474_y.field_74314_A, KeySync.ASCEND);
                MekanismClient.updateKey(ClientTickHandler.mc.field_71474_y.field_74311_E, KeySync.DESCEND);
            }
            if (!ClientTickHandler.mc.field_71439_g.func_184812_l_() && !ClientTickHandler.mc.field_71439_g.func_175149_v() && ClientTickHandler.isFlamethrowerOn((EntityPlayer)ClientTickHandler.mc.field_71439_g)) {
                ItemFlamethrower flamethrower = (ItemFlamethrower)ClientTickHandler.mc.field_71439_g.field_71071_by.func_70448_g().func_77973_b();
                flamethrower.useGas(ClientTickHandler.mc.field_71439_g.field_71071_by.func_70448_g());
            }
            if (ClientTickHandler.isJetpackActive((EntityPlayer)ClientTickHandler.mc.field_71439_g)) {
                ItemJetpack jetpack = (ItemJetpack)chestStack.func_77973_b();
                ItemJetpack.JetpackMode mode = jetpack.getMode(chestStack);
                if (mode == ItemJetpack.JetpackMode.NORMAL) {
                    ClientTickHandler.mc.field_71439_g.field_70181_x = Math.min(ClientTickHandler.mc.field_71439_g.field_70181_x + 0.15, 0.5);
                    ClientTickHandler.mc.field_71439_g.field_70143_R = 0.0f;
                } else if (mode == ItemJetpack.JetpackMode.HOVER) {
                    boolean ascending = ClientTickHandler.mc.field_71474_y.field_74314_A.func_151470_d();
                    boolean descending = ClientTickHandler.mc.field_71474_y.field_74311_E.func_151470_d();
                    if (!ascending && !descending || ascending && descending || ClientTickHandler.mc.field_71462_r != null) {
                        if (ClientTickHandler.mc.field_71439_g.field_70181_x > 0.0) {
                            ClientTickHandler.mc.field_71439_g.field_70181_x = Math.max(ClientTickHandler.mc.field_71439_g.field_70181_x - 0.15, 0.0);
                        } else if (ClientTickHandler.mc.field_71439_g.field_70181_x < 0.0 && !CommonPlayerTickHandler.isOnGround((EntityPlayer)ClientTickHandler.mc.field_71439_g)) {
                            ClientTickHandler.mc.field_71439_g.field_70181_x = Math.min(ClientTickHandler.mc.field_71439_g.field_70181_x + 0.15, 0.0);
                        }
                    } else if (ascending) {
                        ClientTickHandler.mc.field_71439_g.field_70181_x = Math.min(ClientTickHandler.mc.field_71439_g.field_70181_x + 0.15, 0.2);
                    } else if (!CommonPlayerTickHandler.isOnGround((EntityPlayer)ClientTickHandler.mc.field_71439_g)) {
                        ClientTickHandler.mc.field_71439_g.field_70181_x = Math.max(ClientTickHandler.mc.field_71439_g.field_70181_x - 0.15, -0.2);
                    }
                    ClientTickHandler.mc.field_71439_g.field_70143_R = 0.0f;
                }
                jetpack.useGas(chestStack);
            }
            if (ClientTickHandler.isGasMaskOn((EntityPlayer)ClientTickHandler.mc.field_71439_g)) {
                ItemScubaTank tank = (ItemScubaTank)chestStack.func_77973_b();
                int max = 300;
                tank.useGas(chestStack);
                GasStack received = tank.useGas(chestStack, 300 - ClientTickHandler.mc.field_71439_g.func_70086_ai());
                if (received != null) {
                    ClientTickHandler.mc.field_71439_g.func_70050_g(ClientTickHandler.mc.field_71439_g.func_70086_ai() + received.amount);
                }
                if (ClientTickHandler.mc.field_71439_g.func_70086_ai() == 300) {
                    for (PotionEffect effect : ClientTickHandler.mc.field_71439_g.func_70651_bq()) {
                        for (int i = 0; i < 9; ++i) {
                            effect.func_76455_a((EntityLivingBase)ClientTickHandler.mc.field_71439_g);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onMouseEvent(MouseEvent event) {
        if (MekanismConfig.current().client.allowConfiguratorModeScroll.val() && ClientTickHandler.mc.field_71439_g != null && ClientTickHandler.mc.field_71439_g.func_70093_af()) {
            ItemStack stack = ClientTickHandler.mc.field_71439_g.func_184614_ca();
            int delta = event.getDwheel();
            if (stack.func_77973_b() instanceof ItemConfigurator && delta != 0) {
                ItemConfigurator configurator = (ItemConfigurator)stack.func_77973_b();
                RenderTickHandler.modeSwitchTimer = 100;
                int scaledDelta = (wheelStatus += event.getDwheel()) / 120;
                wheelStatus %= 120;
                int newVal = configurator.getState(stack).ordinal() + scaledDelta % ItemConfigurator.ConfiguratorMode.values().length;
                if (newVal > 0) {
                    newVal %= ItemConfigurator.ConfiguratorMode.values().length;
                } else if (newVal < 0) {
                    newVal = ItemConfigurator.ConfiguratorMode.values().length + newVal;
                }
                configurator.setState(stack, ItemConfigurator.ConfiguratorMode.values()[newVal]);
                Mekanism.packetHandler.sendToServer(new PacketItemStack.ItemStackMessage(EnumHand.MAIN_HAND, Collections.singletonList(newVal)));
                event.setCanceled(true);
            }
        }
    }

    private static class TeleportData {
        private EnumHand hand;
        private Frequency freq;
        private long teleportTime;

        public TeleportData(EnumHand h, Frequency f, long t) {
            this.hand = h;
            this.freq = f;
            this.teleportTime = t;
        }
    }
}

