/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.components.requirements;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentOutputRestrictor;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.util.List;
import modulardiversity.util.ICraftingResourceHolder;
import modulardiversity.util.IResourceToken;

public abstract class RequirementConsumeOnce<T, V extends IResourceToken>
extends ComponentRequirement<T> {
    V checkToken;
    V outputToken;

    public RequirementConsumeOnce(ComponentType componentType, MachineComponent.IOType actionType) {
        super(componentType, actionType);
    }

    public boolean startCrafting(MachineComponent component, RecipeCraftingContext context, ResultChance resultChance) {
        if (!this.isCorrectHatch(component)) {
            return false;
        }
        ICraftingResourceHolder handler = (ICraftingResourceHolder)context.getProvidedCraftingComponent(component);
        switch (this.getActionType()) {
            case INPUT: {
                handler.consume(this.outputToken, true);
                if (!this.outputToken.isEmpty()) break;
                return true;
            }
        }
        return false;
    }

    public boolean finishCrafting(MachineComponent component, RecipeCraftingContext context, ResultChance resultChance) {
        if (!this.isCorrectHatch(component)) {
            return false;
        }
        ICraftingResourceHolder handler = (ICraftingResourceHolder)context.getProvidedCraftingComponent(component);
        switch (this.getActionType()) {
            case OUTPUT: {
                handler.generate(this.outputToken, true);
                if (!this.outputToken.isEmpty()) break;
                return true;
            }
        }
        return false;
    }

    protected String getMissingInput() {
        return "craftcheck." + this.getRequiredComponentType().getRegistryName() + ".input";
    }

    protected String getMissingOutput() {
        return "craftcheck." + this.getRequiredComponentType().getRegistryName() + ".output";
    }

    protected String getMiscProblem() {
        return "craftcheck.failure.misc";
    }

    public CraftCheck canStartCrafting(MachineComponent component, RecipeCraftingContext context, List<ComponentOutputRestrictor> list) {
        if (!this.isCorrectHatch(component)) {
            return CraftCheck.skipComponent();
        }
        ICraftingResourceHolder handler = (ICraftingResourceHolder)context.getProvidedCraftingComponent(component);
        switch (this.getActionType()) {
            case INPUT: {
                boolean didConsume = handler.consume(this.checkToken, false);
                if (!didConsume) {
                    return CraftCheck.failure((String)handler.getInputProblem(this.checkToken));
                }
                if (this.checkToken.isEmpty()) {
                    return CraftCheck.success();
                }
                return CraftCheck.failure((String)this.getMissingInput());
            }
            case OUTPUT: {
                boolean didGenerate = handler.generate(this.checkToken, false);
                if (!didGenerate) {
                    return CraftCheck.failure((String)handler.getOutputProblem(this.checkToken));
                }
                if (this.checkToken.isEmpty()) {
                    return CraftCheck.success();
                }
                return CraftCheck.failure((String)this.getMissingOutput());
            }
        }
        return CraftCheck.failure((String)this.getMiscProblem());
    }

    public void startRequirementCheck(ResultChance chance, RecipeCraftingContext context) {
        this.checkToken = this.emitConsumptionToken(context);
        this.checkToken.applyModifiers(context, this.getActionType(), 1.0f);
        this.outputToken = this.emitConsumptionToken(context);
        this.outputToken.applyModifiers(context, this.getActionType(), 1.0f);
    }

    public void endRequirementCheck() {
        this.checkToken = this.emitConsumptionToken(null);
        this.outputToken = this.emitConsumptionToken(null);
    }

    protected abstract boolean isCorrectHatch(MachineComponent var1);

    protected abstract V emitConsumptionToken(RecipeCraftingContext var1);
}

