/*
 * Decompiled with CFR 0.152.
 */
package moretweaker.jei.erebus;

import com.google.common.collect.ImmutableList;
import erebus.ModBlocks;
import erebus.recipes.ComposterRegistry;
import erebus.recipes.OfferingAltarRecipe;
import erebus.recipes.SmoothieMakerRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import moretweaker.jei.MoreJeiPlugin;
import moretweaker.jei.erebus.CompostCategory;
import moretweaker.jei.erebus.CompostWrapper;
import moretweaker.jei.erebus.OfferingCategory;
import moretweaker.jei.erebus.OfferingWrapper;
import moretweaker.jei.erebus.SmoothieCategory;
import moretweaker.jei.erebus.SmoothieWrapper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;

public class ErebusJei
implements MoreJeiPlugin {
    @Override
    public void register(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new OfferingCategory(registry.getJeiHelpers().getGuiHelper()), new CompostCategory(registry.getJeiHelpers().getGuiHelper()), new SmoothieCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    @Override
    public void register(IModRegistry registry) {
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.ALTAR_OFFERING), new String[]{"moretweaker.erebus.offering.recipes"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.COMPOSTER), new String[]{"moretweaker.erebus.compost.recipes"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.SMOOTHIE_MAKER), new String[]{"moretweaker.erebus.smoothie.recipes"});
        registry.handleRecipes(OfferingAltarRecipe.class, OfferingWrapper::new, "moretweaker.erebus.offering.recipes");
        registry.handleRecipes(ItemStack.class, CompostWrapper::new, "moretweaker.erebus.compost.recipes");
        registry.handleRecipes(SmoothieMakerRecipe.class, SmoothieWrapper::new, "moretweaker.erebus.smoothie.recipes");
        registry.addRecipes((Collection)OfferingAltarRecipe.getRecipeList(), "moretweaker.erebus.offering.recipes");
        registry.addRecipes((Collection)SmoothieMakerRecipe.getRecipeList(), "moretweaker.erebus.smoothie.recipes");
        NonNullList compost = NonNullList.func_191196_a();
        IForgeRegistry itemRegistry = GameRegistry.findRegistry(Item.class);
        for (Item item : itemRegistry.getValuesCollection()) {
            CreativeTabs tab = item.func_77640_w();
            if (tab == null) continue;
            item.func_150895_a(tab, compost);
        }
        compost.removeIf(stack -> {
            ItemStack x = ComposterRegistry.isCompostable((ItemStack)stack);
            return x == null || x.func_190926_b();
        });
        registry.addRecipes((Collection)compost, "moretweaker.erebus.compost.recipes");
    }

    public static List<List<ItemStack>> getStacksList(Object[] inputs, int sizeNeeded) {
        ArrayList<List<ItemStack>> in = new ArrayList<List<ItemStack>>();
        for (Object obj : inputs) {
            if (in.size() >= sizeNeeded) continue;
            if (obj instanceof ItemStack) {
                in.add((List<ItemStack>)ImmutableList.of((Object)((ItemStack)obj)));
                continue;
            }
            if (obj instanceof List) {
                ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
                for (Object o : (List)obj) {
                    if (!(o instanceof ItemStack)) continue;
                    stackList.add((ItemStack)o);
                }
                in.add(stackList);
                continue;
            }
            if (!(obj instanceof String)) continue;
            in.add((List<ItemStack>)OreDictionary.getOres((String)((String)obj)));
        }
        while (in.size() < sizeNeeded) {
            in.add((List<ItemStack>)ImmutableList.of((Object)ItemStack.field_190927_a));
        }
        return in;
    }
}

