/*
 * Decompiled with CFR 0.152.
 */
package moretweaker.lightningcraft;

import com.blamejared.mtlib.helpers.InputHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import moretweaker.Inputs;
import moretweaker.lightningcraft.LUtil;
import net.minecraft.item.ItemStack;
import sblectric.lightningcraft.recipes.LightningInfusionRecipes;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="moretweaker.lightningcraft.LightningInfusion")
@ZenRegister
@ModOnly(value="lightningcraft")
public class LightningInfusion {
    @ZenMethod
    public static void add(IItemStack output, IIngredient catalyst, final int cost, IIngredient[] inputs) {
        final ItemStack out = InputHelper.toStack((IItemStack)output);
        final Object cl = LUtil.getObject(catalyst);
        final Object[] in = LUtil.getObjects(inputs);
        if (in.length != 4) {
            CraftTweakerAPI.logError((String)("Lightning-Infusion needs 4 inputs, got " + in.length));
        }
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                LightningInfusionRecipes.instance().addRecipe(out, cost, cl, in);
            }

            public String describe() {
                return "Adds a LightningInfusion Recipe";
            }
        });
    }

    @ZenMethod
    public static void remove(IIngredient output) {
        final Object obj = Inputs.getObject(output);
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                LightningInfusionRecipes.instance().getRecipeList().removeIf(recipe -> Inputs.matchesForRemoval(obj, recipe.getOutput()));
            }

            public String describe() {
                return "Removes LightningInfusion Recipes";
            }
        });
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                LightningInfusionRecipes.instance().getRecipeList().clear();
            }

            public String describe() {
                return "Removes all recipes for LightningInfusion";
            }
        });
    }
}

