/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.helper;

import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.client.gui.implementations.GuiCraftingTerm;
import appeng.client.gui.implementations.GuiMEMonitorable;
import appeng.client.gui.implementations.GuiPatternTerm;
import appeng.client.me.ItemRepo;
import appeng.util.item.AEItemStack;
import com.github.vfyjxf.nee.config.NEEConfig;
import com.github.vfyjxf.nee.helper.IngredientMerger;
import com.github.vfyjxf.nee.utils.IngredientStatus;
import com.github.vfyjxf.nee.utils.ItemUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.Optional;
import p455w0rd.wct.client.gui.GuiWCT;

public class RecipeAnalyzer {
    private static boolean shouldCleanCache = false;
    @Nonnull
    private static List<IAEItemStack> craftableCache = new ArrayList<IAEItemStack>();
    @Nonnull
    private static List<IAEItemStack> allStacksCache = new ArrayList<IAEItemStack>();
    private final GuiContainer term;
    private final boolean craftableOnly;
    private final boolean isWireless;
    private final List<ItemStack> availableItems = new ArrayList<ItemStack>();
    private long lastUpdateTime;
    private List<RecipeIngredient> ingredientsCache;

    public RecipeAnalyzer(GuiPatternTerm patternTerm) {
        this.term = patternTerm;
        this.craftableOnly = true;
        this.isWireless = false;
        if (shouldCleanCache) {
            this.clearCache();
        }
        if (craftableCache.isEmpty()) {
            craftableCache = this.getStorage().stream().filter(IAEStack::isCraftable).collect(Collectors.toList());
        }
    }

    public RecipeAnalyzer(GuiCraftingTerm craftingTerm) {
        this(craftingTerm, shouldCleanCache);
    }

    public RecipeAnalyzer(GuiCraftingTerm craftingTerm, boolean cleanCache) {
        this.term = craftingTerm;
        this.craftableOnly = false;
        this.isWireless = false;
        if (cleanCache) {
            this.clearCache();
        }
        if (allStacksCache.isEmpty()) {
            allStacksCache = this.getStorage();
        }
    }

    public RecipeAnalyzer(GuiContainer wirelessTerm) {
        this(wirelessTerm, shouldCleanCache);
    }

    public RecipeAnalyzer(GuiContainer wirelessTerm, boolean cleanCache) {
        this.term = wirelessTerm;
        this.craftableOnly = false;
        this.isWireless = true;
        if (cleanCache) {
            this.clearCache();
        }
        if (allStacksCache.isEmpty()) {
            allStacksCache = this.getStorage();
        }
    }

    public static void setCleanCache(boolean cleanCache) {
        shouldCleanCache = cleanCache;
    }

    public List<RecipeIngredient> analyzeRecipe(IRecipeLayout recipeLayout) {
        if (this.ingredientsCache != null) {
            return this.ingredientsCache;
        }
        Stream merged = this.mergeIngredients(recipeLayout).stream();
        if (this.craftableOnly) {
            this.ingredientsCache = merged.filter(ingredient -> craftableCache.parallelStream().anyMatch(craftable -> ((IGuiIngredient)ingredient.get(0)).getAllIngredients().parallelStream().anyMatch(stack -> ItemUtils.matches(stack, craftable.getDefinition())))).map(ingredient -> new RecipeIngredient(IngredientStatus.CRAFTABLE, ItemStack.field_190927_a, (List<IGuiIngredient<ItemStack>>)ingredient)).collect(Collectors.toList());
            return this.ingredientsCache;
        }
        this.ingredientsCache = merged.map(this::getExistData).collect(Collectors.toList());
        return this.ingredientsCache;
    }

    public void addAvailableIngredient(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        boolean find = this.availableItems.stream().anyMatch(itemStack -> IngredientMerger.unlimitedMergeStack(itemStack, stack));
        if (!find) {
            this.availableItems.add(stack.func_77946_l());
        }
    }

    public void update() {
        if (NEEConfig.getUpdateIntervalTime() < 0) {
            return;
        }
        if (System.currentTimeMillis() - this.lastUpdateTime > (long)NEEConfig.getUpdateIntervalTime()) {
            this.lastUpdateTime = System.currentTimeMillis();
            this.updateCache();
        }
    }

    private void clearCache() {
        craftableCache = Collections.emptyList();
        allStacksCache = Collections.emptyList();
        shouldCleanCache = false;
    }

    private void updateCache() {
        if (this.craftableOnly) {
            craftableCache = this.getStorage().stream().filter(IAEStack::isCraftable).collect(Collectors.toList());
        } else {
            allStacksCache = this.getStorage();
        }
        this.ingredientsCache = null;
    }

    private List<List<IGuiIngredient<ItemStack>>> mergeIngredients(IRecipeLayout recipeLayout) {
        ArrayList<List<IGuiIngredient<ItemStack>>> merged = new ArrayList<List<IGuiIngredient<ItemStack>>>();
        recipeLayout.getItemStacks().getGuiIngredients().values().stream().filter(IGuiIngredient::isInput).filter(ingredient -> !ingredient.getAllIngredients().isEmpty()).forEach(ingredient -> {
            boolean matches = merged.stream().anyMatch(list -> {
                if (list.isEmpty()) {
                    return false;
                }
                IGuiIngredient first = (IGuiIngredient)list.get(0);
                if (this.matches((IGuiIngredient<ItemStack>)first, (IGuiIngredient<ItemStack>)ingredient)) {
                    list.add(ingredient);
                    return true;
                }
                return false;
            });
            if (!matches) {
                merged.add(new ArrayList<IGuiIngredient>(Collections.singleton(ingredient)));
            }
        });
        return merged;
    }

    private RecipeIngredient getExistData(List<IGuiIngredient<ItemStack>> ingredients) {
        int required = ingredients.stream().mapToInt(stacks -> ItemUtils.getFirstStack((IGuiIngredient<ItemStack>)stacks).func_190916_E()).sum();
        IGuiIngredient<ItemStack> first = ingredients.get(0);
        ItemStack identifier = this.availableItems.stream().filter(stack -> first.getAllIngredients().parallelStream().anyMatch(stack1 -> ItemUtils.matches(stack, stack1))).findAny().orElse(ItemStack.field_190927_a);
        if (!identifier.func_190926_b() && identifier.func_190916_E() >= required) {
            return new RecipeIngredient(IngredientStatus.EXISTS, identifier.func_77946_l(), ingredients);
        }
        int count = identifier.func_190916_E();
        Stream<Object> stackStream = allStacksCache.parallelStream();
        stackStream = identifier.func_190926_b() ? stackStream.filter(stack -> first.getAllIngredients().parallelStream().anyMatch(guiStack -> ItemUtils.matches(stack.getDefinition(), guiStack))) : stackStream.filter(stack -> first.getAllIngredients().parallelStream().anyMatch(guiStack -> ItemUtils.matches(stack.getDefinition(), identifier) || ItemUtils.matches(stack.getDefinition(), guiStack)));
        IAEItemStack aeStack = stackStream.findAny().orElse(null);
        if (aeStack == null) {
            return new RecipeIngredient(IngredientStatus.MISSING, ItemStack.field_190927_a, ingredients, required);
        }
        int missingCount = required - (count = (int)((long)count + aeStack.getStackSize()));
        IngredientStatus status = missingCount > 0 ? (aeStack.isCraftable() ? IngredientStatus.CRAFTABLE : IngredientStatus.MISSING) : IngredientStatus.EXISTS;
        return new RecipeIngredient(status, aeStack.getDefinition().func_77946_l(), ingredients, missingCount);
    }

    private boolean matches(IGuiIngredient<ItemStack> ingredient1, IGuiIngredient<ItemStack> ingredient2) {
        ItemStack first2;
        ItemStack first1 = ItemUtils.getFirstStack(ingredient1);
        return ItemUtils.matches(first1, first2 = ItemUtils.getFirstStack(ingredient2)) && ingredient1.getAllIngredients().size() == ingredient2.getAllIngredients().size();
    }

    private List<IAEItemStack> getStorage() {
        return ItemUtils.getStorage(this.getRepo());
    }

    private ItemRepo getRepo() {
        if (this.isWireless) {
            return this.getWirelessRepo();
        }
        return (ItemRepo)ObfuscationReflectionHelper.getPrivateValue(GuiMEMonitorable.class, (Object)((GuiMEMonitorable)this.term), (String)"repo");
    }

    @Optional.Method(modid="wct")
    private ItemRepo getWirelessRepo() {
        return (ItemRepo)ObfuscationReflectionHelper.getPrivateValue(GuiWCT.class, (Object)((GuiWCT)this.term), (String)"repo");
    }

    public static class RecipeIngredient {
        private final IngredientStatus status;
        private final ItemStack identifier;
        private final List<IGuiIngredient<ItemStack>> merged;
        private final int missingCount;
        private final int missingSlots;

        public RecipeIngredient(IngredientStatus status, ItemStack identifier, List<IGuiIngredient<ItemStack>> merged, int missingCount) {
            this.status = status;
            this.identifier = identifier;
            this.merged = merged;
            this.missingCount = Math.max(missingCount, 0);
            this.missingSlots = this.getMissingSlots(missingCount);
        }

        public RecipeIngredient(IngredientStatus status, ItemStack identifier, List<IGuiIngredient<ItemStack>> merged) {
            this.status = status;
            this.identifier = identifier;
            this.merged = merged;
            this.missingCount = 0;
            this.missingSlots = merged.size();
        }

        private int getMissingSlots(int missingCount) {
            int count = 0;
            int mergedSize = this.merged.size();
            for (int i = 0; i < mergedSize; ++i) {
                IGuiIngredient<ItemStack> ingredient = this.merged.get(i);
                ItemStack first = ItemUtils.getFirstStack(ingredient);
                if ((count += first.func_190916_E()) < missingCount) continue;
                return i + 1;
            }
            return 0;
        }

        public IngredientStatus getStatus() {
            return this.status;
        }

        public ItemStack getIdentifier() {
            return this.identifier;
        }

        public IAEItemStack createAeStack() {
            AEItemStack stack = AEItemStack.fromItemStack((ItemStack)this.identifier);
            if (stack == null) {
                return null;
            }
            stack.setStackSize((long)this.missingCount);
            return stack;
        }

        public void drawHighlight(Minecraft minecraft, Color color, int xOffset, int yOffset) {
            for (int i = 0; i < this.missingSlots && i < this.merged.size(); ++i) {
                IGuiIngredient<ItemStack> ingredient = this.merged.get(i);
                ingredient.drawHighlight(minecraft, color, xOffset, yOffset);
            }
        }
    }
}

