/*
 * Decompiled with CFR 0.152.
 */
package openmods.model.textureditem;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import openmods.model.textureditem.IItemTexture;
import openmods.model.textureditem.ItemTextureCapability;
import org.apache.commons.lang3.tuple.Pair;

public class TexturedItemOverrides
extends ItemOverrideList {
    private final IBakedModel untexturedModel;
    private final IModel texturedModel;
    private final Set<String> texturesToReplace;
    private final IModelState state;
    private final VertexFormat format;
    private final Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter;
    private final LoadingCache<Pair<ResourceLocation, Optional<ResourceLocation>>, IBakedModel> textureOverrides = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<Pair<ResourceLocation, Optional<ResourceLocation>>, IBakedModel>(){

        public IBakedModel load(Pair<ResourceLocation, Optional<ResourceLocation>> key) throws Exception {
            IModel overrideModel = TexturedItemOverrides.this.getOverrideModel((Optional)key.getRight());
            IModel retexturedModel = TexturedItemOverrides.this.retextureModel(overrideModel, (ResourceLocation)key.getKey());
            return retexturedModel.bake(TexturedItemOverrides.this.state, TexturedItemOverrides.this.format, TexturedItemOverrides.this.bakedTextureGetter);
        }
    });

    public TexturedItemOverrides(IBakedModel untexturedModel, IModel texturedModel, List<ItemOverride> texturedModelOverrides, Set<String> texturesToReplace, IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        super(Lists.reverse(texturedModelOverrides));
        this.untexturedModel = untexturedModel;
        this.texturedModel = texturedModel;
        this.texturesToReplace = ImmutableSet.copyOf(texturesToReplace);
        this.state = state;
        this.format = format;
        this.bakedTextureGetter = bakedTextureGetter;
    }

    public IBakedModel handleItemState(IBakedModel originalModel, @Nonnull ItemStack stack, World world, EntityLivingBase entity) {
        Optional<ResourceLocation> texture = TexturedItemOverrides.getTextureFromStack(stack);
        return texture.isPresent() ? this.rebakeModel(texture.get(), stack, world, entity) : this.untexturedModel;
    }

    private IBakedModel rebakeModel(ResourceLocation texture, @Nonnull ItemStack stack, World world, EntityLivingBase entity) {
        Optional<ResourceLocation> overrideLocation = Optional.ofNullable(this.func_188021_a(stack, world, entity));
        return (IBakedModel)this.textureOverrides.getUnchecked((Object)Pair.of((Object)texture, overrideLocation));
    }

    private IModel getOverrideModel(Optional<ResourceLocation> overrideLocation) {
        if (overrideLocation.isPresent()) {
            ResourceLocation location = overrideLocation.get();
            return ModelLoaderRegistry.getModelOrLogError((ResourceLocation)location, (String)("Couldn't load model: " + location));
        }
        return this.texturedModel;
    }

    private IModel retextureModel(IModel overrideModel, ResourceLocation texture) {
        ImmutableMap.Builder textures = ImmutableMap.builder();
        for (String t : this.texturesToReplace) {
            textures.put((Object)t, (Object)texture.toString());
        }
        return overrideModel.retexture(textures.build());
    }

    private static Optional<ResourceLocation> getTextureFromStack(@Nonnull ItemStack stack) {
        if (stack.hasCapability(ItemTextureCapability.CAPABILITY, null)) {
            IItemTexture fluidRender = (IItemTexture)stack.getCapability(ItemTextureCapability.CAPABILITY, null);
            return fluidRender.getTexture();
        }
        return Optional.empty();
    }
}

