/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.client.gui.guielements;

import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTexture;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.projectintelligence.client.PIGuiHelper;
import com.brandon3055.projectintelligence.client.PITextures;
import com.brandon3055.projectintelligence.client.StyleHandler;
import com.brandon3055.projectintelligence.client.gui.PIConfig;
import com.brandon3055.projectintelligence.client.gui.PIGuiContainer;
import com.brandon3055.projectintelligence.client.gui.PIPartRenderer;
import com.brandon3055.projectintelligence.client.gui.guielements.GuiPIConfig;
import com.brandon3055.projectintelligence.client.gui.guielements.GuiStyleEditor;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class GuiPartMenu
extends MGuiElementBase<GuiPartMenu> {
    public static StyleHandler.PropertyGroup menuProps = new StyleHandler.PropertyGroup("menu");
    public static StyleHandler.PropertyGroup closeBtnProps = new StyleHandler.PropertyGroup("menu.close_button");
    public static StyleHandler.PropertyGroup settingsBtnProps = new StyleHandler.PropertyGroup("menu.settings_button");
    public static StyleHandler.PropertyGroup sizeBtnProps = new StyleHandler.PropertyGroup("menu.size_buttons");
    public PIPartRenderer menuRender = new PIPartRenderer(menuProps).setSideTrims(true, true, false, true);
    private PIGuiContainer container;
    public GuiStyleEditor styleEditor = null;
    public GuiPIConfig configUI = null;
    private GuiLabel title;
    private Runnable resizeHandler;
    public GuiButton settingsButton;
    public GuiButton minimizeButton;

    public GuiPartMenu(PIGuiContainer container, @Nullable Runnable resizeHandler) {
        this.container = container;
        this.resizeHandler = resizeHandler;
    }

    public void addChildElements() {
        this.styleEditor = new GuiStyleEditor(this);
        this.configUI = new GuiPIConfig(this, this.styleEditor);
        this.title = new GuiLabel(I18n.func_135052_a((String)"pi.gui.project_intelligence.title", (Object[])new Object[0])){

            public boolean hasShadow() {
                return menuProps.textShadow();
            }
        };
        ((GuiLabel)((GuiLabel)((GuiLabel)this.title.setSize(this.xSize() - 50, 20)).setPos((MGuiElementBase)this)).translate(8, 1)).setAlignment(GuiAlign.LEFT);
        this.title.setTextColGetter(hovering -> menuProps.textColour());
        this.title.setWidthFromText().setTrim(false);
        this.addChild((MGuiElementBase)this.title);
        GuiButton closeButton = (GuiButton)((GuiButton)new GuiButton().setSize(16, 16)).setHoverText(I18n.func_135052_a((String)"pi.button.close.info", (Object[])new Object[0]));
        GuiTexture closeTex = new GuiTexture(0, 0, 16, 16, PITextures.PI_PARTS);
        closeTex.setPreDrawCallback((minecraft, mouseX, mouseY, partialTicks, mouseOver) -> closeBtnProps.glColour(mouseOver));
        closeTex.setPostDrawCallback(MGuiElementBase.IDrawCallback::resetColour);
        closeButton.addChild((MGuiElementBase)closeTex);
        closeButton.addAndFireReloadCallback(guiButton -> {
            GuiButton cfr_ignored_0 = (GuiButton)guiButton.setPos(this.maxXPos() - 20, this.yPos() + 3);
        });
        closeButton.setListener(() -> this.container.closeButtonPressed());
        this.addChild((MGuiElementBase)closeButton);
        this.settingsButton = (GuiButton)((GuiButton)new GuiButton().setSize(16, 16)).setHoverText(I18n.func_135052_a((String)"pi.button.settings.info", (Object[])new Object[0]));
        GuiTexture settingsTex = new GuiTexture(16, 0, 16, 16, PITextures.PI_PARTS);
        settingsTex.setPreDrawCallback((minecraft, mouseX, mouseY, partialTicks, mouseOver) -> settingsBtnProps.glColour(mouseOver));
        settingsTex.setPostDrawCallback(MGuiElementBase.IDrawCallback::resetColour);
        this.settingsButton.addChild((MGuiElementBase)settingsTex);
        this.settingsButton.addAndFireReloadCallback(guiButton -> guiButton.setPos(closeButton.xPos() - guiButton.xSize() - 4, this.yPos() + 3));
        this.settingsButton.setListener(() -> this.configUI.toggleShown());
        this.addChild((MGuiElementBase)this.settingsButton);
        GuiButton maximizeButton = (GuiButton)((GuiButton)new GuiButton().setSize(16, 16)).setHoverText(I18n.func_135052_a((String)"pi.button.maximize.info", (Object[])new Object[0]));
        GuiTexture maximizeTex = new GuiTexture(32, 0, 16, 16, PITextures.PI_PARTS);
        maximizeTex.setPreDrawCallback((minecraft, mouseX, mouseY, partialTicks, mouseOver) -> sizeBtnProps.glColour(mouseOver));
        maximizeTex.setPostDrawCallback(MGuiElementBase.IDrawCallback::resetColour);
        maximizeButton.addChild((MGuiElementBase)maximizeTex);
        maximizeButton.addAndFireReloadCallback(guiButton -> {
            GuiButton cfr_ignored_0 = (GuiButton)guiButton.setPos(this.settingsButton.xPos() - guiButton.xSize() - 4, this.yPos() + 3);
        });
        maximizeButton.setEnabledCallback(() -> PIConfig.screenMode > 0);
        maximizeButton.setListener(() -> this.setGuiSize(true));
        this.minimizeButton = (GuiButton)((GuiButton)new GuiButton().setSize(16, 16)).setHoverText(I18n.func_135052_a((String)"pi.button.minimize.info", (Object[])new Object[0]));
        GuiTexture minimizeTex = new GuiTexture(48, 0, 16, 16, PITextures.PI_PARTS);
        minimizeTex.setPreDrawCallback((minecraft, mouseX, mouseY, partialTicks, mouseOver) -> sizeBtnProps.glColour(mouseOver));
        minimizeTex.setPostDrawCallback(MGuiElementBase.IDrawCallback::resetColour);
        this.minimizeButton.addChild((MGuiElementBase)minimizeTex);
        this.minimizeButton.addAndFireReloadCallback(guiButton -> {
            GuiButton cfr_ignored_0 = (GuiButton)guiButton.setPos(maximizeButton.xPos() - guiButton.xSize() - 4, this.yPos() + 3);
        });
        this.minimizeButton.setEnabledCallback(() -> PIConfig.screenMode < 6);
        this.minimizeButton.setListener(() -> this.setGuiSize(false));
        if (this.resizeHandler != null) {
            this.addChild((MGuiElementBase)maximizeButton);
            this.addChild((MGuiElementBase)this.minimizeButton);
        }
        GuiButton editorButton = (GuiButton)new GuiButton(TextFormatting.UNDERLINE + "" + TextFormatting.RED + I18n.func_135052_a((String)"pi.config.open_editor", (Object[])new Object[0])).setSize(100, 14);
        editorButton.addAndFireReloadCallback(guiButton -> {
            GuiButton cfr_ignored_0 = (GuiButton)guiButton.setPos(this.xPos() + this.xSize() / 2 - 50, this.yPos() + this.ySize() / 2 - 7);
        });
        editorButton.setFillColour(0);
        editorButton.setBorderColours(-9408400, -6250336);
        editorButton.setEnabledCallback(PIConfig::editMode);
        editorButton.setListener((event, eventSource) -> PIGuiHelper.displayEditor());
        this.addChild((MGuiElementBase)editorButton);
        super.addChildElements();
    }

    public void reloadElement() {
        super.reloadElement();
        this.title.setLabelText(I18n.func_135052_a((String)"pi.gui.project_intelligence.title", (Object[])new Object[0]) + (PIConfig.editMode() ? TextFormatting.RED + " (Edit Mode)" : ""));
    }

    protected boolean keyTyped(char typedChar, int keyCode) throws IOException {
        return super.keyTyped(typedChar, keyCode);
    }

    private void setGuiSize(boolean maximize) {
        if (maximize && PIConfig.screenMode > 0) {
            PIConfig.screenMode = GuiScreen.func_146272_n() ? 0 : --PIConfig.screenMode;
        } else if (!maximize && PIConfig.screenMode < 6) {
            PIConfig.screenMode = GuiScreen.func_146272_n() ? 6 : ++PIConfig.screenMode;
        }
        PIConfig.screenPosOverride = false;
        PIConfig.save();
        this.resizeHandler.run();
    }

    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        this.menuRender.render(this);
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
    }
}

