/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.client.gui.swing;

import com.brandon3055.brandonscore.handlers.FileHandler;
import com.brandon3055.projectintelligence.client.PIGuiHelper;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class UINewDoc
extends JDialog {
    private final Map<String, String> idNameMap;
    private boolean local;
    private boolean canceled = false;
    private String info;
    private JComboBox<String> idSelector;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JTextField nameField;
    private JTextField versionField;

    public UINewDoc(Frame parent, Map<String, String> idNameMap, boolean local) {
        super(parent, true);
        this.idNameMap = idNameMap;
        this.local = local;
        this.info = local ? "Local doc is indented to give pack developers the ability to document their pack with project intelligence. Local doc is stored in a separate folder in the config directory and can not be uploaded to the online repo.\nPlease specify a name for this documentation e.g. the name of your mod pack aswell as a page id that contains only lowercase letters and no spaces (must not conflict with existing mod id's) e.g. your_pack_name" : "Please ether select a mod from the list of installed mods (prefered) or manually type the modid and name of the mod you wish to add \ndocumentation for. (modid must be correct)\n\nThe mod version is the minimum version of the mod to which this documentation applies. If you want this to apply to all versions of the mod \nthen leave the default value of 0.0.0";
        this.initComponents();
        if (local) {
            this.idSelector.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    UINewDoc.this.idSelector.getEditor().setItem(String.valueOf(UINewDoc.this.idSelector.getEditor().getItem()).toLowerCase().replace(" ", "_"));
                }
            });
        }
        if (!local) {
            idNameMap.keySet().forEach(this.idSelector::addItem);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.idSelector = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.nameField = new JTextField();
        this.jLabel3 = new JLabel();
        this.versionField = new JTextField();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("New Doc");
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText(this.info);
        this.jTextArea1.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.idSelector.setEditable(true);
        this.idSelector.setModel(new DefaultComboBoxModel<String>(new String[0]));
        this.idSelector.addItemListener(this::modChange);
        this.jLabel1.setText(this.local ? "Doc ID:" : "Mod ID:");
        this.jLabel2.setText(this.local ? "Doc Name:" : "Mod Name:");
        this.jLabel3.setText("Min Mod Version:");
        this.jLabel3.setVisible(!this.local);
        this.versionField.setText("0.0.0");
        this.versionField.addActionListener(this::versionFieldActionPerformed);
        this.versionField.setVisible(!this.local);
        this.jButton1.setText("Add Doc");
        this.jButton1.addActionListener(this::addAction);
        this.jButton2.setText("Cancel");
        this.jButton2.addActionListener(this::cancelAction);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3)).addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.versionField).addComponent(this.idSelector, 0, 281, Short.MAX_VALUE).addComponent(this.nameField))).addGroup(layout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 122, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.idSelector, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.nameField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.versionField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void versionFieldActionPerformed(ActionEvent evt) {
    }

    private void addAction(ActionEvent evt) {
        String error = null;
        if (PIGuiHelper.getSupportedMods().contains(this.getDocID())) {
            error = "Mod already exists! Please update existing documentation for this mod instead.\nIf you need to make major changes to a new version of the mod then simply create\na new version of the documentation. See version help on the Mod tab for more info.";
        } else if (this.getDocID().isEmpty()) {
            error = "Please specify a mod id!";
        } else if (this.getDocName().isEmpty()) {
            error = "Please specify a mod name!";
        } else if (!FileHandler.FILE_NAME_VALIDATOR.test(this.getDocID())) {
            error = "Detected invalid mod id!";
        } else if (!FileHandler.FILE_NAME_VALIDATOR.test(this.getModVersion())) {
            error = "Detected invalid version string!";
        }
        if (error != null) {
            JOptionPane.showMessageDialog(this, error, "Error", 0);
        } else {
            this.dispose();
        }
    }

    private void cancelAction(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void modChange(ItemEvent evt) {
        String name = this.idNameMap.get(this.idSelector.getSelectedItem());
        if (name != null) {
            this.nameField.setText(name);
        }
    }

    public String getDocID() {
        if (this.idSelector.getSelectedItem() == null) {
            return null;
        }
        return this.idSelector.getSelectedItem().toString();
    }

    public String getDocName() {
        return this.nameField.getText();
    }

    public String getModVersion() {
        return this.versionField.getText();
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

