/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands.former;

import com.google.common.collect.Sets;
import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockStates;
import ivorius.ivtoolkit.math.IvShapeHelper;
import ivorius.ivtoolkit.world.MockWorld;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.capability.SelectionOwner;
import ivorius.reccomplex.commands.CommandVirtual;
import ivorius.reccomplex.commands.RCCommands;
import ivorius.reccomplex.commands.parameters.RCP;
import ivorius.reccomplex.commands.parameters.expect.RCE;
import ivorius.reccomplex.shadow.mcopts.commands.CommandExpecting;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.MCP;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.NaP;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.Parameters;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.expect.Expect;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.expect.MCE;
import ivorius.reccomplex.utils.expression.PositionedBlockExpression;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class CommandFill
extends CommandExpecting
implements CommandVirtual {
    public static final int MAX_FLOOD = 125000;

    public static void runShape(RCP.Shape shape, BlockArea area, Consumer<BlockPos> consumer) throws CommandException {
        BlockPos p1 = area.getPoint1();
        BlockPos p2 = area.getPoint2();
        switch (shape) {
            case cube: {
                for (BlockPos pos : area) {
                    consumer.accept(pos);
                }
                break;
            }
            case sphere: {
                double[] spheroidOrigin = new double[]{(double)(p1.func_177958_n() + p2.func_177958_n()) * 0.5, (double)(p1.func_177956_o() + p2.func_177956_o()) * 0.5, (double)(p1.func_177952_p() + p2.func_177952_p()) * 0.5};
                int[] areaSize = area.areaSize();
                double[] spheroidSize = new double[]{(double)areaSize[0] * 0.5, (double)areaSize[1] * 0.5, (double)areaSize[2] * 0.5};
                for (BlockPos pos : area) {
                    double[] coordPoint = new double[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
                    if (!IvShapeHelper.isPointInSpheroid(coordPoint, spheroidOrigin, spheroidSize)) continue;
                    consumer.accept(pos);
                }
                break;
            }
            default: {
                throw new InternalError();
            }
        }
    }

    public static void setFrom(MockWorld world, List<IBlockState> dst, BlockPos pos) {
        IBlockState state = dst.get(world.rand().nextInt(dst.size()));
        world.setBlockState(pos, state, 2);
    }

    public String func_71517_b() {
        return RCConfig.commandPrefix + "fill";
    }

    @Override
    public void expect(Expect expect) {
        expect.then(MCE::block).then(MCE::block).descriptionU("source expression").optional().repeat().named("metadata", "m").then(RCE::metadata).named("shape", "s").then(RCE::shape).named("flood", "f").words(RCE::directionExpression).descriptionU("direction expression");
    }

    public int func_82362_a() {
        return 2;
    }

    @Override
    public void execute(MockWorld world, ICommandSender sender, String[] args) throws CommandException {
        Parameters parameters = Parameters.of(args, this.expect()::declare);
        Block dstBlock = (Block)parameters.get(0).to(MCP::block, sender).require();
        int[] dstMeta = parameters.get("metadata").to(RCP::metadatas).optional().orElse(new int[1]);
        List dst = IntStream.of(dstMeta).mapToObj(m -> BlockStates.fromMetadata(dstBlock, m)).collect(Collectors.toList());
        RCP.Shape shape = parameters.get("shape").to(RCP::shape).optional().orElse(RCP.Shape.cube);
        PositionedBlockExpression matcher = (PositionedBlockExpression)parameters.get(1).rest(NaP::join).orElse("").to(RCP::expression, new PositionedBlockExpression(RecurrentComplex.specialRegistry)).require();
        SelectionOwner selectionOwner = RCCommands.getSelectionOwner(sender, null, true);
        RCCommands.assertSize(sender, selectionOwner);
        if (parameters.has("flood")) {
            List directions = (List)parameters.get("flood").orElse("").to(RCP::directions).require();
            ArrayList<BlockPos> dirty = new ArrayList<BlockPos>();
            HashSet visited = Sets.newHashSet(dirty);
            CommandFill.runShape(shape, selectionOwner.getSelection(), dirty::add);
            while (!dirty.isEmpty()) {
                BlockPos pos2 = (BlockPos)dirty.remove(dirty.size() - 1);
                for (EnumFacing facing : directions) {
                    BlockPos offset = pos2.func_177972_a(facing);
                    if (!((Boolean)matcher.evaluate(() -> PositionedBlockExpression.Argument.at(world, offset))).booleanValue() || !visited.add(offset)) continue;
                    dirty.add(offset);
                }
                if (visited.size() <= 125000) continue;
                throw new CommandException("Area too big to flood!", new Object[0]);
            }
            visited.forEach(p -> CommandFill.setFrom(world, dst, p));
        } else {
            CommandFill.runShape(shape, selectionOwner.getSelection(), pos -> {
                if (((Boolean)matcher.evaluate(() -> PositionedBlockExpression.Argument.at(world, pos))).booleanValue()) {
                    CommandFill.setFrom(world, dst, pos);
                }
            });
        }
    }
}

