/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils.algebra;

import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.utils.algebra.Algebra;
import ivorius.reccomplex.utils.algebra.FunctionExpressionCache;
import ivorius.reccomplex.utils.algebra.FunctionExpressionCaches;
import ivorius.reccomplex.utils.algebra.SupplierCache;
import java.util.function.Function;
import java.util.function.Predicate;

public class BoolFunctionExpressionCache<A, U>
extends FunctionExpressionCache<Boolean, A, U>
implements Predicate<A> {
    public static final String GLOBAL_PREFIX = "global:";

    public BoolFunctionExpressionCache(Algebra<Boolean> algebra) {
        super(algebra);
        this.addBoolConstants();
    }

    public BoolFunctionExpressionCache(Algebra<Boolean> algebra, Boolean emptyResult, String emptyResultRepresentation) {
        super(algebra, emptyResult, emptyResultRepresentation);
        this.addBoolConstants();
    }

    protected void addBoolConstants() {
        this.addType(FunctionExpressionCaches.constant("true", true));
        this.addType(FunctionExpressionCaches.constant("false", false));
        this.addType(new VariableTypeGlobal(GLOBAL_PREFIX, ""));
    }

    @Override
    public boolean test(A a) {
        return (Boolean)this.evaluate(a);
    }

    public static class VariableTypeGlobal
    extends FunctionExpressionCache.VariableType<Boolean, Object, Object> {
        public VariableTypeGlobal(String prefix, String suffix) {
            super(prefix, suffix);
        }

        @Override
        public Function<SupplierCache<Object>, Boolean> parse(String var) {
            return o -> RCConfig.globalToggles.getOrDefault(var, false);
        }

        @Override
        public FunctionExpressionCache.Validity validity(String var, Object o) {
            return RCConfig.globalToggles.containsKey(var) ? FunctionExpressionCache.Validity.KNOWN : FunctionExpressionCache.Validity.UNKNOWN;
        }
    }
}

