/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.generic.placement.rays;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.ivtoolkit.blocks.IvBlockCollection;
import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.ivtoolkit.util.IvStreams;
import ivorius.ivtoolkit.world.WorldCache;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.gui.TableDataSourceExpression;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.cell.TableCellBoolean;
import ivorius.reccomplex.gui.table.cell.TableCellFloatSlider;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSource;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSupplied;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.utils.expression.PositionedBlockExpression;
import ivorius.reccomplex.world.gen.feature.structure.generic.placement.FactorLimit;
import ivorius.reccomplex.world.gen.feature.structure.generic.placement.StructurePlaceContext;
import ivorius.reccomplex.world.gen.feature.structure.generic.placement.rays.RayAverageMatcher;
import java.lang.reflect.Type;
import java.util.OptionalInt;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RayMatcher
extends FactorLimit.Ray {
    public final PositionedBlockExpression destMatcher = new PositionedBlockExpression(RecurrentComplex.specialRegistry);
    public boolean up;
    public float requiredRatio;

    public RayMatcher() {
        this(null, false, 0.5f, "");
    }

    public RayMatcher(Float weight, boolean up, float requiredRatio, String destExpression) {
        super(weight);
        this.up = up;
        this.requiredRatio = requiredRatio;
        this.destMatcher.setExpression(destExpression);
    }

    protected boolean matches(WorldCache cache, Set<BlockPos> surface, int y, float needed) {
        int[] chances = new int[]{surface.size()};
        int[] need = new int[]{(int)((float)chances[0] * needed)};
        chances[0] = chances[0] - need[0];
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        IvStreams.visit(surface.stream(), surfacePos -> {
            pos.func_181079_c(surfacePos.func_177958_n(), surfacePos.func_177956_o() + y, surfacePos.func_177952_p());
            if (((Boolean)this.destMatcher.evaluate(() -> PositionedBlockExpression.Argument.at(cache, (BlockPos)pos))).booleanValue()) {
                need[0] = need[0] - 1;
                return need[0] > 0;
            }
            chances[0] = chances[0] - 1;
            return chances[0] > 0;
        });
        return need[0] <= 0;
    }

    @Override
    public OptionalInt cast(WorldCache cache, StructurePlaceContext context, IvBlockCollection collection, Set<BlockPos> surface, int y) {
        Set<BlockPos> shiftedSurface = RayAverageMatcher.shifted(context, collection, surface);
        int height = cache.world.func_72800_K();
        while (true) {
            if (y < 0 || y >= height) {
                return OptionalInt.empty();
            }
            if (this.matches(cache, shiftedSurface, y, this.requiredRatio)) break;
            y += this.up ? 1 : -1;
        }
        return OptionalInt.of(y);
    }

    @Override
    public String displayString() {
        return String.format("%s %s", RayMatcher.directionArrow(this.up), IvTranslations.get("reccomplex.placer.factors.limit.rays.matcher"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate delegate) {
        return new TableDataSourceSegmented(this.rayTableDataSource(navigator, delegate), TableDataSourceExpression.constructDefault(IvTranslations.get("reccomplex.placer.factors.limit.rays.matcher.condition"), this.destMatcher, null), new TableDataSourceSupplied(() -> {
            TableCellBoolean cell = new TableCellBoolean(null, this.up, IvTranslations.get("reccomplex.direction.up"), IvTranslations.get("reccomplex.direction.down"));
            cell.addListener(v -> {
                this.up = v;
            });
            return new TitledCell(IvTranslations.get("reccomplex.placer.factors.limit.rays.matcher.direction"), cell);
        }, () -> {
            TableCellFloatSlider cell = new TableCellFloatSlider(null, this.requiredRatio, 0.0f, 1.0f);
            cell.addListener(v -> {
                this.requiredRatio = v.floatValue();
            });
            return new TitledCell(IvTranslations.get("reccomplex.placer.factors.limit.rays.matcher.ratio"), cell).withTitleTooltip(IvTranslations.getLines("reccomplex.placer.factors.limit.rays.matcher.ratio.tooltip"));
        }));
    }

    public static class Serializer
    implements JsonSerializer<RayMatcher>,
    JsonDeserializer<RayMatcher> {
        public RayMatcher deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = JsonUtils.asJsonObject(json, "rayMatcher");
            Float weight = JsonUtils.has(jsonObject, "weight") ? Float.valueOf(JsonUtils.getFloat(jsonObject, "weight")) : null;
            boolean up = JsonUtils.getBoolean(jsonObject, "up", true);
            float allowedDivergence = JsonUtils.getFloat(jsonObject, "requiredRatio", 0.0f);
            String destExpression = JsonUtils.getString(jsonObject, "destExpression", "");
            return new RayMatcher(weight, up, allowedDivergence, destExpression);
        }

        public JsonElement serialize(RayMatcher src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            if (src.weight != null) {
                jsonObject.addProperty("weight", (Number)src.weight);
            }
            jsonObject.addProperty("up", Boolean.valueOf(src.up));
            jsonObject.addProperty("requiredRatio", (Number)Float.valueOf(src.requiredRatio));
            jsonObject.addProperty("destExpression", src.destMatcher.getExpression());
            return jsonObject;
        }
    }
}

