/*
 * Decompiled with CFR 0.152.
 */
package requious.compat.jei;

import java.util.ArrayList;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.item.ItemStack;
import requious.Registry;
import requious.compat.jei.AssemblyCategory;
import requious.compat.jei.ingredient.EnergyRenderer;
import requious.compat.jei.ingredient.FakeIngredientHelper;
import requious.compat.jei.ingredient.IngredientTypes;
import requious.compat.jei.ingredient.JEIInfoRenderer;
import requious.compat.jei.ingredient.LaserRenderer;
import requious.data.AssemblyData;

@JEIPlugin
public class Plugin
implements IModPlugin {
    public static IJeiHelpers HELPER;

    public void registerIngredients(IModIngredientRegistration registry) {
        registry.register(IngredientTypes.ENERGY, new ArrayList(), new FakeIngredientHelper(), (IIngredientRenderer)new EnergyRenderer());
        registry.register(IngredientTypes.LASER, new ArrayList(), new FakeIngredientHelper(), (IIngredientRenderer)new LaserRenderer());
        registry.register(IngredientTypes.INFO, new ArrayList(), new FakeIngredientHelper(), (IIngredientRenderer)new JEIInfoRenderer());
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        for (AssemblyData assembly : Registry.ASSEMBLY_DATA) {
            if (!assembly.hasJEIRecipes()) continue;
            assembly.compactJEI();
            registry.addRecipeCategories(new IRecipeCategory[]{new AssemblyCategory(assembly, guiHelper)});
        }
    }

    public void register(IModRegistry reg) {
        HELPER = reg.getJeiHelpers();
        for (AssemblyData assembly : Registry.ASSEMBLY_DATA) {
            if (!assembly.hasJEIRecipes()) continue;
            reg.addRecipes(assembly.getJeiWrappers(), "requious." + assembly.resourceName);
            for (ItemStack catalyst : assembly.getJEICatalysts()) {
                reg.addRecipeCatalyst((Object)catalyst, new String[]{"requious." + assembly.resourceName});
            }
        }
    }
}

