/*
 * Decompiled with CFR 0.152.
 */
package requious.compat.jei.slot;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.util.text.TextFormatting;
import requious.compat.jei.IngredientCollector;
import requious.compat.jei.JEISlot;
import requious.util.Fill;
import requious.util.SlotVisual;

public class DurationSlot
extends JEISlot {
    SlotVisual visual;
    public int duration;

    public DurationSlot(int x, int y, String group, SlotVisual visual) {
        super(x, y, group);
        this.visual = visual;
    }

    @Override
    public JEISlot copy() {
        return new DurationSlot(this.x, this.y, this.group, this.visual);
    }

    @Override
    public void getIngredients(IngredientCollector collector) {
    }

    @Override
    public void render(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.visual.render(minecraft, this.x * 18, this.y * 18, 100, new Fill(0.0f, 0.0f));
    }

    @Override
    public void getTooltip(List<String> tooltip, ITooltipFlag.TooltipFlags tooltipFlag) {
        if (this.duration <= 0) {
            tooltip.add(I18n.func_135052_a((String)"requious.duration.instant", (Object[])new Object[0]));
        } else {
            if (this.duration >= 20) {
                if (this.duration < 1200) {
                    tooltip.add(I18n.func_135052_a((String)"requious.duration.seconds", (Object[])new Object[]{String.format("%.1f", (double)this.duration / 20.0)}));
                } else if (this.duration < 72000) {
                    tooltip.add(I18n.func_135052_a((String)"requious.duration.minutes", (Object[])new Object[]{String.format("%.1f", (double)this.duration / 1200.0)}));
                } else {
                    tooltip.add(I18n.func_135052_a((String)"requious.duration.hours", (Object[])new Object[]{String.format("%.1f", (double)this.duration / 72000.0)}));
                }
            }
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"requious.duration.ticks", (Object[])new Object[]{this.duration}));
        }
    }
}

