/*
 * Decompiled with CFR 0.152.
 */
package requious.compat.jei.slot;

import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import requious.compat.jei.IngredientCollector;
import requious.compat.jei.JEISlot;
import requious.compat.jei.ingredient.Energy;
import requious.compat.jei.ingredient.IngredientTypes;
import requious.util.Misc;

public class EnergySlot
extends JEISlot {
    public Energy input;
    public Energy output;
    public String unit;

    public EnergySlot(int x, int y, String group, String unit) {
        super(x, y, group);
        this.unit = unit;
    }

    @Override
    public boolean isInput() {
        return false;
    }

    @Override
    public void resetFill() {
        super.resetFill();
        this.input = null;
        this.output = null;
    }

    @Override
    public JEISlot copy() {
        EnergySlot energySlot = new EnergySlot(this.x, this.y, this.group, this.unit);
        return energySlot;
    }

    @Override
    public void getIngredients(IngredientCollector collector) {
        if (this.input != null) {
            collector.addInput(IngredientTypes.ENERGY, this.input);
        }
        if (this.output != null) {
            collector.addOutput(IngredientTypes.ENERGY, this.output);
        }
    }

    @Override
    public void render(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        minecraft.func_110434_K().func_110577_a(new ResourceLocation("requious", "textures/gui/assembly_slots.png"));
        Misc.drawTexturedModalRect(this.x * 18, this.y * 18, 18, 72, 18, 18);
    }

    public Energy getEnergy() {
        int energy = 0;
        if (this.input != null) {
            energy -= this.input.energy;
        }
        if (this.output != null) {
            energy += this.output.energy;
        }
        return new Energy(energy, this.unit);
    }
}

