/*
 * Decompiled with CFR 0.152.
 */
package requious.data.component;

import crafttweaker.annotations.ZenRegister;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import requious.data.AssemblyProcessor;
import requious.tile.TileEntityAssembly;
import requious.util.ComponentFace;
import stanhebben.zenscript.annotations.ReturnsSelf;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.requious.Slot")
public abstract class ComponentBase {
    public ComponentFace face;
    public HashSet<String> groups = new HashSet();
    public int x;
    public int y;
    public boolean hidden;

    public ComponentBase(ComponentFace face) {
        this.face = face;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public abstract Slot createSlot();

    @ReturnsSelf
    @ZenMethod
    public ComponentBase setGroup(String group) {
        this.groups.add(group);
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentBase setHidden() {
        this.hidden = true;
        return this;
    }

    public static abstract class Collector {
        TileEntity tile;

        public abstract boolean accept(Slot var1);

        public boolean hasCapability() {
            return false;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing localSide, @Nullable EnumFacing globalSide) {
            return false;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing localSide, @Nullable EnumFacing globalSide) {
            return null;
        }

        public void update() {
        }

        public void updatePost(boolean recipeCrafted) {
        }

        public boolean equals(Object obj) {
            return obj.getClass().equals(this.getClass());
        }

        public void setTile(TileEntity tile) {
            this.tile = tile;
        }

        public TileEntity getTile() {
            return this.tile;
        }

        public EnumFacing getTileFacing() {
            if (this.tile instanceof TileEntityAssembly) {
                return ((TileEntityAssembly)this.tile).getFacing();
            }
            return EnumFacing.UP;
        }
    }

    public static abstract class Slot<T extends ComponentBase>
    implements INBTSerializable<NBTTagCompound> {
        protected final T component;
        private boolean dirty;

        public Slot(T component) {
            this.component = component;
        }

        public ComponentFace getFace() {
            return ((ComponentBase)this.component).face;
        }

        public abstract void addCollectors(List<Collector> var1);

        public abstract net.minecraft.inventory.Slot createGui(AssemblyProcessor var1, int var2, int var3);

        public abstract void update();

        public abstract void machineBroken(World var1, Vec3d var2);

        public boolean isGroup(String group) {
            if (group == null) {
                return true;
            }
            return ((ComponentBase)this.component).groups.contains(group);
        }

        public boolean isHidden() {
            return ((ComponentBase)this.component).hidden;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void markDirty() {
            this.dirty = true;
        }

        public void markClean() {
            this.dirty = false;
        }

        public boolean canShift() {
            return false;
        }
    }
}

