/*
 * Decompiled with CFR 0.152.
 */
package requious.gui.slot;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import requious.data.AssemblyProcessor;
import requious.data.component.ComponentBase;
import requious.gui.GuiAssembly;

public abstract class BaseSlot<T extends ComponentBase.Slot>
extends Slot {
    private static IInventory emptyInventory = new InventoryBasic("[Null]", true, 0);
    protected final AssemblyProcessor assembly;
    protected final T binding;

    public BaseSlot(AssemblyProcessor assembly, T binding, int xPosition, int yPosition) {
        super(emptyInventory, 0, xPosition, yPosition);
        this.binding = binding;
        this.assembly = assembly;
    }

    public void incrStack(int n) {
        this.func_75211_c().func_190917_f(n);
    }

    public boolean isSameInventory(Slot other) {
        return other instanceof BaseSlot;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void renderBackground(GuiAssembly var1, int var2, int var3, float var4, int var5, int var6);

    @SideOnly(value=Side.CLIENT)
    public abstract void renderForeground(GuiAssembly var1, int var2, int var3, int var4, int var5);

    public void clientScroll(int i) {
    }

    public void serverScroll(int i) {
    }

    public void clientClick(EntityPlayer player, ItemStack dragStack, int mouseButton, ClickType type) {
    }

    public void serverClick(EntityPlayerMP player, ItemStack dragStack, int mouseButton, ClickType clickType) {
    }

    public boolean hasToolTip() {
        return false;
    }

    public List<String> getTooltip() {
        return Lists.newArrayList();
    }

    public boolean func_111238_b() {
        return this.shouldRender();
    }

    public boolean shouldRender() {
        return !((ComponentBase.Slot)this.binding).isHidden();
    }

    public boolean canShiftPut() {
        return ((ComponentBase.Slot)this.binding).canShift();
    }

    public boolean canShiftTake() {
        return ((ComponentBase.Slot)this.binding).canShift();
    }

    public boolean isHoverEnabled() {
        return this.func_111238_b();
    }

    public Vec3i getSize() {
        return new Vec3i(16, 16, 0);
    }
}

