/*
 * Decompiled with CFR 0.152.
 */
package requious.gui.slot;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import requious.data.AssemblyProcessor;
import requious.data.component.ComponentFluid;
import requious.gui.GuiAssembly;
import requious.gui.slot.BaseSlot;
import requious.network.PacketHandler;
import requious.network.message.MessageClickSlot;
import requious.util.Fill;
import requious.util.SlotVisual;

public class FluidSlot
extends BaseSlot<ComponentFluid.Slot> {
    public FluidSlot(AssemblyProcessor assembly, ComponentFluid.Slot binding, int xPosition, int yPosition) {
        super(assembly, binding, xPosition, yPosition);
    }

    public boolean func_75214_a(ItemStack stack) {
        return stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
    }

    @Nonnull
    public ItemStack func_75211_c() {
        return ItemStack.field_190927_a;
    }

    public void func_75215_d(ItemStack stack) {
        this.func_75218_e();
    }

    public void func_75220_a(ItemStack p_75220_1_, ItemStack p_75220_2_) {
    }

    public int func_75219_a() {
        return ((ComponentFluid.Slot)this.binding).getCapacity();
    }

    public int func_178170_b(ItemStack stack) {
        return 0;
    }

    public boolean func_82869_a(EntityPlayer playerIn) {
        return false;
    }

    @Override
    public void incrStack(int n) {
    }

    @Override
    public void renderBackground(GuiAssembly assembly, int x, int y, float partialTicks, int mousex, int mousey) {
        SlotVisual background = ((ComponentFluid.Slot)this.binding).getBackground();
        background.render(assembly.field_146297_k, x - 1, y - 1, 100, this.getFill());
    }

    private Fill getFill() {
        return new Fill(((ComponentFluid.Slot)this.binding).getAmount(), ((ComponentFluid.Slot)this.binding).getCapacity());
    }

    @Override
    public void renderForeground(GuiAssembly assembly, int x, int y, int mousex, int mousey) {
        SlotVisual foreground = ((ComponentFluid.Slot)this.binding).getForeground();
        SlotVisual background = ((ComponentFluid.Slot)this.binding).getBackground();
        FluidStack contents = ((ComponentFluid.Slot)this.binding).getContents();
        if (contents != null) {
            assembly.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            TextureAtlasSprite textureSprite = assembly.field_146297_k.func_147117_R().func_110572_b(contents.getFluid().getStill(contents).toString());
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            int widthSlot = background.getWidth();
            int heightSlot = background.getHeight();
            int widthIn = 18 * widthSlot - 2;
            int heightIn = 18 * heightSlot - 2;
            int zLevel = 100;
            double fill = (double)contents.amount / (double)((ComponentFluid.Slot)this.binding).getCapacity();
            double v = MathHelper.func_151238_b((double)textureSprite.func_94206_g(), (double)textureSprite.func_94210_h(), (double)fill);
            double heightLevel = MathHelper.func_151238_b((double)0.0, (double)heightIn, (double)fill);
            double xCoord = x;
            double yCoord = (double)(y + heightIn) - heightLevel;
            Color color = new Color(contents.getFluid().getColor(contents));
            GlStateManager.func_179131_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
            bufferbuilder.func_181662_b(xCoord + 0.0, yCoord + heightLevel, (double)zLevel).func_187315_a((double)textureSprite.func_94209_e(), v).func_181675_d();
            bufferbuilder.func_181662_b(xCoord + (double)widthIn, yCoord + heightLevel, (double)zLevel).func_187315_a((double)textureSprite.func_94212_f(), v).func_181675_d();
            bufferbuilder.func_181662_b(xCoord + (double)widthIn, yCoord + 0.0, (double)zLevel).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94206_g()).func_181675_d();
            bufferbuilder.func_181662_b(xCoord + 0.0, yCoord + 0.0, (double)zLevel).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94206_g()).func_181675_d();
            tessellator.func_78381_a();
        }
        if (foreground != null) {
            foreground.render(assembly.field_146297_k, x - 1, y - 1, 1000, this.getFill());
        }
    }

    public ItemStack func_75209_a(int amount) {
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean hasToolTip() {
        return true;
    }

    @Override
    public List<String> getTooltip() {
        ArrayList<String> tooltip = new ArrayList<String>();
        FluidStack fluid = ((ComponentFluid.Slot)this.binding).getContents();
        int capacity = ((ComponentFluid.Slot)this.binding).getCapacity();
        if (fluid == null) {
            tooltip.add(I18n.func_135052_a((String)"requious.fluid.empty", (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)"requious.fluid", (Object[])new Object[]{fluid.getLocalizedName(), fluid.amount, capacity}));
        }
        return tooltip;
    }

    @Override
    public boolean func_111238_b() {
        return !((ComponentFluid.Slot)this.binding).isHidden() && ((ComponentFluid.Slot)this.binding).isBucketAccepted();
    }

    @Override
    public boolean isHoverEnabled() {
        return true;
    }

    @Override
    public Vec3i getSize() {
        SlotVisual background = ((ComponentFluid.Slot)this.binding).getBackground();
        return new Vec3i(background.getWidth() * 18 - 2, background.getHeight() * 18 - 2, 0);
    }

    @Override
    public boolean canShiftPut() {
        return false;
    }

    @Override
    public boolean canShiftTake() {
        return false;
    }

    @Override
    public void clientClick(EntityPlayer player, ItemStack dragStack, int mouseButton, ClickType clickType) {
        PacketHandler.INSTANCE.sendToServer((IMessage)new MessageClickSlot(this.field_75222_d, dragStack, mouseButton, clickType));
        ItemStack actualStack = player.field_71071_by.func_70445_o();
        if (!actualStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return;
        }
        if (clickType == ClickType.PICKUP) {
            this.handleFluidItem(player, actualStack);
        }
    }

    @Override
    public void serverClick(EntityPlayerMP player, ItemStack dragStack, int mouseButton, ClickType clickType) {
        ItemStack actualStack = player.field_71071_by.func_70445_o();
        if (!actualStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return;
        }
        if (clickType == ClickType.PICKUP) {
            this.handleFluidItem((EntityPlayer)player, actualStack);
        }
    }

    private void handleFluidItem(EntityPlayer player, ItemStack actualStack) {
        FluidActionResult result;
        SlotFluidHandler handler = new SlotFluidHandler();
        if (((ComponentFluid.Slot)this.binding).canTake() && ((ComponentFluid.Slot)this.binding).getAmount() > 0 && (result = FluidUtil.tryFillContainer((ItemStack)actualStack, (IFluidHandler)handler, (int)Integer.MAX_VALUE, (EntityPlayer)player, (boolean)false)).isSuccess()) {
            ItemStack resultStack = result.getResult();
            this.returnItem(player, resultStack);
            FluidUtil.tryFillContainer((ItemStack)actualStack, (IFluidHandler)handler, (int)Integer.MAX_VALUE, (EntityPlayer)player, (boolean)true);
            actualStack.func_190918_g(1);
            player.field_71071_by.func_70437_b(actualStack);
            return;
        }
        if (((ComponentFluid.Slot)this.binding).canPut() && (result = FluidUtil.tryEmptyContainer((ItemStack)actualStack, (IFluidHandler)handler, (int)Integer.MAX_VALUE, (EntityPlayer)player, (boolean)false)).isSuccess()) {
            ItemStack resultStack = result.getResult();
            this.returnItem(player, resultStack);
            FluidUtil.tryEmptyContainer((ItemStack)actualStack, (IFluidHandler)handler, (int)Integer.MAX_VALUE, (EntityPlayer)player, (boolean)true);
            actualStack.func_190918_g(1);
            player.field_71071_by.func_70437_b(actualStack);
            return;
        }
    }

    private void returnItem(EntityPlayer player, ItemStack resultStack) {
        boolean added = player.field_71071_by.func_70441_a(resultStack);
        if (!added) {
            player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u + (double)(player.field_70131_O / 2.0f), player.field_70161_v, resultStack));
        }
    }

    public class SlotFluidHandler
    implements IFluidHandler {
        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[]{(IFluidTankProperties)FluidSlot.this.binding};
        }

        public int fill(FluidStack resource, boolean doFill) {
            return ((ComponentFluid.Slot)FluidSlot.this.binding).fill(resource, !doFill);
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return ((ComponentFluid.Slot)FluidSlot.this.binding).drain(resource, !doDrain);
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return ((ComponentFluid.Slot)FluidSlot.this.binding).drain(maxDrain, !doDrain);
        }
    }
}

