/*
 * Decompiled with CFR 0.152.
 */
package requious.recipe;

import requious.compat.crafttweaker.RecipeContainer;
import requious.compat.jei.JEISlot;
import requious.compat.jei.ingredient.Laser;
import requious.compat.jei.slot.LaserSlot;
import requious.data.component.ComponentBase;
import requious.data.component.ComponentLaser;
import requious.recipe.ConsumptionResult;
import requious.recipe.MatchResult;
import requious.recipe.RequirementBase;
import requious.util.SlotVisual;

public class RequirementLaser
extends RequirementBase {
    String mark;
    String type;
    int energy;
    SlotVisual slotVisual;

    public RequirementLaser(String group, int energy, String mark, SlotVisual slotVisual) {
        super(group);
        this.mark = mark;
        this.energy = energy;
        this.slotVisual = slotVisual;
    }

    public RequirementLaser(String group, String type, int energy, String mark, SlotVisual slotVisual) {
        super(group);
        this.mark = mark;
        this.type = type;
        this.energy = energy;
        this.slotVisual = slotVisual;
    }

    @Override
    public MatchResult matches(ComponentBase.Slot slot, ConsumptionResult result) {
        ComponentLaser.Slot laserSlot;
        int energy;
        if (slot instanceof ComponentLaser.Slot && slot.isGroup(this.group) && (energy = (laserSlot = (ComponentLaser.Slot)slot).getEnergy(this.type)) >= this.energy) {
            result.add(energy);
            return MatchResult.MATCHED;
        }
        return MatchResult.NOT_MATCHED;
    }

    @Override
    public void fillContainer(ComponentBase.Slot slot, ConsumptionResult result, RecipeContainer container) {
        if (this.mark != null) {
            container.addInput(this.mark, ((ComponentLaser.Slot)slot).getTotalEnergy());
        }
    }

    @Override
    public void consume(ComponentBase.Slot slot, ConsumptionResult result) {
    }

    @Override
    public ConsumptionResult createResult() {
        return new ConsumptionResult.Integer((RequirementBase)this, 0);
    }

    @Override
    public boolean fillJEI(JEISlot slot) {
        if (slot instanceof LaserSlot && slot.group.equals(this.group) && !slot.isFilled()) {
            LaserSlot laserSlot = (LaserSlot)slot;
            laserSlot.energies.add(new Laser(this.energy, this.type, this.slotVisual));
            laserSlot.setInput(true);
            return true;
        }
        return false;
    }
}

