/*
 * Decompiled with CFR 0.152.
 */
package requious.recipe;

import requious.compat.jei.JEISlot;
import requious.compat.jei.ingredient.Laser;
import requious.compat.jei.slot.LaserSlot;
import requious.data.component.ComponentBase;
import requious.data.component.ComponentLaser;
import requious.recipe.ResultBase;
import requious.util.LaserVisual;
import requious.util.SlotVisual;

public class ResultLaser
extends ResultBase {
    String type;
    int energy;
    LaserVisual visual;
    SlotVisual slotVisual;

    public ResultLaser(String group, String type, int energy, LaserVisual visual, SlotVisual slotVisual) {
        super(group);
        this.type = type;
        this.energy = energy;
        this.visual = visual;
        this.slotVisual = slotVisual;
    }

    @Override
    public boolean matches(ComponentBase.Slot slot) {
        if (slot instanceof ComponentLaser.Slot && slot.isGroup(this.group)) {
            ComponentLaser.Slot laserSlot = (ComponentLaser.Slot)slot;
            if (laserSlot.getEmitType() == null || laserSlot.getEmitType().equals(this.type)) {
                laserSlot.emit(this.type, this.energy, this.visual);
            }
            return true;
        }
        return false;
    }

    @Override
    public void produce(ComponentBase.Slot slot) {
        ((ComponentLaser.Slot)slot).emit(this.type, this.energy, this.visual);
    }

    @Override
    public boolean fillJEI(JEISlot slot) {
        if (slot instanceof LaserSlot && slot.group.equals(this.group) && !slot.isFilled()) {
            LaserSlot laserSlot = (LaserSlot)slot;
            laserSlot.energies.add(new Laser(this.energy, this.type, this.slotVisual));
            laserSlot.setInput(true);
            return true;
        }
        return false;
    }
}

