/*
 * Decompiled with CFR 0.152.
 */
package requious.util;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class ItemComponentHelper {
    ItemStack item = ItemStack.field_190927_a;
    int amount;
    boolean dirty;

    public ItemStack getStack() {
        ItemStack copy = this.item.func_77946_l();
        copy.func_190920_e(this.amount);
        return copy;
    }

    public void setStack(ItemStack stack) {
        this.item = stack.func_77946_l();
        this.item.func_190920_e(1);
        this.amount = stack.func_190916_E();
        this.markDirty();
    }

    public int getAmount() {
        if (this.item.func_190926_b()) {
            return 0;
        }
        return Math.max(0, this.amount);
    }

    public abstract int getCapacity();

    public ItemStack extract(int maxExtract, boolean simulate) {
        ItemStack copy = this.item.func_77946_l();
        copy.func_190920_e(Math.min(maxExtract, this.amount));
        if (!simulate) {
            this.amount -= Math.min(maxExtract, this.amount);
            if (this.amount <= 0) {
                this.item = ItemStack.field_190927_a;
            }
            this.markDirty();
        }
        return copy;
    }

    public ItemStack insert(ItemStack stack, boolean simulate) {
        if (!this.canStack(stack) || stack.func_190926_b()) {
            return stack;
        }
        stack = stack.func_77946_l();
        ItemStack inserted = stack.func_77979_a(this.getCapacity() - this.amount);
        if (!simulate) {
            this.amount += inserted.func_190916_E();
            this.item = inserted;
            this.item.func_190920_e(1);
            this.markDirty();
        }
        return stack;
    }

    public int insert(int stack, boolean simulate) {
        int inserted = Math.min(stack, this.getCapacity() - this.amount);
        if (!simulate) {
            this.amount += inserted;
            this.markDirty();
        }
        return stack - inserted;
    }

    public boolean canStack(ItemStack stack) {
        return this.item.func_190926_b() || ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)this.item);
    }

    public boolean isEmpty() {
        return this.item.func_190926_b();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void markClean() {
        this.dirty = false;
    }

    public void spawnInWorld(World world, Vec3d pos) {
        for (int i = this.amount; i > 0; i -= this.item.func_77976_d()) {
            ItemStack stack = this.item.func_77946_l();
            stack.func_190920_e(Math.min(i, this.item.func_77976_d()));
            EntityItem item = new EntityItem(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, stack);
            world.func_72838_d((Entity)item);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("stack", (NBTBase)this.item.serializeNBT());
        nbt.func_74768_a("amount", this.amount);
        return nbt;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.item = new ItemStack(nbt.func_74775_l("stack"));
        this.amount = nbt.func_74762_e("amount");
    }
}

