/*
 * Decompiled with CFR 0.152.
 */
package requious.util;

import java.awt.Color;
import java.util.HashMap;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import requious.Requious;
import requious.particle.IParticleAnchor;

public abstract class LaserVisual {
    private static HashMap<String, Supplier<LaserVisual>> REGISTRY = new HashMap();
    String type;
    Color color = Color.WHITE;

    public static void register(String type, Supplier<LaserVisual> supplier) {
        REGISTRY.put(type, supplier);
    }

    public static LaserVisual deserializeNBT(NBTTagCompound compound) {
        LaserVisual visual = REGISTRY.get(compound.func_74779_i("type")).get();
        visual.readFromNBT(compound);
        return visual;
    }

    public LaserVisual(String type) {
        this.type = type;
    }

    public abstract void render(World var1, BlockPos var2, BlockPos var3, int var4);

    public final NBTTagCompound serializeNBT() {
        return this.writeToNBT(new NBTTagCompound());
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74778_a("type", this.type);
        compound.func_74768_a("color", this.color.getRGB());
        return compound;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.color = new Color(compound.func_74762_e("color"), true);
    }

    public static class FireBeam
    extends LaserVisual {
        Random random = new Random();
        float size;
        float wildness;
        float length;
        int time;
        int amount;

        public FireBeam() {
            super("fire_beam");
        }

        public FireBeam(Color color, float size, float wildness, float length, int amount, int time) {
            this();
            this.color = color;
            this.size = size;
            this.wildness = wildness;
            this.length = length;
            this.time = time;
            this.amount = amount;
        }

        @Override
        public void render(World world, BlockPos emit, BlockPos target, int sent) {
            double x1 = (double)emit.func_177958_n() + 0.5;
            double y1 = (double)emit.func_177956_o() + 0.5;
            double z1 = (double)emit.func_177952_p() + 0.5;
            double dx = (double)target.func_177958_n() + 0.5 - x1;
            double dy = (double)target.func_177956_o() + 0.5 - y1;
            double dz = (double)target.func_177952_p() + 0.5 - z1;
            for (int i = 0; i < this.amount; ++i) {
                double rx = (this.random.nextDouble() - 0.5) * 2.0 * (double)this.wildness;
                double ry = (this.random.nextDouble() - 0.5) * 2.0 * (double)this.wildness;
                double rz = (this.random.nextDouble() - 0.5) * 2.0 * (double)this.wildness;
                Requious.PROXY.emitGlow(world, IParticleAnchor.zero(), x1 + rx, y1 + ry, z1 + rz, dx * 2.0 * (double)this.length / (double)this.time, dy * 2.0 * (double)this.length / (double)this.time, dz * 2.0 * (double)this.length / (double)this.time, this.color, 0.0f, this.size, this.time, 0.0f);
            }
        }

        @Override
        public void readFromNBT(NBTTagCompound compound) {
            super.readFromNBT(compound);
            this.size = compound.func_74760_g("size");
            this.wildness = compound.func_74760_g("wildness");
            this.length = compound.func_74760_g("length");
            this.amount = compound.func_74762_e("amount");
            this.time = compound.func_74762_e("time");
        }

        @Override
        public NBTTagCompound writeToNBT(NBTTagCompound compound) {
            compound = super.writeToNBT(compound);
            compound.func_74776_a("size", this.size);
            compound.func_74776_a("wildness", this.wildness);
            compound.func_74776_a("length", this.length);
            compound.func_74768_a("amount", this.amount);
            compound.func_74768_a("time", this.time);
            return compound;
        }
    }

    public static class Lightning
    extends LaserVisual {
        float thickness;
        float wildness;
        int segments;

        public Lightning() {
            super("lightning");
        }

        public Lightning(Color color, float thickness, float wildness, int segments) {
            this();
            this.color = color;
            this.thickness = thickness;
            this.wildness = wildness;
            this.segments = segments;
        }

        @Override
        public void render(World world, BlockPos emit, BlockPos target, int sent) {
            Requious.PROXY.spawnLightning(world, IParticleAnchor.zero(), (double)emit.func_177958_n() + 0.5, (double)emit.func_177956_o() + 0.5, (double)emit.func_177952_p() + 0.5, (double)target.func_177958_n() + 0.5, (double)target.func_177956_o() + 0.5, (double)target.func_177952_p() + 0.5, this.segments, this.wildness, this.color, this.thickness, 5);
        }

        @Override
        public void readFromNBT(NBTTagCompound compound) {
            super.readFromNBT(compound);
            this.thickness = compound.func_74760_g("thickness");
            this.wildness = compound.func_74760_g("wildness");
            this.segments = compound.func_74762_e("segments");
        }

        @Override
        public NBTTagCompound writeToNBT(NBTTagCompound compound) {
            compound = super.writeToNBT(compound);
            compound.func_74776_a("thickness", this.thickness);
            compound.func_74776_a("wildness", this.wildness);
            compound.func_74768_a("segments", this.segments);
            return compound;
        }
    }

    public static class Beam
    extends LaserVisual {
        float thickness;

        public Beam() {
            super("beam");
        }

        public Beam(Color color, float thickness) {
            this();
            this.color = color;
            this.thickness = thickness;
        }

        @Override
        public void render(World world, BlockPos emit, BlockPos target, int sent) {
            Requious.PROXY.spawnSpark(world, IParticleAnchor.zero(), (double)emit.func_177958_n() + 0.5, (double)emit.func_177956_o() + 0.5, (double)emit.func_177952_p() + 0.5, (double)target.func_177958_n() + 0.5, (double)target.func_177956_o() + 0.5, (double)target.func_177952_p() + 0.5, this.color, this.thickness, 5);
        }

        @Override
        public void readFromNBT(NBTTagCompound compound) {
            super.readFromNBT(compound);
            this.thickness = compound.func_74760_g("thickness");
        }

        @Override
        public NBTTagCompound writeToNBT(NBTTagCompound compound) {
            compound = super.writeToNBT(compound);
            compound.func_74776_a("thickness", this.thickness);
            return compound;
        }
    }

    public static class None
    extends LaserVisual {
        public None() {
            super("beam");
        }

        @Override
        public void render(World world, BlockPos emit, BlockPos target, int sent) {
        }
    }
}

