/*
 * Decompiled with CFR 0.152.
 */
package requious.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;

public class RenderUtil {
    public static void renderTextureCuboid(ResourceLocation texture, BlockPos pos, double x1, double y1, double z1, double x2, double y2, double z2, int color) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        int brightness = Minecraft.func_71410_x().field_71441_e.func_175626_b(pos, 0);
        TextureAtlasSprite still = Minecraft.func_71410_x().func_147117_R().getTextureExtry(texture.toString());
        RenderUtil.putTexturedQuad(renderer, still, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.DOWN, color, brightness, false);
        RenderUtil.putTexturedQuad(renderer, still, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.NORTH, color, brightness, false);
        RenderUtil.putTexturedQuad(renderer, still, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.EAST, color, brightness, false);
        RenderUtil.putTexturedQuad(renderer, still, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.SOUTH, color, brightness, false);
        RenderUtil.putTexturedQuad(renderer, still, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.WEST, color, brightness, false);
        RenderUtil.putTexturedQuad(renderer, still, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.UP, color, brightness, false);
        tessellator.func_78381_a();
    }

    public static void renderFluidCuboid(FluidStack fluid, BlockPos pos, double x1, double y1, double z1, double x2, double y2, double z2) {
        int color = fluid.getFluid().getColor(fluid);
        RenderUtil.renderFluidCuboid(fluid, pos, x1, y1, z1, x2, y2, z2, color);
    }

    public static void renderFluidCuboid(FluidStack fluid, BlockPos pos, double x1, double y1, double z1, double x2, double y2, double z2, int color) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        int brightness = Minecraft.func_71410_x().field_71441_e.func_175626_b(pos, fluid.getFluid().getLuminosity());
        TextureAtlasSprite still = Minecraft.func_71410_x().func_147117_R().getTextureExtry(fluid.getFluid().getStill(fluid).toString());
        TextureAtlasSprite flowing = Minecraft.func_71410_x().func_147117_R().getTextureExtry(fluid.getFluid().getFlowing(fluid).toString());
        RenderUtil.putTexturedQuad(renderer, still, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.DOWN, color, brightness, false);
        RenderUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.NORTH, color, brightness, true);
        RenderUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.EAST, color, brightness, true);
        RenderUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.SOUTH, color, brightness, true);
        RenderUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.WEST, color, brightness, true);
        RenderUtil.putTexturedQuad(renderer, still, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.UP, color, brightness, false);
        tessellator.func_78381_a();
    }

    public static void putTexturedQuad(BufferBuilder renderer, TextureAtlasSprite sprite, double x, double y, double z, double w, double h, double d, EnumFacing face, int color, int brightness, boolean flowing) {
        int l1 = brightness >> 16 & 0xFFFF;
        int l2 = brightness & 0xFFFF;
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        RenderUtil.putTexturedQuad(renderer, sprite, x, y, z, w, h, d, face, r, g, b, a, l1, l2, flowing);
    }

    public static void putTexturedQuad(BufferBuilder renderer, TextureAtlasSprite sprite, double x, double y, double z, double w, double h, double d, EnumFacing face, int r, int g, int b, int a, int light1, int light2, boolean flowing) {
        double maxV;
        double minV;
        double maxU;
        double minU;
        double zt2;
        double yt2;
        double xt2;
        if (sprite == null) {
            return;
        }
        double size = 16.0;
        if (flowing) {
            size = 8.0;
        }
        double x1 = x;
        double x2 = x + w;
        double y1 = y;
        double y2 = y + h;
        double z1 = z;
        double z2 = z + d;
        double xt1 = x1 % 1.0;
        for (xt2 = xt1 + w; xt2 > 1.0; xt2 -= 1.0) {
        }
        double yt1 = y1 % 1.0;
        for (yt2 = yt1 + h; yt2 > 1.0; yt2 -= 1.0) {
        }
        double zt1 = z1 % 1.0;
        for (zt2 = zt1 + d; zt2 > 1.0; zt2 -= 1.0) {
        }
        if (flowing) {
            double tmp = 1.0 - yt1;
            yt1 = 1.0 - yt2;
            yt2 = tmp;
        }
        switch (face) {
            case DOWN: 
            case UP: {
                minU = sprite.func_94214_a(xt1 * size);
                maxU = sprite.func_94214_a(xt2 * size);
                minV = sprite.func_94207_b(zt1 * size);
                maxV = sprite.func_94207_b(zt2 * size);
                break;
            }
            case NORTH: 
            case SOUTH: {
                minU = sprite.func_94214_a(xt2 * size);
                maxU = sprite.func_94214_a(xt1 * size);
                minV = sprite.func_94207_b(yt1 * size);
                maxV = sprite.func_94207_b(yt2 * size);
                break;
            }
            case WEST: 
            case EAST: {
                minU = sprite.func_94214_a(zt2 * size);
                maxU = sprite.func_94214_a(zt1 * size);
                minV = sprite.func_94207_b(yt1 * size);
                maxV = sprite.func_94207_b(yt2 * size);
                break;
            }
            default: {
                minU = sprite.func_94209_e();
                maxU = sprite.func_94212_f();
                minV = sprite.func_94206_g();
                maxV = sprite.func_94210_h();
            }
        }
        switch (face) {
            case DOWN: {
                renderer.func_181662_b(x1, y1, z1).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y1, z1).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y1, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x1, y1, z2).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case UP: {
                renderer.func_181662_b(x1, y2, z1).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x1, y2, z2).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z1).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case NORTH: {
                renderer.func_181662_b(x1, y1, z1).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x1, y2, z1).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z1).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y1, z1).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case SOUTH: {
                renderer.func_181662_b(x1, y1, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y1, z2).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z2).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x1, y2, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case WEST: {
                renderer.func_181662_b(x1, y1, z1).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x1, y1, z2).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x1, y2, z2).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x1, y2, z1).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case EAST: {
                renderer.func_181662_b(x2, y1, z1).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z1).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y1, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
            }
        }
    }
}

