/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.client.gui;

import epicsquid.mysticallib.client.gui.InvisibleButton;
import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.roots.container.ContainerImposer;
import epicsquid.roots.container.slots.SlotImposerModifierInfo;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstance;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.network.MessageSetImposerSlot;
import epicsquid.roots.spell.info.StaffSpellInfo;
import epicsquid.roots.spell.info.storage.StaffSpellStorage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiImposer
extends GuiContainer {
    private ContainerImposer container;
    private InvisibleButton backButton;
    private static ResourceLocation SPELL_SELECT = new ResourceLocation("roots", "textures/gui/imposer_spell_select.png");
    private static ResourceLocation MODIFIER_EDIT = new ResourceLocation("roots", "textures/gui/imposer_modifier_edit.png");

    public GuiImposer(@Nonnull ContainerImposer container) {
        super((Container)container);
        this.container = container;
        this.field_146999_f = 176;
        this.field_147000_g = 243;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.backButton = new InvisibleButton(0, this.field_147003_i + 143, this.field_147009_r + 126, 32, 22, I18n.func_135052_a((String)"roots.imposer.back", (Object[])new Object[0]));
        this.field_146292_n.add(this.backButton);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.container.tile.getSlot() != 0) {
            StaffSpellInfo info;
            FontRenderer renderer = Minecraft.func_71410_x().field_71466_p;
            StaffSpellStorage storage = this.container.tile.getSpellStorage();
            if (storage != null && (info = storage.getSpellInSlot(this.container.tile.getSlot())) != null) {
                String name = info.getNonNullSpell().getTextColor() + "" + TextFormatting.BOLD + I18n.func_135052_a((String)("roots.spell." + info.getNonNullSpell().getName() + ".name"), (Object[])new Object[0]);
                RenderHelper.func_74520_c();
                this.func_73732_a(renderer, name, this.field_146294_l / 2, this.field_147009_r + 5, -1);
            }
        }
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_191948_b(int x, int y) {
        if (this.field_146297_k == null || this.field_146297_k.field_71439_g == null) {
            return;
        }
        if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.field_147006_u != null) {
            StaffModifierInstance instance;
            ArrayList<String> tooltip = new ArrayList<String>();
            FontRenderer font = null;
            boolean hasStack = this.field_147006_u.func_75216_d();
            ItemStack stack = this.field_147006_u.func_75211_c();
            SlotImposerModifierInfo info = null;
            if (this.field_147006_u instanceof SlotImposerModifierInfo) {
                info = (SlotImposerModifierInfo)this.field_147006_u;
                if (stack.func_190926_b()) {
                    stack = info.getCore().getStack();
                    hasStack = true;
                }
                StaffModifierInstanceList modifiers = this.container.getModifiers();
                if (info.isDisabled() && info.isApplicable() && info.isApplied()) {
                    tooltip.add(TextFormatting.BOLD + I18n.func_135052_a((String)"roots.tooltip.modifier.not_enabled", (Object[])new Object[0]));
                    tooltip.add("");
                }
                if (!info.isApplied() && info.isApplicable()) {
                    tooltip.add(TextFormatting.BOLD + I18n.func_135052_a((String)"roots.tooltip.modifier.not_applied", (Object[])new Object[0]));
                    tooltip.add("");
                }
                if (!info.isApplicable()) {
                    tooltip.add(TextFormatting.BOLD + I18n.func_135052_a((String)"roots.tooltip.modifier.not_applicable", (Object[])new Object[0]));
                    tooltip.add("");
                    stack = ItemStack.field_190927_a;
                    hasStack = false;
                }
                if (info.isConflicting(modifiers)) {
                    List<StaffModifierInstance> conflicts = info.getConflicts(modifiers);
                    StringJoiner joiner = new StringJoiner(", ");
                    conflicts.forEach(o -> joiner.add(I18n.func_135052_a((String)o.getTranslationKey(), (Object[])new Object[0])));
                    tooltip.add(TextFormatting.BOLD + I18n.func_135052_a((String)"roots.tooltip.modifier.conflicting1", (Object[])new Object[]{joiner.toString()}));
                    tooltip.add("");
                    tooltip.add(TextFormatting.BOLD + I18n.func_135052_a((String)"roots.tooltip.modifier.conflicting2", (Object[])new Object[0]));
                    tooltip.add("");
                }
            }
            if (hasStack) {
                GuiUtils.preItemToolTip((ItemStack)stack);
                tooltip.addAll(this.func_191927_a(stack));
                font = stack.func_77973_b().getFontRenderer(stack);
            }
            if (info != null && (instance = info.get()) != null) {
                tooltip.add("");
                tooltip.add(instance.describeName());
                tooltip.add(instance.describeFunction());
                tooltip.add("");
                tooltip.addAll(instance.describeCost());
                tooltip.add("");
                if (instance.isEnabled()) {
                    tooltip.add(TextFormatting.BOLD + "" + TextFormatting.GREEN + I18n.func_135052_a((String)"roots.tooltip.modifier.enabled", (Object[])new Object[0]));
                } else {
                    tooltip.add(TextFormatting.BOLD + "" + TextFormatting.RED + I18n.func_135052_a((String)"roots.tooltip.modifier.disabled", (Object[])new Object[0]));
                }
            }
            if (!tooltip.isEmpty()) {
                this.drawHoveringText(tooltip, x, y, font == null ? this.field_146289_q : font);
                if (hasStack) {
                    GuiUtils.postItemToolTip();
                }
            }
        }
    }

    protected ResourceLocation getTexture() {
        return this.container.isSelectSpell() ? SPELL_SELECT : MODIFIER_EDIT;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ResourceLocation tex = this.getTexture();
        this.backButton.field_146125_m = tex != SPELL_SELECT;
        this.field_146297_k.func_110434_K().func_110577_a(tex);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, 176, 243);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == this.backButton.field_146127_k && this.field_146297_k != null && this.field_146297_k.field_71439_g != null) {
            MessageSetImposerSlot packet = new MessageSetImposerSlot(this.field_146297_k.field_71439_g.field_70170_p.field_73011_w.getDimension(), this.container.tile.func_174877_v(), 0);
            PacketHandler.INSTANCE.sendToServer((IMessage)packet);
        }
        super.func_146284_a(button);
    }

    public void func_146977_a(Slot slot) {
        SlotImposerModifierInfo modInfo;
        int i2 = slot.field_75223_e - 2;
        int j2 = slot.field_75221_f - 2;
        if (slot instanceof SlotImposerModifierInfo && (!(modInfo = (SlotImposerModifierInfo)slot).isApplicable() || !modInfo.isApplied() || modInfo.isDisabled() || modInfo.isConflicting(this.container.getModifiers()))) {
            int v = -1;
            if (!modInfo.isApplicable()) {
                v = 40;
            } else if (!modInfo.isApplied()) {
                v = 20;
            } else if (modInfo.isConflicting(this.container.getModifiers())) {
                v = 60;
            } else if (modInfo.isDisabled()) {
                v = 0;
            }
            if (v != -1) {
                this.field_146297_k.func_110434_K().func_110577_a(this.getTexture());
                GlStateManager.func_179140_f();
                GlStateManager.func_179141_d();
                this.func_73729_b(i2, j2, 176, v, 20, 20);
                GlStateManager.func_179118_c();
                GlStateManager.func_179145_e();
            }
        }
        super.func_146977_a(slot);
    }
}

