/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.entity.ritual;

import com.google.common.collect.Lists;
import epicsquid.mysticallib.util.ConfigUtil;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.Roots;
import epicsquid.roots.config.GeneralConfig;
import epicsquid.roots.entity.ritual.EntityRitualBase;
import epicsquid.roots.particle.ParticleUtil;
import epicsquid.roots.ritual.RitualRegistry;
import epicsquid.roots.ritual.RitualSpreadingForest;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.oredict.OreDictionary;

public class EntityRitualSpreadingForest
extends EntityRitualBase {
    private RitualSpreadingForest ritual;
    private Set<IBlockState> saplingBlocks = new HashSet<IBlockState>();
    private Set<Block> saplings = new HashSet<Block>();
    private static int SAPLING_OREDICT = -1;

    public EntityRitualSpreadingForest(World worldIn) {
        super(worldIn);
        this.func_184212_Q().func_187214_a(lifetime, (Object)(RitualRegistry.ritual_spreading_forest.getDuration() + 20));
        this.ritual = (RitualSpreadingForest)RitualRegistry.ritual_spreading_forest;
    }

    private boolean canTwoByTwo(World world, BlockPos pos1, int offsetX, int offsetZ) {
        BlockPos pos2 = pos1.func_177982_a(offsetX, 0, offsetZ);
        BlockPos pos3 = pos1.func_177982_a(offsetX + 1, 0, offsetZ);
        BlockPos pos4 = pos1.func_177982_a(offsetX + 1, 0, offsetZ + 1);
        return this.validSpot(world, pos1) && this.validSpot(world, pos2) && this.validSpot(world, pos3) && this.validSpot(world, pos4);
    }

    private boolean validSpot(World world, BlockPos pos) {
        return this.validSpot(world, pos, null);
    }

    private boolean validSpot(World world, BlockPos pos, @Nullable IBlockState plantableState) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        IPlantable plantable = plantableState == null || !(plantableState.func_177230_c() instanceof IPlantable) ? (IPlantable)Blocks.field_150345_g : (IPlantable)plantableState.func_177230_c();
        return world.func_175623_d(pos.func_177984_a()) && block.canSustainPlant(state, (IBlockAccess)world, pos, EnumFacing.UP, plantable);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void func_70071_h_() {
        List positions;
        super.func_70071_h_();
        if (SAPLING_OREDICT == -1) {
            SAPLING_OREDICT = OreDictionary.getOreID((String)"treeSapling");
        }
        float alpha = (float)Math.min(40, RitualRegistry.ritual_spreading_forest.getDuration() + 20 - (Integer)this.func_184212_Q().func_187225_a(lifetime)) / 40.0f;
        if (this.field_70170_p.field_72995_K && (Integer)this.func_184212_Q().func_187225_a(lifetime) > 0) {
            ParticleUtil.spawnParticleStar(this.field_70170_p, (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v, 0.0f, 0.0f, 0.0f, 150.0f, 255.0f, 100.0f, 0.5f * alpha, 20.0f, 40);
            if (this.field_70146_Z.nextInt(5) == 0) {
                ParticleUtil.spawnParticleSpark(this.field_70170_p, (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v, 0.125f * (this.field_70146_Z.nextFloat() - 0.5f), 0.0625f * this.field_70146_Z.nextFloat(), 0.125f * (this.field_70146_Z.nextFloat() - 0.5f), 100.0f, 255.0f, 50.0f, 1.0f * alpha, 1.0f + this.field_70146_Z.nextFloat(), 160);
            }
            if (this.field_70146_Z.nextInt(2) == 0) {
                for (float i = 0.0f; i < 360.0f; i += this.field_70146_Z.nextFloat() * 120.0f) {
                    float tx = (float)this.field_70165_t + 2.0f * (float)Math.sin(Math.toRadians(i));
                    float ty = (float)this.field_70163_u;
                    float tz = (float)this.field_70161_v + 2.0f * (float)Math.cos(Math.toRadians(i));
                    for (int j = 0; j < 4; ++j) {
                        ParticleUtil.spawnParticleStar(this.field_70170_p, tx, ty + 0.2f, tz, 0.0f, this.field_70146_Z.nextFloat() * 0.125f, 0.0f, 100.0f, 255.0f, 50.0f, 0.5f * alpha, 5.0f + this.field_70146_Z.nextFloat() * 5.0f, 90);
                    }
                }
            }
        }
        if (this.saplingBlocks.isEmpty()) {
            List positions2;
            List positions3 = Util.getBlocksWithinRadius((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (float)this.ritual.radius_x, (float)this.ritual.radius_y, (float)this.ritual.radius_z, pos -> this.field_70170_p.func_180495_p(pos).func_177230_c() instanceof BlockLeaves);
            if (!positions3.isEmpty()) {
                for (BlockPos pos2 : positions3) {
                    IBlockState state = this.field_70170_p.func_180495_p(pos2);
                    Block block = state.func_177230_c();
                    List drops = block.getDrops((IBlockAccess)this.field_70170_p, pos2, state, 0);
                    for (ItemStack itemStack : drops) {
                        if (ConfigUtil.setContainsItemStack(GeneralConfig.getSaplingBlacklist(), (ItemStack)itemStack) || !(itemStack.func_77973_b() instanceof ItemBlock)) continue;
                        if (((ItemBlock)itemStack.func_77973_b()).func_179223_d() instanceof BlockSapling) {
                            Block sap = ((ItemBlock)itemStack.func_77973_b()).func_179223_d();
                            this.saplings.add(sap);
                            this.saplingBlocks.add(sap.func_176203_a(itemStack.func_77960_j()));
                            continue;
                        }
                        boolean isSapling = false;
                        for (int id : OreDictionary.getOreIDs((ItemStack)itemStack)) {
                            if (id != SAPLING_OREDICT || id == -1) continue;
                            isSapling = true;
                            break;
                        }
                        if (!isSapling) continue;
                        Block sap = ((ItemBlock)itemStack.func_77973_b()).func_179223_d();
                        this.saplingBlocks.add(sap.func_176203_a(itemStack.func_77960_j()));
                        this.saplings.add(sap);
                    }
                }
            }
            if (!(positions2 = Util.getBlocksWithinRadius((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (float)this.ritual.radius_x, (float)this.ritual.radius_y, (float)this.ritual.radius_z, pos -> {
                if (this.field_70170_p.func_175623_d(pos)) {
                    return false;
                }
                return this.field_70170_p.func_180495_p(pos).func_177230_c() instanceof IGrowable;
            })).isEmpty()) {
                for (BlockPos pos3 : positions3) {
                    IBlockState state = this.field_70170_p.func_180495_p(pos3);
                    Block block = state.func_177230_c();
                    ItemStack stack = block.func_185473_a(this.field_70170_p, pos3, state);
                    if (ConfigUtil.setContainsItemStack(GeneralConfig.getSaplingBlacklist(), (ItemStack)stack) || stack.func_190926_b()) continue;
                    if (state.func_177227_a().contains(BlockSapling.field_176479_b)) {
                        this.saplingBlocks.add(state);
                        this.saplings.add(state.func_177230_c());
                        continue;
                    }
                    for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
                        if (id != SAPLING_OREDICT || id == -1) continue;
                        this.saplingBlocks.add(state);
                        this.saplings.add(block);
                    }
                }
            }
        }
        if (this.field_70173_aa % this.ritual.place_interval == 0 && !this.saplingBlocks.isEmpty()) {
            IBlockState state = (IBlockState)Lists.newArrayList(this.saplingBlocks).get(this.field_70146_Z.nextInt(this.saplingBlocks.size()));
            List positions4 = Util.getBlocksWithinRadius((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (float)this.ritual.radius_x, (float)this.ritual.radius_y, (float)this.ritual.radius_z, pos -> this.validSpot(this.field_70170_p, (BlockPos)pos, state));
            if (!positions4.isEmpty() && !this.field_70170_p.field_72995_K) {
                boolean planted = false;
                boolean twoByTwo = false;
                BlockPlanks.EnumType type = null;
                if (state.func_177227_a().contains(BlockSapling.field_176480_a)) {
                    type = (BlockPlanks.EnumType)state.func_177229_b((IProperty)BlockSapling.field_176480_a);
                    if (type == BlockPlanks.EnumType.DARK_OAK || (type == BlockPlanks.EnumType.JUNGLE || type == BlockPlanks.EnumType.SPRUCE) && this.field_70146_Z.nextFloat() <= this.ritual.double_chance) {
                        twoByTwo = true;
                    }
                } else if (ConfigUtil.setContainsItemStack(GeneralConfig.getTwoByTwoSaplings(), (ItemStack)state.func_177230_c().func_185473_a(this.field_70170_p, BlockPos.field_177992_a, state))) {
                    twoByTwo = true;
                }
                if (twoByTwo) {
                    void var9_33;
                    boolean validPos = false;
                    BlockPos pos4 = null;
                    int n = 30;
                    int i = 0;
                    int j = 0;
                    block7: while (var9_33 >= 0) {
                        pos4 = (BlockPos)positions4.get(this.field_70146_Z.nextInt(positions4.size()));
                        for (i = 0; i >= -1; --i) {
                            for (j = 0; j >= -1; --j) {
                                if (!this.canTwoByTwo(this.field_70170_p, pos4, i, j)) continue;
                                validPos = true;
                                break block7;
                            }
                        }
                        --var9_33;
                    }
                    if (!validPos && type != BlockPlanks.EnumType.DARK_OAK) {
                        planted = true;
                    }
                    if (validPos) {
                        this.field_70170_p.func_175656_a(pos4.func_177984_a(), state);
                        BlockPos pos2 = pos4.func_177984_a().func_177982_a(i, 0, j + 1);
                        this.field_70170_p.func_175656_a(pos2, state);
                        BlockPos pos3 = pos4.func_177984_a().func_177982_a(i + 1, 0, j);
                        this.field_70170_p.func_175656_a(pos3, state);
                        BlockPos pos42 = pos4.func_177984_a().func_177982_a(i + 1, 0, j + 1);
                        this.field_70170_p.func_175656_a(pos42, state);
                        planted = true;
                    }
                }
                if (!planted) {
                    BlockPos position = (BlockPos)positions4.get(this.field_70146_Z.nextInt(positions4.size()));
                    this.field_70170_p.func_175656_a(position.func_177984_a(), state);
                }
            }
        }
        if (this.field_70173_aa % this.ritual.growth_interval == 0 && !(positions = Util.getBlocksWithinRadius((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (float)this.ritual.radius_x, (float)this.ritual.radius_y, (float)this.ritual.radius_z, pos -> {
            IBlockState state = this.field_70170_p.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (block instanceof BlockSapling || this.saplings.contains(block)) {
                return true;
            }
            return state.func_177227_a().contains(BlockSapling.field_176479_b);
        })).isEmpty() && !this.field_70170_p.field_72995_K) {
            BlockPos pos5 = (BlockPos)positions.get(this.field_70146_Z.nextInt(positions.size()));
            IBlockState state = this.field_70170_p.func_180495_p(pos5);
            if (state.func_177230_c() instanceof IGrowable) {
                ((IGrowable)state.func_177230_c()).func_176474_b(this.field_70170_p, this.field_70146_Z, pos5, state);
            } else {
                Roots.logger.error("'Sapling' at " + pos5.toString() + " is not IGrowable!");
            }
        }
    }
}

