/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.handler;

import epicsquid.roots.init.HerbRegistry;
import epicsquid.roots.item.ItemPouch;
import epicsquid.roots.item.PouchType;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.ItemStackHandler;

public class OldPouchHandler
implements INBTSerializable<NBTTagCompound> {
    public static final int COMPONENT_POUCH_HERB_SLOTS = 6;
    public static final int COMPONENT_POUCH_INVENTORY_SLOTS = 12;
    public static final int APOTHECARY_POUCH_HERB_SLOTS = 9;
    public static final int APOTHECARY_POUCH_INVENTORY_SLOTS = 18;
    private PouchItemHandler inventorySlots;
    private PouchHerbHandler herbSlots;
    private ItemStack pouch;
    private boolean isApoth = false;

    public OldPouchHandler(ItemStack pouch, int inventorySlots, int herbSlots) {
        this.pouch = pouch;
        if (inventorySlots == 18) {
            this.isApoth = true;
        }
        this.inventorySlots = new PouchItemHandler(inventorySlots);
        this.herbSlots = new PouchHerbHandler(herbSlots);
    }

    public PouchItemHandler getInventory() {
        return this.inventorySlots;
    }

    public PouchHerbHandler getHerbs() {
        return this.herbSlots;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("inventory_slots", (NBTBase)this.inventorySlots.serializeNBT());
        tag.func_74782_a("herb_slots", (NBTBase)this.herbSlots.serializeNBT());
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        NBTTagCompound inv = nbt.func_74775_l("inventory_slots");
        NBTTagCompound herb = nbt.func_74775_l("herb_slots");
        if (this.isApoth) {
            if (inv.func_74762_e("Size") != 18) {
                inv.func_74768_a("Size", 18);
            }
            if (herb.func_74762_e("Size") != 9) {
                herb.func_74768_a("Size", 9);
            }
        }
        this.inventorySlots.deserializeNBT(inv);
        this.herbSlots.deserializeNBT(herb);
    }

    public static OldPouchHandler getHandler(ItemStack stack) {
        NBTTagCompound tag;
        PouchType type = ItemPouch.getPouchType(stack);
        OldPouchHandler handler = type == PouchType.APOTHECARY ? new OldPouchHandler(stack, 18, 9) : new OldPouchHandler(stack, 12, 6);
        if (stack.func_77942_o() && (tag = stack.func_77978_p()).func_74764_b("handler")) {
            handler.deserializeNBT(tag.func_74775_l("handler"));
        }
        return handler;
    }

    public void saveToStack() {
        NBTTagCompound tag = this.pouch.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            this.pouch.func_77982_d(tag);
        }
        tag.func_74782_a("handler", (NBTBase)this.serializeNBT());
    }

    public class PouchHerbHandler
    extends PouchItemHandler {
        public PouchHerbHandler(int size) {
            super(size);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return HerbRegistry.isHerb(stack.func_77973_b());
        }

        public int refill(ItemStack herbStack) {
            if (!this.containsHerb(herbStack.func_77973_b())) {
                return herbStack.func_190916_E();
            }
            Item herb = herbStack.func_77973_b();
            int count = herbStack.func_190916_E();
            for (ItemStack stack : this.stacks) {
                int consumed;
                if (stack.func_77973_b() == herb && stack.func_190916_E() < stack.func_77976_d() && (consumed = Math.min(count, stack.func_77976_d() - stack.func_190916_E())) > 0) {
                    stack.func_190917_f(consumed);
                    count = Math.max(0, count - consumed);
                    OldPouchHandler.this.saveToStack();
                }
                if (count != 0) continue;
                return 0;
            }
            return count;
        }

        public boolean containsHerb(Item item) {
            for (ItemStack stack : this.stacks) {
                if (stack.func_77973_b() != item) continue;
                return true;
            }
            return false;
        }
    }

    public class PouchItemHandler
    extends ItemStackHandler {
        public PouchItemHandler(int size) {
            super(size);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            OldPouchHandler.this.saveToStack();
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            super.setStackInSlot(slot, stack);
            OldPouchHandler.this.saveToStack();
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            ItemStack result = super.insertItem(slot, stack, simulate);
            OldPouchHandler.this.saveToStack();
            return result;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack result = super.extractItem(slot, amount, simulate);
            OldPouchHandler.this.saveToStack();
            return result;
        }
    }
}

