/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.handler;

import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.roots.Roots;
import epicsquid.roots.handler.IPouchHandler;
import epicsquid.roots.handler.OldPouchHandler;
import epicsquid.roots.item.ItemPouch;
import epicsquid.roots.item.PouchType;
import epicsquid.roots.world.data.PouchHandlerData;
import epicsquid.roots.world.data.PouchHandlerRegistry;
import java.util.ArrayList;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class PouchHandler
implements IPouchHandler {
    private IItemHandlerModifiable inventorySlots;
    private IItemHandlerModifiable herbSlots;
    private ItemStack pouch;
    private Runnable markDirty;
    private Function<ItemStack, Integer> filler;

    public PouchHandler(ItemStack pouch) {
        PouchHandlerData data;
        this.pouch = pouch;
        NBTTagCompound tag = ItemUtil.getOrCreateTag((ItemStack)pouch);
        PouchType type = ItemPouch.getPouchType(pouch);
        if (tag.func_186855_b("bag_id")) {
            data = PouchHandlerRegistry.getData(tag.func_186857_a("bag_id"), type);
        } else {
            data = PouchHandlerRegistry.getNewData(type);
            tag.func_186854_a("bag_id", data.getUuid());
        }
        this.inventorySlots = data.getInventoryHandler();
        this.herbSlots = data.getHerbHandler();
        this.markDirty = () -> ((PouchHandlerData)data).func_76185_a();
        this.filler = data::refill;
        if (tag.func_150297_b("handler", 10)) {
            ItemStack result;
            ItemStack stack2;
            int i;
            OldPouchHandler oldPouch = OldPouchHandler.getHandler(pouch);
            ArrayList<ItemStack> oldInventory = new ArrayList<ItemStack>();
            ArrayList<ItemStack> oldHerbs = new ArrayList<ItemStack>();
            OldPouchHandler.PouchItemHandler current = oldPouch.getInventory();
            for (i = 0; i < current.getSlots(); ++i) {
                stack2 = current.getStackInSlot(i);
                if (stack2.func_190926_b()) continue;
                oldInventory.add(stack2);
            }
            current = oldPouch.getHerbs();
            for (i = 0; i < current.getSlots(); ++i) {
                stack2 = current.getStackInSlot(i);
                if (stack2.func_190926_b()) continue;
                oldHerbs.add(stack2);
            }
            for (ItemStack stack2 : oldInventory) {
                result = ItemHandlerHelper.insertItemStacked((IItemHandler)this.inventorySlots, (ItemStack)stack2, (boolean)false);
                if (result.func_190926_b()) continue;
                Roots.logger.error("Unable to fully merge itemstack " + stack2.toString() + " into new component/apothecary inventory.");
            }
            for (ItemStack stack2 : oldHerbs) {
                result = ItemHandlerHelper.insertItemStacked((IItemHandler)this.herbSlots, (ItemStack)stack2, (boolean)false);
                if (result.func_190926_b()) continue;
                Roots.logger.error("Unable to fully merge itemstack " + stack2.toString() + " into new component/apothecary herbs.");
            }
            tag.func_82580_o("handler");
            this.markDirty();
        }
    }

    @Override
    public int refill(ItemStack herbStack) {
        return this.filler.apply(herbStack);
    }

    @Override
    public PouchType getPouchType() {
        return ItemPouch.getPouchType(this.pouch);
    }

    @Override
    public IItemHandlerModifiable getInventory() {
        return this.inventorySlots;
    }

    @Override
    public IItemHandlerModifiable getHerbs() {
        return this.herbSlots;
    }

    @Override
    public void markDirty() {
        this.markDirty.run();
    }

    @Nullable
    public static PouchHandler getHandler(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ItemPouch)) {
            return null;
        }
        return new PouchHandler(stack);
    }
}

