/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.integration;

import epicsquid.roots.integration.jei.JEIRootsPlugin;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.IRecipesGui;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookCategory;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;

public class IntegrationUtil {
    @SideOnly(value=Side.CLIENT)
    public static void openBook(World world, EntityPlayer player, ResourceLocation resourceLocation, ResourceLocation entryLocation, int page) {
        if (world.field_72995_K) {
            PatchouliAPI.instance.openBookGUI(resourceLocation);
            SoundEvent sfx = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("patchouli", "book_open"));
            if (sfx != null) {
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, sfx, SoundCategory.PLAYERS, 1.0f, (float)(0.7 + Math.random() * 0.4));
            }
            Book book = (Book)BookRegistry.INSTANCE.books.get(resourceLocation);
            BookEntry entry = null;
            if (book != null) {
                for (ResourceLocation location : book.contents.entries.keySet()) {
                    if (!entryLocation.equals((Object)location)) continue;
                    entry = (BookEntry)book.contents.entries.get(location);
                    break;
                }
                if (entry != null && !entry.isLocked()) {
                    GuiBookEntry pageToOpen = new GuiBookEntry(book, entry, page);
                    book.contents.openLexiconGui((GuiBook)pageToOpen, true);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void openCategory(ResourceLocation book, ResourceLocation category) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71439_g == null) {
            return;
        }
        IntegrationUtil.openCategory((World)mc.field_71441_e, (EntityPlayer)mc.field_71439_g, book, category);
    }

    @SideOnly(value=Side.CLIENT)
    public static void openCategory(World world, EntityPlayer player, ResourceLocation resourceLocation, ResourceLocation categoryLocation) {
        if (world.field_72995_K) {
            PatchouliAPI.instance.openBookGUI(resourceLocation);
            SoundEvent sfx = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("patchouli", "book_open"));
            if (sfx != null) {
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, sfx, SoundCategory.PLAYERS, 1.0f, (float)(0.7 + Math.random() * 0.4));
            }
            Book book = (Book)BookRegistry.INSTANCE.books.get(resourceLocation);
            BookCategory entry = null;
            if (book != null) {
                for (ResourceLocation location : book.contents.categories.keySet()) {
                    if (!categoryLocation.equals((Object)location)) continue;
                    entry = (BookCategory)book.contents.categories.get(location);
                    break;
                }
                if (entry != null && !entry.isLocked()) {
                    GuiBookCategory pageToOpen = new GuiBookCategory(book, entry);
                    book.contents.openLexiconGui((GuiBook)pageToOpen, true);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void showUses(ItemStack stack) {
        if (JEIRootsPlugin.runtime == null) {
            return;
        }
        IRecipeRegistry registry = JEIRootsPlugin.runtime.getRecipeRegistry();
        IRecipesGui gui = JEIRootsPlugin.runtime.getRecipesGui();
        gui.show(registry.createFocus(IFocus.Mode.INPUT, (Object)stack));
    }

    @SideOnly(value=Side.CLIENT)
    public static void showSources(ItemStack stack) {
        if (JEIRootsPlugin.runtime == null) {
            return;
        }
        IRecipeRegistry registry = JEIRootsPlugin.runtime.getRecipeRegistry();
        IRecipesGui gui = JEIRootsPlugin.runtime.getRecipesGui();
        gui.show(registry.createFocus(IFocus.Mode.OUTPUT, (Object)stack));
    }
}

