/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.integration.jei.shears;

import com.google.common.collect.Lists;
import epicsquid.roots.recipe.RunicShearEntityRecipe;
import epicsquid.roots.util.RenderUtil;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.World;

public class RunicShearsEntityWrapper
implements IRecipeWrapper {
    public EntityLivingBase entity = null;
    public final RunicShearEntityRecipe recipe;

    public RunicShearsEntityWrapper(RunicShearEntityRecipe recipe) {
        this.recipe = recipe;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setOutputs(VanillaTypes.ITEM, (List)Lists.newArrayList((Object[])this.recipe.getDropMatch().func_193365_a()));
    }

    public int getCooldown() {
        return this.recipe.getCooldown() / 20;
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        if (this.entity == null) {
            this.entity = this.recipe.getEntity((World)minecraft.field_71441_e);
        }
        float scale = RunicShearsEntityWrapper.getScale(this.entity);
        RenderUtil.drawEntityOnScreen(30, 70, scale, 38 - mouseX, 70 - mouseY, this.entity);
    }

    public static float getScale(EntityLivingBase entityLivingBase) {
        float width = entityLivingBase.field_70130_N;
        float height = entityLivingBase.field_70131_O;
        if (width <= height) {
            if ((double)height < 0.9) {
                return 40.0f;
            }
            if (height < 1.0f) {
                return 25.0f;
            }
            if ((double)height < 1.8) {
                return 23.0f;
            }
            if (height < 2.0f) {
                return 22.0f;
            }
            if (height < 3.0f) {
                return 14.0f;
            }
            if (height < 4.0f) {
                return 10.0f;
            }
            return 0.0f;
        }
        if (width < 1.0f) {
            return 28.0f;
        }
        if (width < 2.0f) {
            return 17.0f;
        }
        if (width < 3.0f) {
            return 3.0f;
        }
        return -1.0f;
    }
}

