/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.modifiers;

import epicsquid.roots.api.Herb;
import epicsquid.roots.init.HerbRegistry;
import epicsquid.roots.modifiers.BaseModifiers;
import epicsquid.roots.modifiers.IModifierCore;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.NotImplementedException;

public enum ModifierCores implements IModifierCore
{
    PERESKIA(new ResourceLocation("roots", "pereskia"), TextFormatting.BOLD + "" + TextFormatting.LIGHT_PURPLE),
    WILDEWHEET(new ResourceLocation("roots", "wildewheet"), TextFormatting.GOLD + "" + TextFormatting.BOLD),
    WILDROOT(new ResourceLocation("roots", "wildroot"), TextFormatting.YELLOW + ""),
    MOONGLOW_LEAF(new ResourceLocation("roots", "moonglow_leaf"), TextFormatting.DARK_PURPLE + ""),
    SPIRIT_HERB(new ResourceLocation("roots", "spirit_herb"), TextFormatting.GREEN + "" + TextFormatting.BOLD),
    TERRA_MOSS(new ResourceLocation("roots", "terra_moss"), TextFormatting.DARK_GREEN + "" + TextFormatting.BOLD),
    BAFFLE_CAP(new ResourceLocation("roots", "baffle_cap"), TextFormatting.DARK_PURPLE + "" + TextFormatting.BOLD),
    CLOUD_BERRY(new ResourceLocation("roots", "cloud_berry"), TextFormatting.AQUA + "" + TextFormatting.BOLD),
    INFERNAL_BULB(new ResourceLocation("roots", "infernal_bulb"), TextFormatting.RED + "" + TextFormatting.BOLD),
    STALICRIPE(new ResourceLocation("roots", "stalicripe"), TextFormatting.DARK_RED + "" + TextFormatting.BOLD),
    DEWGONIA(new ResourceLocation("roots", "dewgonia"), TextFormatting.DARK_AQUA + "" + TextFormatting.BOLD);

    private static Set<Item> modifierCores;
    private final Supplier<ItemStack> stack;
    private final Supplier<Herb> herb = () -> HerbRegistry.getHerb(herb);
    private final String formatting;
    private final ResourceLocation registryName;
    private String cachedName = null;

    private ModifierCores(ResourceLocation herb, String formatting) {
        this.stack = () -> ItemStack.field_190927_a;
        this.formatting = formatting;
        this.registryName = herb;
    }

    @Override
    public Herb getHerb() {
        return this.herb.get();
    }

    @Override
    public ItemStack getStack() {
        ItemStack sup = this.stack.get();
        if (this.herb != null) {
            if (sup.func_190926_b()) {
                sup = new ItemStack(this.herb.get().getItem());
            }
            return sup;
        }
        return sup;
    }

    @Override
    public String getTranslationKey() {
        return "roots.modifiers.cores." + this.name().toLowerCase();
    }

    @Override
    public String getFormatting() {
        return this.formatting;
    }

    @Override
    public int getKey() {
        return this.ordinal();
    }

    @Nullable
    public static IModifierCore fromOrdinal(int ordinal) {
        if (ordinal == -1) {
            return BaseModifiers.AIR;
        }
        for (ModifierCores core : ModifierCores.values()) {
            if (core.ordinal() != ordinal) continue;
            return core;
        }
        return null;
    }

    public static boolean isModifierCore(Item item) {
        if (modifierCores == null) {
            modifierCores = Stream.of(ModifierCores.values()).map(ModifierCores::getStack).map(ItemStack::func_77973_b).collect(Collectors.toSet());
        }
        return modifierCores.contains(item);
    }

    public static boolean isModifierCore(ItemStack stack) {
        return ModifierCores.isModifierCore(stack.func_77973_b());
    }

    @Nullable
    public static ModifierCores fromHerb(Herb herb) {
        for (ModifierCores core : ModifierCores.values()) {
            if (core.getHerb() != herb) continue;
            return core;
        }
        return null;
    }

    @Nullable
    public static ModifierCores fromItemStack(ItemStack stack) {
        if (!ModifierCores.isModifierCore(stack)) {
            return null;
        }
        for (ModifierCores core : ModifierCores.values()) {
            if (core.getHerb().getItem() != stack.func_77973_b()) continue;
            return core;
        }
        return null;
    }

    @Override
    public void setRegistryName(ResourceLocation name) {
        throw new NotImplementedException("setRegistryName not implemented for this");
    }

    @Override
    @Nonnull
    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    @Override
    @Nonnull
    public String getCachedName() {
        if (this.cachedName == null) {
            this.cachedName = this.registryName.toString();
        }
        return this.cachedName;
    }

    static {
        modifierCores = null;
    }
}

