/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.modifiers.instance.staff;

import epicsquid.roots.api.Herb;
import epicsquid.roots.modifiers.CostType;
import epicsquid.roots.modifiers.IModifier;
import epicsquid.roots.modifiers.Modifier;
import epicsquid.roots.modifiers.instance.library.LibraryModifierInstance;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;

public class StaffModifierInstance
extends LibraryModifierInstance {
    private boolean enabled;

    public StaffModifierInstance(Modifier modifier, boolean applied, boolean enabled) {
        super(modifier, applied);
        this.enabled = enabled;
    }

    public StaffModifierInstance() {
        this.enabled = false;
    }

    public StaffModifierInstance(Modifier modifier) {
        this(modifier, false, false);
    }

    public boolean isEnabled() {
        return this.enabled && !this.isDisabled();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = super.serializeNBT();
        tag.func_74757_a("e", this.enabled);
        return tag;
    }

    @Override
    public void deserializeNBT(NBTTagCompound tag) {
        super.deserializeNBT(tag);
        this.enabled = tag.func_74767_n("e");
    }

    public static StaffModifierInstance fromNBT(NBTTagCompound tag) {
        StaffModifierInstance result = new StaffModifierInstance();
        result.deserializeNBT(tag);
        return result;
    }

    public static StaffModifierInstance fromLibrary(LibraryModifierInstance instance) {
        return new StaffModifierInstance(instance.getModifier(), instance.isApplied(), false);
    }

    public LibraryModifierInstance toLibrary() {
        return this;
    }

    @Override
    public Object2DoubleOpenHashMap<Herb> apply(Object2DoubleOpenHashMap<Herb> costs) {
        if (!this.enabled || !this.applied) {
            return costs;
        }
        for (CostType type : CostType.values()) {
            costs = this.apply(costs, type);
        }
        return costs;
    }

    public boolean isConflicting(StaffModifierInstanceList modifiers) {
        return !this.getConflicts(modifiers).isEmpty();
    }

    public List<StaffModifierInstance> getConflicts(StaffModifierInstanceList modifiers) {
        Set<IModifier> conflicts = this.getConflicts();
        if (conflicts.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<StaffModifierInstance> conflicting = new ArrayList<StaffModifierInstance>();
        for (StaffModifierInstance modifierInstance : modifiers) {
            if (modifierInstance.isDisabled() || !modifierInstance.isEnabled() || !modifierInstance.isApplied() || !this.conflicts(modifierInstance)) continue;
            conflicting.add(modifierInstance);
        }
        return conflicting;
    }

    @Override
    public Object2DoubleOpenHashMap<Herb> apply(Object2DoubleOpenHashMap<Herb> costs, CostType phase) {
        if (!this.isEnabled() || !this.isApplied()) {
            return costs;
        }
        return this.modifier.apply(costs, phase);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StaffModifierInstance that = (StaffModifierInstance)o;
        return this.applied == that.applied && this.enabled == that.enabled && this.modifier.equals(that.modifier);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.modifier, this.applied, this.enabled);
    }
}

