/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.ritual;

import epicsquid.mysticalworld.init.ModItems;
import epicsquid.roots.entity.ritual.EntityRitualGermination;
import epicsquid.roots.properties.Property;
import epicsquid.roots.ritual.RitualBase;
import epicsquid.roots.ritual.conditions.ConditionStandingStones;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.oredict.OreIngredient;

public class RitualGermination
extends RitualBase {
    public static Property.PropertyDuration PROP_DURATION = new Property.PropertyDuration(6400);
    public static Property<Integer> PROP_RADIUS_X = new Property<Integer>("radius_x", 19).setDescription("Radius on the X Axis of the cube in which the ritual takes place");
    public static Property<Integer> PROP_RADIUS_Y = new Property<Integer>("radius_y", 19).setDescription("Radius on the Y Axis of the cube in which the ritual takes place");
    public static Property<Integer> PROP_RADIUS_Z = new Property<Integer>("radius_z", 19).setDescription("Radius on the Z Axis of the cube in which the ritual takes place");
    public static Property.PropertyInterval PROP_INTERVAL = new Property.PropertyInterval(65).setDescription("interval in ticks between each ritual growth pulse");
    public static Property<Integer> PROP_COUNT = new Property<Integer>("count", 6).setDescription("maximum number of crops boosted every pulse");
    public static Property<Integer> PROP_TICKS = new Property<Integer>("ticks", 5).setDescription("the number of times a single crop is boosted by bonus and crop ticks every ritual interval");
    public static Property<Integer> PROP_BONUS_TICKS = new Property<Integer>("bonus_ticks", 2).setDescription("bonus ticks to be added to the growth boost");
    public static Property<Integer> PROP_BLOCK_CROP_TICKS = new Property<Integer>("block_crop_ticks", 15).setDescription("number of ticks the crop is boosted by each interval");
    public int radius_x;
    public int radius_y;
    public int radius_z;
    public int interval;
    public int count;
    public int ticks;
    public int bonus_ticks;
    public int crop_ticks;

    public RitualGermination(String name, boolean disabled) {
        super(name, disabled);
        this.properties.add(PROP_DURATION, PROP_RADIUS_X, PROP_RADIUS_Y, PROP_RADIUS_Z, PROP_INTERVAL, PROP_COUNT, PROP_TICKS, PROP_BONUS_TICKS, PROP_BLOCK_CROP_TICKS);
        this.setEntityClass(EntityRitualGermination.class);
    }

    @Override
    public void init() {
        this.recipe = new RitualBase.RitualRecipe((RitualBase)this, new ItemStack(epicsquid.roots.init.ModItems.spirit_herb), new ItemStack(epicsquid.roots.init.ModItems.wildroot), new ItemStack(ModItems.aubergine), new OreIngredient("dyeWhite"), new OreIngredient("rootsBark"));
        this.addCondition(new ConditionStandingStones(3, 1));
        this.setIcon(epicsquid.roots.init.ModItems.ritual_germination);
        this.setColor(TextFormatting.DARK_RED);
        this.setBold(true);
    }

    @Override
    public void doFinalise() {
        this.duration = this.properties.get(PROP_DURATION);
        int[] radius = this.properties.getRadius();
        this.radius_x = radius[0];
        this.radius_y = radius[1];
        this.radius_z = radius[2];
        this.interval = this.properties.get(PROP_INTERVAL);
        this.count = this.properties.get(PROP_COUNT);
        this.ticks = this.properties.get(PROP_TICKS);
        this.bonus_ticks = this.properties.get(PROP_BONUS_TICKS);
        this.crop_ticks = this.properties.get(PROP_BLOCK_CROP_TICKS);
    }
}

