/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.roots.config.SpellConfig;
import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.init.ModDamage;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.modifiers.Cost;
import epicsquid.roots.modifiers.CostType;
import epicsquid.roots.modifiers.Modifier;
import epicsquid.roots.modifiers.ModifierCores;
import epicsquid.roots.modifiers.ModifierRegistry;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.network.fx.MessageAcidCloudFX;
import epicsquid.roots.properties.Property;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.util.DamageUtil;
import epicsquid.roots.util.EntityUtil;
import epicsquid.roots.util.types.RandomIterable;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreIngredient;

public class SpellAcidCloud
extends SpellBase {
    public static Property.PropertyCooldown PROP_COOLDOWN = new Property.PropertyCooldown(10);
    public static Property.PropertyCastType PROP_CAST_TYPE = new Property.PropertyCastType(SpellBase.EnumCastType.CONTINUOUS);
    public static Property.PropertyCost PROP_COST_1 = new Property.PropertyCost(new SpellBase.SpellCost("baffle_cap", 0.25));
    public static Property.PropertyDamage PROP_DAMAGE = new Property.PropertyDamage(Float.valueOf(4.0f)).setDescription("damage dealt each time to affected entities");
    public static Property<Integer> PROP_DAMAGE_COUNT = new Property<Integer>("damage_count", 4).setDescription("maximum number of creatures that can be damaged per tick, -1 for infinite");
    public static Property<Integer> PROP_POISON_DURATION = new Property<Integer>("poison_duration", 80).setDescription("duration in ticks of the poison effect applied on the enemies");
    public static Property<Integer> PROP_FIRE_DURATION = new Property<Integer>("fire_duration", 5).setDescription("duration in seconds of the fire effect applied on the enemies");
    public static Property<Integer> PROP_POISON_AMPLIFICATION = new Property<Integer>("poison_amplification", 0).setDescription("the level of the poison effect applied on the enemies (0 is the first level)");
    public static Property<Integer> PROP_RADIUS_GENERAL = new Property<Integer>("radius_general", 4).setDescription("default radius for the acid cloud");
    public static Property<Integer> PROP_RADIUS_BOOST = new Property<Integer>("radius_boost", 2).setDescription("how much radius should be boosted by when Radius Boost modifier applied");
    public static Property<Float> PROP_NIGHT_LOWER = new Property<Float>("night_modifier_low", Float.valueOf(0.05f)).setDescription("the value to multiply damage by at dusk and dawn, rising to night_modifier_high at midnight and then down again");
    public static Property<Float> PROP_NIGHT_HIGHER = new Property<Float>("night_modifier_high", Float.valueOf(0.6f)).setDescription("the value to multiply damage by at midnight, increasing to this from dusk and decreasing from this at dawn");
    public static Property<Float> PROP_UNDEAD_DAMAGE = new Property<Float>("undead_damage", Float.valueOf(2.0f)).setDescription("additional damage done to undead entities with the spirit herb modifier");
    public static Property<Float> PROP_HEALING = new Property<Float>("healing", Float.valueOf(1.0f)).setDescription("how much healing is done by the cloud");
    public static Property<Integer> PROP_REGENERATION = new Property<Integer>("regeneration", 40).setDescription("how long the duration of regen to apply (0 to not apply)");
    public static Property<Integer> PROP_REGEN_AMPLIFIER = new Property<Integer>("regeneration_amplifier", 0).setDescription("what amplifier to use when applying the regen effect");
    public static Property<Integer> PROP_HEALING_COUNT = new Property<Integer>("healing_count", 3).setDescription("maximum number of creatures that can be healed per tick, -1 for infinite");
    public static Property<Integer> PROP_SLOW_DURATION = new Property<Integer>("slow_duration", 40).setDescription("how long to apply slowness for");
    public static Property<Integer> PROP_SLOW_AMPLIFIER = new Property<Integer>("slow_amplifier", 1).setDescription("the amplifier to be applied to the slowing effect");
    public static Property<Float> PROP_UNDERWATER_BOOST = new Property<Float>("underwater_boost", Float.valueOf(1.4f)).setDescription("the multiplier given to damage and healing when underwater");
    public static Property<Integer> PROP_WEAKNESS_DURATION = new Property<Integer>("weakness_duration", 80).setDescription("how long enemies should be weakened in place for");
    public static Property<Integer> PROP_WEAKNESS_AMPLIFIER = new Property<Integer>("weakness_amplifier", 0).setDescription("the amplifier to be applied to the weakness effect");
    public static Modifier RADIUS = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "radius_boost"), ModifierCores.PERESKIA, Cost.of(new Cost(CostType.ADDITIONAL_COST, 0.2, ModifierCores.PERESKIA))));
    public static Modifier PEACEFUL = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "peaceful_cloud"), ModifierCores.WILDEWHEET, Cost.of(Cost.cost(CostType.ADDITIONAL_COST, ModifierCores.WILDEWHEET, 0.125), Cost.cost(CostType.ALL_COST_MULTIPLIER, -0.125))));
    public static Modifier WEAKNESS = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "weakening_cloud"), ModifierCores.WILDROOT, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDROOT, 0.275)));
    public static Modifier NIGHT = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "moonfall"), ModifierCores.MOONGLOW_LEAF, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.MOONGLOW_LEAF, 0.375)));
    public static Modifier UNDEAD = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "unholy_vanquisher"), ModifierCores.SPIRIT_HERB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.SPIRIT_HERB, 0.425)));
    public static Modifier HEALING = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "healing_cloud"), ModifierCores.TERRA_MOSS, Cost.of(new Cost(CostType.ADDITIONAL_COST, 0.275, ModifierCores.TERRA_MOSS), new Cost(CostType.ALL_COST_MULTIPLIER, -0.125))));
    public static Modifier SPEED = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "increased_speed"), ModifierCores.CLOUD_BERRY, Cost.of(new Cost(CostType.ADDITIONAL_COST, 0.225, ModifierCores.CLOUD_BERRY))));
    public static Modifier FIRE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "fire_cloud"), ModifierCores.INFERNAL_BULB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.INFERNAL_BULB, 0.275)));
    public static Modifier SLOWING = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "slowing"), ModifierCores.STALICRIPE, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.STALICRIPE, 0.275)));
    public static Modifier UNDERWATER = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "underwater_increase"), ModifierCores.DEWGONIA, Cost.of(new Cost(CostType.ADDITIONAL_COST, 0.175, ModifierCores.DEWGONIA))));
    public static ResourceLocation spellName;
    public static SpellAcidCloud instance;
    private float damage;
    private float night_low;
    private float night_high;
    private float undead_damage;
    private float healing;
    private float underwater_boost;
    private int poisonDuration;
    private int poisonAmplification;
    private int fireDuration;
    private int regen_duration;
    private int regen_amp;
    private int damage_count;
    private int heal_count;
    private int weakness_amplifier;
    private int weakness_duration;
    private int slow_duration;
    private int slow_amplifier;
    public int radius;
    public int radius_boost;
    public static AxisAlignedBB boxGeneral;
    public static AxisAlignedBB boxBoost;

    public SpellAcidCloud(ResourceLocation name) {
        super(name, TextFormatting.DARK_GREEN, 0.3137255f, 0.627451f, 0.15686275f, 0.2509804f, 0.3764706f, 0.1254902f);
        this.properties.add(PROP_COOLDOWN, PROP_CAST_TYPE, PROP_COST_1, PROP_DAMAGE, PROP_DAMAGE_COUNT, PROP_POISON_DURATION, PROP_FIRE_DURATION, PROP_POISON_AMPLIFICATION, PROP_RADIUS_BOOST, PROP_RADIUS_GENERAL, PROP_NIGHT_LOWER, PROP_NIGHT_HIGHER, PROP_UNDEAD_DAMAGE, PROP_HEALING, PROP_REGEN_AMPLIFIER, PROP_REGENERATION, PROP_UNDERWATER_BOOST, PROP_HEALING_COUNT, PROP_SLOW_DURATION, PROP_SLOW_AMPLIFIER, PROP_UNDERWATER_BOOST, PROP_WEAKNESS_AMPLIFIER, PROP_WEAKNESS_DURATION);
        this.acceptModifiers(RADIUS, PEACEFUL, WEAKNESS, NIGHT, UNDEAD, HEALING, SPEED, FIRE, SLOWING, UNDERWATER);
    }

    @Override
    public void init() {
        this.addIngredients(new OreIngredient("eye"), new ItemStack(Item.func_150898_a((Block)ModBlocks.baffle_cap_mushroom)), new OreIngredient("dyeLime"), new ItemStack(ModItems.runic_dust), new ItemStack(Items.field_151078_bh));
    }

    private double getMultiplier(double t, float min, float max) {
        int peak = 18000;
        int[] bounds = new int[]{12500, 23500};
        int threshold = peak / 3;
        if (t > (double)bounds[0] && t < (double)bounds[1]) {
            return (double)max + Math.abs((t - (double)peak) / (double)threshold) * (double)(min - max);
        }
        return 0.0;
    }

    @Override
    public boolean cast(EntityPlayer player, StaffModifierInstanceList info, int ticks) {
        if (!player.field_70170_p.field_72995_K) {
            List entities = player.field_70170_p.func_72872_a(EntityLivingBase.class, info.has(RADIUS) ? boxBoost.func_186670_a(player.func_180425_c()) : boxGeneral.func_186670_a(player.func_180425_c()));
            int healed = 0;
            int damaged = 0;
            if (info.has(SPEED)) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 1, 18, false, false));
                player.func_70690_d(new PotionEffect(MobEffects.field_76430_j, 1, 0, false, false));
            }
            float modifier = 1.0f;
            if (info.has(NIGHT)) {
                double mult = this.getMultiplier(player.field_70170_p.func_72820_D(), this.night_low, this.night_high);
                modifier = (float)((double)modifier + mult);
            }
            if (info.has(UNDERWATER)) {
                modifier += this.underwater_boost;
            }
            for (EntityLivingBase e : new RandomIterable(entities)) {
                if (info.has(HEALING)) {
                    if (EntityUtil.isHostile((Entity)e, instance) || EntityUtil.isHostileTo((Entity)e, player, instance)) continue;
                    if (this.regen_duration != -1) {
                        e.func_70690_d(new PotionEffect(MobEffects.field_76428_l, this.regen_duration, this.regen_amp));
                    }
                    if (this.healing > 0.0f) {
                        e.func_70691_i(this.healing * modifier);
                    }
                    if (this.heal_count == -1 || ++healed < this.heal_count) continue;
                    break;
                }
                if (e == player || e instanceof EntityPlayer && !FMLCommonHandler.instance().getMinecraftServerInstance().func_71219_W() || e.field_70737_aN > 0 || e.field_70128_L || info.has(PEACEFUL) && EntityUtil.isFriendly((Entity)e, instance)) continue;
                if (info.has(WEAKNESS)) {
                    e.func_70690_d(new PotionEffect(MobEffects.field_76437_t, this.weakness_duration, this.weakness_amplifier));
                }
                if (info.has(FIRE)) {
                    DamageUtil.unhurt(e);
                    e.func_70097_a(ModDamage.fireDamageFrom((Entity)player), this.damage * modifier / 2.0f);
                    DamageUtil.unhurt(e);
                    e.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)player), this.damage * modifier / 2.0f);
                    e.func_70015_d(this.fireDuration);
                } else {
                    DamageUtil.unhurt(e);
                    e.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)player), this.damage * modifier);
                }
                if (info.has(UNDEAD) && e.func_70662_br()) {
                    DamageUtil.unhurt(e);
                    e.func_70097_a(ModDamage.radiantDamageFrom((Entity)player), this.undead_damage * modifier);
                }
                if (info.has(SLOWING)) {
                    e.func_70690_d(new PotionEffect(MobEffects.field_76421_d, this.slow_duration, this.slow_amplifier));
                }
                if (SpellConfig.spellFeaturesCategory.acidCloudPoisoningEffect) {
                    e.func_70690_d(new PotionEffect(MobEffects.field_76436_u, this.poisonDuration, this.poisonAmplification));
                }
                e.func_70604_c((EntityLivingBase)player);
                e.func_130011_c((Entity)player);
                if (this.damage_count == -1 || ++damaged < this.damage_count) continue;
                break;
            }
            PacketHandler.sendToAllTracking((IMessage)new MessageAcidCloudFX(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v, info), (Entity)player);
        }
        return true;
    }

    @Override
    public void doFinalise() {
        this.castType = this.properties.get(PROP_CAST_TYPE);
        this.cooldown = this.properties.get(PROP_COOLDOWN);
        this.damage = this.properties.get(PROP_DAMAGE).floatValue();
        this.poisonAmplification = this.properties.get(PROP_POISON_AMPLIFICATION);
        this.poisonDuration = this.properties.get(PROP_POISON_DURATION);
        this.fireDuration = this.properties.get(PROP_FIRE_DURATION);
        this.radius = this.properties.get(PROP_RADIUS_GENERAL);
        this.radius_boost = this.properties.get(PROP_RADIUS_BOOST);
        boxGeneral = new AxisAlignedBB((double)(-this.radius), (double)(-this.radius), (double)(-this.radius), (double)(this.radius + 1), (double)(this.radius + 1), (double)(this.radius + 1));
        boxBoost = boxGeneral.func_186662_g((double)this.radius_boost);
        this.night_low = this.properties.get(PROP_NIGHT_LOWER).floatValue();
        this.night_high = this.properties.get(PROP_NIGHT_HIGHER).floatValue();
        this.undead_damage = this.properties.get(PROP_UNDEAD_DAMAGE).floatValue();
        this.healing = this.properties.get(PROP_HEALING).floatValue();
        this.regen_amp = this.properties.get(PROP_REGEN_AMPLIFIER);
        this.regen_duration = this.properties.get(PROP_REGENERATION);
        this.damage_count = this.properties.get(PROP_DAMAGE_COUNT);
        this.heal_count = this.properties.get(PROP_HEALING_COUNT);
        this.underwater_boost = this.properties.get(PROP_UNDERWATER_BOOST).floatValue();
        this.weakness_duration = this.properties.get(PROP_WEAKNESS_DURATION);
        this.weakness_amplifier = this.properties.get(PROP_WEAKNESS_AMPLIFIER);
        this.slow_duration = this.properties.get(PROP_SLOW_DURATION);
        this.slow_amplifier = this.properties.get(PROP_SLOW_AMPLIFIER);
    }

    static {
        HEALING.addConflicts(WEAKNESS, UNDEAD, FIRE);
        spellName = new ResourceLocation("roots", "spell_acid_cloud");
        instance = new SpellAcidCloud(spellName);
    }
}

