/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.util;

import epicsquid.roots.config.GeneralConfig;
import epicsquid.roots.ritual.RitualBase;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.util.EntityLists;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.util.ResourceLocation;

public class EntityUtil {
    public static boolean isFamiliar(Entity entity) {
        if (entity instanceof EntityPlayer) {
            return false;
        }
        if (!EntityUtil.isFriendly(entity)) {
            return false;
        }
        if (entity instanceof AbstractHorse) {
            AbstractHorse owned = (AbstractHorse)entity;
            return owned.func_184780_dh() != null;
        }
        if (entity instanceof IEntityOwnable) {
            IEntityOwnable owned = (IEntityOwnable)entity;
            return owned.func_184753_b() != null;
        }
        return false;
    }

    public static boolean isFamiliar(EntityPlayer player, Entity entity) {
        if (entity instanceof EntityPlayer) {
            return false;
        }
        if (!EntityUtil.isFriendly(entity)) {
            return false;
        }
        if (entity instanceof AbstractHorse) {
            AbstractHorse owned = (AbstractHorse)entity;
            return owned.func_184780_dh() != null && owned.func_184780_dh().equals(player.func_110124_au());
        }
        if (entity instanceof IEntityOwnable) {
            IEntityOwnable owned = (IEntityOwnable)entity;
            return owned.func_184753_b() != null && owned.func_184753_b().equals(player.func_110124_au());
        }
        return false;
    }

    public static boolean isHostile(Entity entity, SpellBase spell) {
        return EntityUtil.isHostile(entity, spell, null);
    }

    public static boolean isHostile(Entity entity, RitualBase ritual) {
        return EntityUtil.isHostile(entity, null, ritual);
    }

    public static boolean isHostile(Entity entity) {
        return EntityUtil.isHostile(entity, null, null);
    }

    public static boolean isHostile(Entity entity, @Nullable SpellBase spell, @Nullable RitualBase ritual) {
        if (entity instanceof EntityPlayer) {
            return false;
        }
        ResourceLocation rl = EntityList.func_191301_a((Entity)entity);
        if (spell != null) {
            if (EntityLists.getSpell(spell, EntityLists.Type.BLOCK).contains(rl)) {
                return true;
            }
            if (EntityLists.getSpell(spell, EntityLists.Type.ALLOW).contains(rl)) {
                return false;
            }
        }
        if (ritual != null) {
            if (EntityLists.getRitual(ritual, EntityLists.Type.BLOCK).contains(rl)) {
                return true;
            }
            if (EntityLists.getRitual(ritual, EntityLists.Type.ALLOW).contains(rl)) {
                return false;
            }
        }
        if (EntityLists.getGeneral(EntityLists.Type.BLOCK).contains(rl)) {
            return true;
        }
        if (EntityLists.getGeneral(EntityLists.Type.ALLOW).contains(rl)) {
            return false;
        }
        if (entity instanceof IMob) {
            return true;
        }
        if (entity.isCreatureType(EnumCreatureType.MONSTER, false)) {
            return true;
        }
        return entity instanceof IProjectile || entity instanceof EntityWitherSkull;
    }

    public static boolean isFriendly(Entity entity, SpellBase spell) {
        return EntityUtil.isFriendly(entity, spell, null);
    }

    public static boolean isFriendly(Entity entity, RitualBase ritual) {
        return EntityUtil.isFriendly(entity, null, ritual);
    }

    public static boolean isFriendly(Entity entity) {
        return EntityUtil.isFriendly(entity, null, null);
    }

    public static boolean isFriendly(Entity entity, @Nullable SpellBase spell, @Nullable RitualBase ritual) {
        if (entity instanceof EntityPlayer) {
            return false;
        }
        ResourceLocation rl = EntityList.func_191301_a((Entity)entity);
        if (spell != null) {
            if (EntityLists.getSpell(spell, EntityLists.Type.BLOCK).contains(rl)) {
                return false;
            }
            if (EntityLists.getSpell(spell, EntityLists.Type.ALLOW).contains(rl)) {
                return true;
            }
        }
        if (ritual != null) {
            if (EntityLists.getRitual(ritual, EntityLists.Type.BLOCK).contains(rl)) {
                return false;
            }
            if (EntityLists.getRitual(ritual, EntityLists.Type.ALLOW).contains(rl)) {
                return true;
            }
        }
        if (EntityLists.getGeneral(EntityLists.Type.BLOCK).contains(rl)) {
            return false;
        }
        if (EntityLists.getGeneral(EntityLists.Type.ALLOW).contains(rl)) {
            return true;
        }
        if (entity instanceof EntityAnimal) {
            return true;
        }
        if (entity.isCreatureType(EnumCreatureType.AMBIENT, false) || entity.isCreatureType(EnumCreatureType.WATER_CREATURE, false) || entity.isCreatureType(EnumCreatureType.CREATURE, false)) {
            return true;
        }
        return !EntityUtil.isHostile(entity);
    }

    public static boolean isHostileTo(Entity entity, EntityPlayer player, SpellBase spell) {
        return EntityUtil.isHostileTo(entity, player, spell, null);
    }

    public static boolean isHostileTo(Entity entity, EntityPlayer player, RitualBase ritual) {
        return EntityUtil.isHostileTo(entity, player, null, ritual);
    }

    public static boolean isHostileTo(Entity entity, EntityPlayer player) {
        return EntityUtil.isHostileTo(entity, player, null, null);
    }

    public static boolean isHostileTo(Entity entity, EntityPlayer player, @Nullable SpellBase spell, @Nullable RitualBase ritual) {
        if (EntityUtil.isHostile(entity, spell, ritual)) {
            return true;
        }
        if (entity instanceof EntityLiving) {
            EntityLiving living = (EntityLiving)entity;
            return living.func_70638_az() == player;
        }
        return false;
    }

    public static boolean isAquatic(Entity entity) {
        if (entity instanceof EntityWaterMob) {
            return true;
        }
        return EntitySpawnPlacementRegistry.func_180109_a(entity.getClass()) == EntityLiving.SpawnPlacementType.IN_WATER;
    }

    public static boolean isFriendlyTo(Entity entity, EntityPlayer player, SpellBase spell) {
        return EntityUtil.isFriendlyTo(entity, player, spell, null);
    }

    public static boolean isFriendlyTo(Entity entity, EntityPlayer player, RitualBase ritual) {
        return EntityUtil.isFriendlyTo(entity, player, null, ritual);
    }

    public static boolean isFriendlyTo(Entity entity, EntityPlayer player) {
        return EntityUtil.isFriendlyTo(entity, player, null, null);
    }

    public static boolean isFriendlyTo(Entity entity, EntityPlayer player, @Nullable SpellBase spell, @Nullable RitualBase ritual) {
        if (!EntityUtil.isFriendly(entity, spell, ritual)) {
            return false;
        }
        if (entity instanceof EntityLiving) {
            return ((EntityLiving)entity).func_70638_az() != player;
        }
        return true;
    }

    public static boolean canSummonPassive(EntityLivingBase entity) {
        if (!EntityUtil.isFriendly((Entity)entity)) {
            return false;
        }
        if (entity.func_145818_k_()) {
            return false;
        }
        if (entity instanceof EntityLiving) {
            EntityLiving living = (EntityLiving)entity;
            return !living.func_110167_bD();
        }
        return true;
    }

    public static boolean canSummonHostile(EntityLivingBase entity) {
        if (!EntityUtil.isHostile((Entity)entity)) {
            return false;
        }
        if (entity.func_145818_k_()) {
            return false;
        }
        return !EntityUtil.isBoss(entity);
    }

    public static boolean isBoss(EntityLivingBase entity) {
        if (!entity.func_184222_aU()) {
            return true;
        }
        return entity.func_110138_aP() > GeneralConfig.BossEntityHealth;
    }
}

