/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.solarflux.compat.thaumcraft;

import com.google.common.base.Joiner;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.internal.CommonInternals;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.research.IScanThing;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategory;
import thaumcraft.api.research.ResearchEntry;
import thaumcraft.api.research.ResearchStage;
import thaumcraft.api.research.ScanBlock;
import thaumcraft.api.research.ScanningManager;
import thaumcraft.api.research.theorycraft.ITheorycraftAid;
import thaumcraft.api.research.theorycraft.TheorycraftManager;
import thaumcraft.common.lib.CommandThaumcraft;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;
import thaumcraft.common.lib.research.ResearchManager;
import tk.zeitheron.solarflux.SolarFlux;
import tk.zeitheron.solarflux.api.SolarFluxAPI;
import tk.zeitheron.solarflux.api.SolarInfo;
import tk.zeitheron.solarflux.api.compat.ISolarFluxCompat;
import tk.zeitheron.solarflux.api.compat.SFCompat;
import tk.zeitheron.solarflux.block.BlockBaseSolar;
import tk.zeitheron.solarflux.compat.thaumcraft.research.ResearchAddendumBuilder;
import tk.zeitheron.solarflux.compat.thaumcraft.research.ResearchEntryBuilder;
import tk.zeitheron.solarflux.compat.thaumcraft.research.ResearchStageBuilder;
import tk.zeitheron.solarflux.compat.thaumcraft.theorycraft.AidSolarPanel;
import tk.zeitheron.solarflux.compat.thaumcraft.theorycraft.CardPhotovoltaicCell;
import tk.zeitheron.solarflux.compat.thaumcraft.theorycraft.CardSolarPanel;
import tk.zeitheron.solarflux.init.ItemsSF;
import tk.zeitheron.solarflux.init.SolarsSF;

@SFCompat(modid="thaumcraft")
public class CompatThaumcraft
implements ISolarFluxCompat {
    public static ResearchCategory RES_CAT;
    public static final Aspect SOL;
    public static SolarInfo alchemicalSolar;
    public static SolarInfo brassSolar;
    public static SolarInfo thaumiumSolar;
    public static SolarInfo voidSolar;
    List<Block> solarPanels;
    Block[] solarPanelsA;
    private static Method addResearchToCategory;
    static ResourceLocation defaultGroup;

    @Override
    public void registerSolarInfos(List<SolarInfo> panels) {
        alchemicalSolar = new SolarInfo(8L, 64L, 125000L).setRegistryName("solarflux", "alchemical");
        panels.add(alchemicalSolar);
        brassSolar = new SolarInfo(32L, 256L, 425000L).setRegistryName("solarflux", "alchemical_brass");
        panels.add(brassSolar);
        thaumiumSolar = new SolarInfo(128L, 1024L, 2000000L).setRegistryName("solarflux", "thaumium");
        panels.add(thaumiumSolar);
        voidSolar = new SolarInfo(512L, 4096L, 8000000L).setRegistryName("solarflux", "void_metal");
        panels.add(voidSolar);
    }

    @Override
    public void init() {
        RES_CAT = ResearchCategories.registerCategory((String)"SOLARFLUX", (String)"UNLOCKALCHEMY", (AspectList)new AspectList().add(Aspect.ALCHEMY, 10).add(Aspect.LIGHT, 2).add(Aspect.MAGIC, 10).add(Aspect.LIFE, 5).add(Aspect.AVERSION, 5).add(Aspect.DESIRE, 5).add(Aspect.WATER, 5), (ResourceLocation)new ResourceLocation("solarflux", "textures/items/photovoltaic_cell_6.png"), (ResourceLocation)new ResourceLocation("solarflux", "textures/gui/thaumonomicon_back.jpg"), (ResourceLocation)new ResourceLocation("solarflux", "textures/gui/gui_research_back_over.png"));
        this.registerScan();
        this.registerTheorycraft();
        this.registerTCRecipes();
    }

    @Override
    public void postInit() {
        this.reloadResearch();
        this.insertAspect();
    }

    public void registerTCRecipes() {
        CompatThaumcraft.addCrucibleRecipe("alchemical_solar_panel", "SFR_SOLARFLUX", new ItemStack((Block)alchemicalSolar.getBlock()), new ItemStack((Block)SolarsSF.CORE_PANELS[0].getBlock()), new AspectList().add(SOL, 20).add(Aspect.MECHANISM, 10));
        CompatThaumcraft.addShapedArcaneRecipe("brass_solar_panel", "SFR_BRASS_SOLAR_PANEL", 20, new AspectList(), new ItemStack((Block)brassSolar.getBlock()), "ppp", "bsb", "bbb", Character.valueOf('p'), new ItemStack(ItemsSF.PHOTOVOLTAIC_CELL_1), Character.valueOf('b'), "plateBrass", Character.valueOf('s'), new ItemStack((Block)alchemicalSolar.getBlock()));
        CompatThaumcraft.addInfusionRecipe("thaumium_solar_panel", new ItemStack((Block)thaumiumSolar.getBlock()), "SFR_THAUMIUM_SOLAR_PANEL", 3, new ItemStack((Block)brassSolar.getBlock()), new AspectList().add(SOL, 40).add(Aspect.ENERGY, 20), new ItemStack(ItemsTC.plate, 1, 2), new ItemStack(ItemsSF.PHOTOVOLTAIC_CELL_2), new ItemStack(ItemsTC.plate, 1, 2), new ItemStack(ItemsSF.PHOTOVOLTAIC_CELL_2), new ItemStack(ItemsTC.plate, 1, 2), new ItemStack(ItemsSF.PHOTOVOLTAIC_CELL_2), new ItemStack(ItemsTC.plate, 1, 2), new ItemStack(ItemsTC.mechanismSimple));
        CompatThaumcraft.addInfusionRecipe("void_metal_solar_panel", new ItemStack((Block)voidSolar.getBlock()), "SFR_VOID_SOLAR_PANEL", 4, new ItemStack((Block)thaumiumSolar.getBlock()), new AspectList().add(SOL, 60).add(Aspect.ENERGY, 40).add(Aspect.VOID, 20), new ItemStack(ItemsTC.plate, 1, 3), new ItemStack(ItemsSF.PHOTOVOLTAIC_CELL_3), new ItemStack(ItemsTC.plate, 1, 3), new ItemStack(ItemsSF.PHOTOVOLTAIC_CELL_3), new ItemStack(ItemsTC.plate, 1, 3), new ItemStack(ItemsSF.PHOTOVOLTAIC_CELL_3), new ItemStack(ItemsTC.plate, 1, 3), new ItemStack(ItemsTC.mechanismComplex));
    }

    public void registerScan() {
        this.solarPanels = ForgeRegistries.BLOCKS.getValuesCollection().stream().filter(b -> b instanceof BlockBaseSolar).collect(Collectors.toList());
        this.solarPanelsA = this.solarPanels.toArray(new Block[this.solarPanels.size()]);
        ScanningManager.addScannableThing((IScanThing)new ScanBlock("!SOLARPANELS", this.solarPanelsA));
    }

    public void registerTheorycraft() {
        for (Block sp : this.solarPanelsA) {
            TheorycraftManager.registerAid((ITheorycraftAid)new AidSolarPanel(sp));
        }
        TheorycraftManager.registerCard(CardSolarPanel.class);
        TheorycraftManager.registerCard(CardPhotovoltaicCell.class);
    }

    public void reloadResearch() {
        SolarFlux.LOG.info("Registering TC researches...");
        new REB().setBaseInfo("SFR_SOLARFLUX", "solarflux", 0, 0, new ResourceLocation("solarflux", "textures/items/photovoltaic_cell_6.png")).setMeta(ResearchEntry.EnumResearchMeta.HIDDEN, ResearchEntry.EnumResearchMeta.SPIKY).setStages(new RSB().setText("research_stage.solarflux:solarflux.1").setKnow(new ResearchStage.Knowledge(IPlayerKnowledge.EnumKnowledgeType.OBSERVATION, RES_CAT, 1)).build(), new RSB().setText("research_stage.solarflux:solarflux.2").setRecipes("solarflux:alchemical_solar_panel").build()).setParents("FIRSTSTEPS", "!SOLARPANELS").buildAndRegister();
        new REB().setBaseInfo("SFR_BRASS_SOLAR_PANEL", "brass_solar_panel", 0, 2, new ItemStack((Block)brassSolar.getBlock())).setMeta(ResearchEntry.EnumResearchMeta.HIDDEN).setStages(new RSB().setText("research_stage.solarflux:brass_solar_panel.1").setConsumedItems(new ItemStack(ItemsSF.PHOTOVOLTAIC_CELL_1)).setRequiredCraft(new ItemStack((Block)SolarsSF.CORE_PANELS[1].getBlock())).setKnow(new ResearchStage.Knowledge(IPlayerKnowledge.EnumKnowledgeType.THEORY, RES_CAT, 1)).build(), new RSB().setText("research_stage.solarflux:brass_solar_panel.2").setRecipes("solarflux:brass_solar_panel").build()).setParents("SFR_SOLARFLUX", "METALLURGY@1").buildAndRegister();
        new REB().setBaseInfo("SFR_THAUMIUM_SOLAR_PANEL", "thaumium_solar_panel", 0, 4, new ItemStack((Block)thaumiumSolar.getBlock())).setMeta(ResearchEntry.EnumResearchMeta.HIDDEN).setStages(new RSB().setText("research_stage.solarflux:thaumium_solar_panel.1").setConsumedItems(new ItemStack(ItemsSF.PHOTOVOLTAIC_CELL_2)).setRequiredCraft(new ItemStack((Block)brassSolar.getBlock())).setKnow(new ResearchStage.Knowledge(IPlayerKnowledge.EnumKnowledgeType.THEORY, RES_CAT, 1)).build(), new RSB().setText("research_stage.solarflux:thaumium_solar_panel.2").setRecipes("solarflux:thaumium_solar_panel").build()).setParents("SFR_BRASS_SOLAR_PANEL", "BASEARTIFICE", "METALLURGY@2").buildAndRegister();
        new REB().setBaseInfo("SFR_VOID_SOLAR_PANEL", "void_metal_solar_panel", 0, 6, new ItemStack((Block)voidSolar.getBlock())).setMeta(ResearchEntry.EnumResearchMeta.HIDDEN).setStages(new RSB().setText("research_stage.solarflux:void_metal_solar_panel.1").setConsumedItems(new ItemStack(ItemsSF.PHOTOVOLTAIC_CELL_3)).setRequiredCraft(new ItemStack((Block)thaumiumSolar.getBlock())).setKnow(new ResearchStage.Knowledge(IPlayerKnowledge.EnumKnowledgeType.THEORY, RES_CAT, 1)).build(), new RSB().setText("research_stage.solarflux:void_metal_solar_panel.2").setRecipes("solarflux:void_metal_solar_panel").build()).setParents("SFR_THAUMIUM_SOLAR_PANEL", "BASEARTIFICE", "BASEELDRITCH").buildAndRegister();
    }

    public void insertAspect() {
        for (Block nitor : BlocksTC.nitor.values()) {
            CompatThaumcraft.appendAspects(new ItemStack(nitor), new AspectList().add(SOL, 15));
        }
        CompatThaumcraft.appendAspects(new ItemStack(Blocks.field_150478_aa), new AspectList().add(SOL, 1));
        CompatThaumcraft.appendAspects(new ItemStack(Items.field_151114_aO), new AspectList().add(SOL, 10));
        CompatThaumcraft.appendAspects(new ItemStack(ItemsSF.MIRROR), new AspectList().add(SOL, 15));
        SolarFluxAPI.SOLAR_PANELS.forEach(si -> CompatThaumcraft.appendAspects(new ItemStack((Block)si.getBlock()), new AspectList().add(SOL, 5 + (int)Math.ceil(si.getGeneration()))));
    }

    private static void appendAspects(String oreDict, AspectList toAdd) {
        List ores = ThaumcraftApiHelper.getOresWithWildCards((String)oreDict);
        if (toAdd == null) {
            toAdd = new AspectList();
        }
        if (ores != null && ores.size() > 0) {
            for (ItemStack ore : ores) {
                try {
                    ItemStack oc = ore.func_77946_l();
                    oc.func_190920_e(1);
                    CompatThaumcraft.appendAspects(oc, toAdd);
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void appendAspects(ItemStack stack, AspectList toAdd) {
        toAdd = toAdd.copy();
        AspectList al = ThaumcraftCraftingManager.getObjectTags((ItemStack)stack);
        if (al != null) {
            toAdd = toAdd.add(al);
        }
        CommonInternals.objectTags.put(CommonInternals.generateUniqueItemstackId((ItemStack)stack), toAdd);
    }

    private static void removeAspects(ItemStack stack, Aspect ... aspects) {
        AspectList al = ThaumcraftCraftingManager.getObjectTags((ItemStack)stack);
        if (al != null) {
            for (Aspect a : aspects) {
                al.remove(a);
            }
            CommonInternals.objectTags.put(CommonInternals.generateUniqueItemstackId((ItemStack)stack), al);
        }
    }

    private static String addIfPresent(String item, AspectList al, String prefix) {
        Item it = (Item)GameRegistry.findRegistry(Item.class).getValue(new ResourceLocation(item));
        if (it != null) {
            List fullAspectList = Arrays.stream(al.getAspectsSortedByAmount()).map(a -> al.getAmount(a) + "x " + a.getName()).collect(Collectors.toList());
            SolarFlux.LOG.info("I " + prefix + "found " + item + " and I added some aspects to it! " + Joiner.on((String)", ").join(fullAspectList));
            if (prefix.isEmpty()) {
                prefix = "also ";
            }
            CompatThaumcraft.appendAspects(new ItemStack(it), al);
        }
        return prefix;
    }

    public static void addResearchToCategory(ResearchEntry ri) {
        if (addResearchToCategory == null) {
            try {
                addResearchToCategory = ResearchManager.class.getDeclaredMethod("addResearchToCategory", ResearchEntry.class);
                addResearchToCategory.setAccessible(true);
            }
            catch (NoSuchMethodException | SecurityException e) {
                SolarFlux.LOG.error((Object)e);
            }
        }
        try {
            addResearchToCategory.invoke(null, ri);
        }
        catch (Throwable e) {
            SolarFlux.LOG.error((Object)e);
        }
    }

    private static void addCrucibleRecipe(String path, String research, ItemStack output, Object catalyst, AspectList aspects) {
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("solarflux", path), (CrucibleRecipe)new CrucibleRecipe(research, output, catalyst, aspects));
    }

    private static void addInfusionRecipe(String path, Object output, String research, int instability, Object catalyst, AspectList aspects, Object ... inputs) {
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("solarflux", path), (InfusionRecipe)new InfusionRecipe(research, output, instability, aspects, catalyst, inputs));
    }

    private static void addShapedArcaneRecipe(String path, String res, int vis, AspectList crystals, ItemStack result, Object ... recipe) {
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("solarflux", path), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, res, vis, crystals, result, recipe));
    }

    private static void addShapedArcaneRecipe(String path, String res, int vis, AspectList crystals, Item result, Object ... recipe) {
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("solarflux", path), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, res, vis, crystals, result, recipe));
    }

    private static void addShapedArcaneRecipe(String path, String res, int vis, AspectList crystals, Block result, Object ... recipe) {
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("solarflux", path), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, res, vis, crystals, result, recipe));
    }

    @SubscribeEvent
    public void commandEvent(CommandEvent ce) {
        if (ce.getCommand() instanceof CommandThaumcraft && ce.getParameters().length > 0 && ce.getParameters()[0].equalsIgnoreCase("reload")) {
            new Thread(() -> {
                while (CompatThaumcraft.RES_CAT.research.containsKey("SFR_SOLARFLUX")) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                this.reloadResearch();
            }).start();
        }
    }

    static {
        SOL = Aspect.getAspect((String)"sol") != null ? Aspect.getAspect((String)"sol") : new Aspect("sol", 16758272, new Aspect[]{Aspect.LIGHT, Aspect.LIFE}, new ResourceLocation("solarflux", "textures/gui/aspect_sol.png"), 1);
        addResearchToCategory = null;
        defaultGroup = new ResourceLocation("solarflux");
    }

    private static class REB
    extends ResearchEntryBuilder {
        private REB() {
        }

        public ResearchEntryBuilder setBaseInfo(String key, String name, int x, int y, Object ... icons) {
            return super.setBaseInfo(key, "SOLARFLUX", "research_name.solarflux:" + name, x, y, icons);
        }
    }

    private static class RSB
    extends ResearchStageBuilder {
        private RSB() {
        }
    }

    private static class RAB
    extends ResearchAddendumBuilder {
        private RAB() {
        }
    }
}

