/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.casters.foci;

import java.awt.Color;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.FocusEffect;
import thaumcraft.api.casters.FocusEngine;
import thaumcraft.api.casters.Trajectory;
import thaumcraft.common.items.casters.foci.FocusMediumTouch;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXZap;
import thaumcraft.common.lib.utils.EntityUtils;

public class FocusMediumBolt
extends FocusMediumTouch {
    @Override
    public String getResearch() {
        return "FOCUSBOLT";
    }

    @Override
    public String getKey() {
        return "thaumcraft.BOLT";
    }

    @Override
    public int getComplexity() {
        return 5;
    }

    @Override
    public Aspect getAspect() {
        return Aspect.ENERGY;
    }

    @Override
    public boolean execute(Trajectory trajectory) {
        float range = 16.0f;
        Vec3d end = trajectory.direction.func_72432_b();
        RayTraceResult ray = EntityUtils.getPointedEntityRay(this.getPackage().world, (Entity)this.getPackage().getCaster(), trajectory.source, end, 0.25, range, 0.25f, false);
        if (ray == null) {
            end = end.func_186678_a((double)range);
            ray = this.getPackage().world.func_72933_a(trajectory.source, end = end.func_178787_e(trajectory.source));
            if (ray != null) {
                end = ray.field_72307_f;
            }
        } else if (ray.field_72308_g != null) {
            end = end.func_186678_a(trajectory.source.func_72438_d(ray.field_72308_g.func_174791_d()));
            end = end.func_178787_e(trajectory.source);
        }
        int r = 0;
        int g = 0;
        int b = 0;
        for (FocusEffect ef : this.getPackage().getFocusEffects()) {
            Color c = new Color(FocusEngine.getElementColor(ef.getKey()));
            r += c.getRed();
            g += c.getGreen();
            b += c.getBlue();
        }
        Color c = new Color(r /= this.getPackage().getFocusEffects().length, g /= this.getPackage().getFocusEffects().length, b /= this.getPackage().getFocusEffects().length);
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXZap(trajectory.source, end, c.getRGB(), this.getPackage().getPower() * 0.66f), new NetworkRegistry.TargetPoint(this.getPackage().world.field_73011_w.getDimension(), trajectory.source.field_72450_a, trajectory.source.field_72448_b, trajectory.source.field_72449_c, 64.0));
        return true;
    }
}

