/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.entity;

import com.google.common.base.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.common.entities.projectile.EntityFocusCloud;
import thaumcraft.common.lib.SoundsTC;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.entity.CapabilityPortalState;
import thecodex6824.thaumicaugmentation.api.entity.IDimensionalFracture;
import thecodex6824.thaumicaugmentation.api.entity.IPortalEntity;
import thecodex6824.thaumicaugmentation.api.entity.IPortalState;
import thecodex6824.thaumicaugmentation.api.entity.PortalStateManager;
import thecodex6824.thaumicaugmentation.common.entity.EntityTAEldritchGuardian;
import thecodex6824.thaumicaugmentation.common.network.PacketParticleEffect;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;
import thecodex6824.thaumicaugmentation.common.world.DimensionalFractureTeleporter;
import thecodex6824.thaumicaugmentation.common.world.feature.FractureUtils;

public class EntityDimensionalFracture
extends Entity
implements IDimensionalFracture,
IPortalEntity {
    protected static final int OPEN_TIME = 360;
    protected static final String NULL_BIOME = "thaumicaugmentation:null";
    protected static final DataParameter<Boolean> OPEN = EntityDataManager.func_187226_a(EntityDimensionalFracture.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Optional<UUID>> TIME_OPENED = EntityDataManager.func_187226_a(EntityDimensionalFracture.class, (DataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<String> LINKED_BIOME = EntityDataManager.func_187226_a(EntityDimensionalFracture.class, (DataSerializer)DataSerializers.field_187194_d);
    protected int linkedDim;
    protected BlockPos linkedTo;
    protected boolean linkLocated;
    protected boolean linkInvalid;
    protected Biome linkedBiome;

    public EntityDimensionalFracture(World world) {
        super(world);
        this.func_70105_a(1.0f, 3.0f);
    }

    protected void verifyChunk(World worldToVerify, BlockPos pos) {
        IChunkProvider provider = worldToVerify.func_72863_F();
        if (provider.func_186026_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4) == null) {
            worldToVerify.func_175726_f(pos.func_177982_a(16, 0, 0));
            worldToVerify.func_175726_f(pos.func_177982_a(0, 0, 16));
            worldToVerify.func_175726_f(pos.func_177982_a(16, 0, 16));
            worldToVerify.func_175726_f(pos);
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    protected void onCollide(Entity entity) {
        IPortalState state;
        if (!(this.field_70170_p.field_72995_K || entity.field_71088_bW != 0 || entity.func_184218_aH() || entity.func_184207_aI() || !entity.func_184222_aU() || (state = (IPortalState)entity.getCapability(CapabilityPortalState.PORTAL_STATE, null)) != null && state.isInPortal() || !this.isOpen())) {
            if (this.linkInvalid && !TAConfig.fracturesAlwaysTeleport.getValue().booleanValue()) {
                if (this.field_70170_p.func_82737_E() % 20L == 0L && entity instanceof EntityPlayer) {
                    ((EntityPlayer)entity).func_146105_b((ITextComponent)new TextComponentTranslation("thaumicaugmentation.text.no_fracture_target", new Object[0]), true);
                }
            } else if (this.linkedTo != null) {
                WorldServer targetWorld = null;
                try {
                    targetWorld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.linkedDim);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (!this.linkLocated || targetWorld == null) {
                    BlockPos yAdjusted;
                    BlockPos check;
                    int y;
                    BlockPos toComplete2;
                    if (targetWorld != null) {
                        toComplete2 = this.linkedTo;
                        this.verifyChunk((World)targetWorld, toComplete2);
                        for (y = targetWorld.func_72940_L() - 1; y >= 0; --y) {
                            check = toComplete2.func_177982_a(0, y, 0);
                            for (EntityDimensionalFracture fracture : targetWorld.func_72872_a(EntityDimensionalFracture.class, new AxisAlignedBB(check))) {
                                yAdjusted = new BlockPos(fracture.getLinkedPosition().func_177958_n(), this.func_180425_c().func_177956_o(), fracture.getLinkedPosition().func_177952_p());
                                if (!this.func_174813_aQ().func_72326_a(new AxisAlignedBB(yAdjusted))) continue;
                                fracture.open(true);
                                this.linkedTo = check.func_177979_c(2);
                                this.linkLocated = true;
                                break;
                            }
                            if (this.linkLocated) break;
                        }
                    }
                    if (!this.linkLocated || targetWorld == null) {
                        ThaumicAugmentation.getLogger().warn("A fracture is invalid, due to the destination lacking a fracture. This is probably a result of adding/removing dimensions. Recalculating fracture...");
                        ThaumicAugmentation.getLogger().debug("Dest dim: " + (targetWorld != null ? Integer.valueOf(targetWorld.field_73011_w.getDimension()) : "null"));
                        ThaumicAugmentation.getLogger().debug("Dest pos (not including y): " + this.linkedTo);
                        ThaumicAugmentation.getLogger().debug("Src pos: " + this.func_180425_c());
                        FractureUtils.redoFractureLinkage(this);
                        try {
                            targetWorld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.linkedDim);
                        }
                        catch (IllegalArgumentException toComplete2) {
                            // empty catch block
                        }
                        if (targetWorld == null) {
                            ThaumicAugmentation.getLogger().warn("Fracture relink failed. The requested dimension (" + this.linkedDim + ") was not able to be used.");
                            this.linkInvalid = true;
                            return;
                        }
                        toComplete2 = this.linkedTo;
                        this.verifyChunk((World)targetWorld, toComplete2);
                        for (y = targetWorld.func_72940_L() - 1; y >= 0; --y) {
                            check = toComplete2.func_177982_a(0, y, 0);
                            for (EntityDimensionalFracture fracture : targetWorld.func_72872_a(EntityDimensionalFracture.class, new AxisAlignedBB(check))) {
                                yAdjusted = new BlockPos(fracture.getLinkedPosition().func_177958_n(), this.func_180425_c().func_177956_o(), fracture.getLinkedPosition().func_177952_p());
                                if (!this.func_174813_aQ().func_72326_a(new AxisAlignedBB(yAdjusted))) continue;
                                fracture.open(true);
                                this.linkedTo = check.func_177979_c(2);
                                this.linkLocated = true;
                                break;
                            }
                            if (this.linkLocated) break;
                        }
                        if (!this.linkLocated) {
                            ThaumicAugmentation.getLogger().warn("Fracture relink failed. This is probably due the fracture in the void pointing to a new dimension.");
                            this.linkInvalid = true;
                            return;
                        }
                    }
                }
                if (!targetWorld.func_175723_af().func_177746_a(this.linkedTo)) {
                    if (this.field_70170_p.func_82737_E() % 20L == 0L && entity instanceof EntityPlayer) {
                        ((EntityPlayer)entity).func_146105_b((ITextComponent)new TextComponentTranslation("thaumicaugmentation.text.no_fracture_target", new Object[0]), true);
                    }
                } else {
                    this.verifyChunk((World)targetWorld, this.linkedTo);
                    if (!TAConfig.fracturesAlwaysTeleport.getValue().booleanValue() && targetWorld.func_72872_a(EntityDimensionalFracture.class, new AxisAlignedBB(this.linkedTo)).isEmpty()) {
                        ThaumicAugmentation.getLogger().warn("A fracture is invalid, due to the destination lacking a fracture. This fracture has passed verification before, suggesting that either the destination fracture was removed or new linkable dimensions were introduced to the world.");
                        ThaumicAugmentation.getLogger().debug("Dest dim: " + targetWorld.field_73011_w.getDimension());
                        ThaumicAugmentation.getLogger().debug("Dest pos (not including y): " + this.linkedTo);
                        ThaumicAugmentation.getLogger().debug("Src pos: " + this.func_180425_c());
                        this.linkInvalid = true;
                    } else {
                        if (targetWorld.field_73011_w.getDimension() != entity.field_71093_bK) {
                            entity = entity.changeDimension(targetWorld.field_73011_w.getDimension(), (ITeleporter)new DimensionalFractureTeleporter(this.linkedTo));
                        } else if (entity instanceof EntityPlayerMP) {
                            ((EntityPlayerMP)entity).field_71135_a.func_147364_a((double)this.linkedTo.func_177958_n(), (double)this.linkedTo.func_177956_o(), (double)this.linkedTo.func_177952_p(), entity.field_70177_z, entity.field_70125_A);
                        } else {
                            entity.func_70012_b((double)this.linkedTo.func_177958_n(), (double)this.linkedTo.func_177956_o(), (double)this.linkedTo.func_177952_p(), entity.field_70177_z, entity.field_70125_A);
                        }
                        this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        targetWorld.func_184133_a(null, this.linkedTo, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        if (entity != null) {
                            entity.field_71088_bW = entity.func_82147_ab();
                            PortalStateManager.markEntityInPortal(entity);
                        }
                    }
                }
            }
        }
    }

    public void func_70071_h_() {
        Object state;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && ((Boolean)this.func_184212_Q().func_187225_a(OPEN)).booleanValue() && this.field_70170_p.func_82737_E() % 20L == 0L && this.field_70170_p.func_82736_K().func_82766_b("doMobSpawning") && this.field_70170_p.field_73012_v.nextInt(2000) < this.field_70170_p.func_175659_aa().func_151525_a() && (this.field_70170_p.func_175677_d(this.func_180425_c().func_177977_b(), false) || this.field_70170_p.func_175677_d(this.func_180425_c().func_177979_c(2), false))) {
            EntityTAEldritchGuardian guardian = new EntityTAEldritchGuardian(this.field_70170_p);
            guardian.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p.field_73012_v.nextInt(360), 0.0f);
            guardian.func_110149_m(guardian.func_110139_bj() + (float)guardian.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() / 2.0f);
            guardian.field_71088_bW = guardian.func_82147_ab();
            state = (IPortalState)guardian.getCapability(CapabilityPortalState.PORTAL_STATE, null);
            if (state != null) {
                state.setInPortal(true);
            }
            guardian.func_180482_a(this.field_70170_p.func_175649_E(guardian.func_180425_c()), null);
            this.field_70170_p.func_72838_d((Entity)guardian);
        }
        if (!this.field_70170_p.field_72995_K) {
            RayTraceResult blockCheck = this.field_70170_p.func_72933_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v), new Vec3d(this.field_70165_t, this.field_70163_u + 2.0, this.field_70161_v));
            if (blockCheck != null && blockCheck.func_178782_a() != null && !this.field_70170_p.func_175623_d(blockCheck.func_178782_a()) && (state = this.field_70170_p.func_180495_p(blockCheck.func_178782_a())).func_185887_b(this.field_70170_p, blockCheck.func_178782_a()) >= 0.0f && state.func_177230_c().func_176209_a((IBlockState)state, false)) {
                this.field_70170_p.func_175655_b(blockCheck.func_178782_a(), false);
            }
            for (Entity entity : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ())) {
                if (entity.field_70128_L || entity instanceof EntityFocusCloud || entity instanceof EntityAreaEffectCloud) continue;
                this.onCollide(entity);
            }
            if (!this.field_70128_L && this.field_70173_aa % 300 == 0) {
                this.func_184185_a(SoundsTC.evilportal, 0.1f + this.field_70146_Z.nextFloat() / 5.0f, 0.75f + this.field_70146_Z.nextFloat() / 2.0f);
            }
            if (this.isOpening()) {
                for (int i = 0; i < 16; ++i) {
                    TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.SMOKE_SPIRAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70130_N / 2.0f, this.field_70146_Z.nextInt(360), this.field_70163_u - 1.0, 2236207.0), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.getDimension(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
                }
                if (this.field_70173_aa % 5 == 0) {
                    TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.CURLY_WISP, this.field_70165_t + this.field_70146_Z.nextGaussian() / 4.0, this.field_70163_u + this.field_70146_Z.nextGaussian() / 2.0 + 1.0, this.field_70161_v + this.field_70146_Z.nextGaussian() / 4.0), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.getDimension(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
                }
            }
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(OPEN, (Object)false);
        this.field_70180_af.func_187214_a(TIME_OPENED, (Object)Optional.of((Object)new UUID(0L, Long.MAX_VALUE)));
        this.field_70180_af.func_187214_a(LINKED_BIOME, (Object)NULL_BIOME);
    }

    @Override
    public void setLinkedPosition(BlockPos pos) {
        this.linkedTo = pos;
    }

    @Override
    public BlockPos getLinkedPosition() {
        return this.linkedTo;
    }

    @Override
    public void setLinkedDimension(int dim) {
        this.linkedDim = dim;
    }

    @Override
    public int getLinkedDimension() {
        return this.linkedDim;
    }

    @Override
    public void setLinkLocated() {
        this.setLinkLocated(true);
    }

    @Override
    public void setLinkLocated(boolean located) {
        this.linkLocated = located;
    }

    @Override
    public boolean wasLinkLocated() {
        return this.linkLocated;
    }

    @Override
    public void setLinkInvalid() {
        this.setLinkInvalid(true);
    }

    @Override
    public void setLinkInvalid(boolean invalid) {
        this.linkInvalid = invalid;
    }

    @Override
    public boolean isLinkInvalid() {
        return this.linkInvalid;
    }

    @Override
    public void open() {
        this.open(false);
    }

    @Override
    public void open(boolean skipTransition) {
        this.field_70180_af.func_187227_b(OPEN, (Object)true);
        this.field_70180_af.func_187227_b(TIME_OPENED, (Object)Optional.of((Object)new UUID(0L, this.field_70170_p.func_82737_E() - (long)(skipTransition ? 360 : 0))));
    }

    @Override
    public int getOpeningDuration() {
        return 360;
    }

    @Override
    public void close() {
        this.func_184212_Q().func_187227_b(OPEN, (Object)false);
    }

    @Override
    public boolean isOpening() {
        return (Boolean)this.func_184212_Q().func_187225_a(OPEN) != false && this.field_70170_p.func_82737_E() < ((UUID)((Optional)this.func_184212_Q().func_187225_a(TIME_OPENED)).get()).getLeastSignificantBits() + 360L;
    }

    @Override
    public boolean isOpen() {
        return (Boolean)this.func_184212_Q().func_187225_a(OPEN) != false && this.field_70170_p.func_82737_E() >= ((UUID)((Optional)this.func_184212_Q().func_187225_a(TIME_OPENED)).get()).getLeastSignificantBits() + 360L;
    }

    @Override
    public long getTimeOpened() {
        return ((UUID)((Optional)this.func_184212_Q().func_187225_a(TIME_OPENED)).get()).getLeastSignificantBits();
    }

    @Override
    @Nullable
    public Biome getDestinationBiome() {
        if (this.linkedBiome == null && this.field_70170_p.field_72995_K) {
            this.linkedBiome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation((String)this.field_70180_af.func_187225_a(LINKED_BIOME)));
        }
        return this.linkedBiome;
    }

    @Override
    public void setDestinationBiome(@Nullable Biome biome) {
        this.linkedBiome = biome;
        this.field_70180_af.func_187227_b(LINKED_BIOME, (Object)(this.linkedBiome != null ? this.linkedBiome.getRegistryName().toString() : NULL_BIOME));
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_150297_b("linkedPos", 11)) {
            this.linkedDim = compound.func_74762_e("linkedDim");
            int[] pos = compound.func_74759_k("linkedPos");
            this.linkedTo = new BlockPos(pos[0], pos[1], pos[2]);
            this.linkLocated = compound.func_74767_n("linkLocated");
            this.linkInvalid = compound.func_74767_n("linkInvalid");
            this.field_70180_af.func_187227_b(OPEN, (Object)compound.func_74767_n("open"));
            this.field_70180_af.func_187227_b(TIME_OPENED, (Object)Optional.of((Object)new UUID(0L, compound.func_74763_f("timeOpened"))));
            String biome = compound.func_74779_i("linkedBiome");
            String string = biome = biome.isEmpty() ? NULL_BIOME : biome;
            if (!biome.equals(NULL_BIOME)) {
                this.linkedBiome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(biome));
            }
            this.field_70180_af.func_187227_b(LINKED_BIOME, (Object)biome);
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        if (this.linkedTo != null) {
            compound.func_74768_a("linkedDim", this.linkedDim);
            compound.func_74783_a("linkedPos", new int[]{this.linkedTo.func_177958_n(), this.linkedTo.func_177956_o(), this.linkedTo.func_177952_p()});
            compound.func_74757_a("linkLocated", this.linkLocated);
            compound.func_74757_a("linkInvalid", this.linkInvalid);
            compound.func_74757_a("open", ((Boolean)this.func_184212_Q().func_187225_a(OPEN)).booleanValue());
            compound.func_74772_a("timeOpened", ((UUID)((Optional)this.func_184212_Q().func_187225_a(TIME_OPENED)).get()).getLeastSignificantBits());
            compound.func_74778_a("linkedBiome", this.linkedBiome != null ? this.linkedBiome.getRegistryName().toString() : NULL_BIOME);
        }
    }

    public boolean func_189652_ae() {
        return true;
    }

    public boolean func_70027_ad() {
        return false;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public void func_70015_d(int seconds) {
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
    }
}

